/***************************************************************************
                          distroaccess.h  -  description
                             -------------------
    begin                : Mon Apr 29 2002
    copyright            : (C) 2002 by Argo Vessmann (ARTEC Design)
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DISTROACCESS_H
#define DISTROACCESS_H

#include <qstring.h>
#include <qfile.h>

#include <serialport.h>
#include <netmoscard.h>


#define DISTRO_TYPE_REDHAT72	0
#define DISTRO_TYPE_SUSE73	1
#define DISTRO_TYPE_MANDRAKE82	2
#define DISTRO_TYPE_UNKNOWN 	3

#define SUPPORTED_DISTROS	2

#define APP_NO_SETSERIAL	(1<<0)
#define NO_PROC_MOUNTED		(1<<1)

/**
  *@author Argo Vessmann
  */

class distroaccess {
public: 
	distroaccess();
	~distroaccess();
  /** Return's the name of a current distro ( distro on which program is run ) */
  QString distroname();
  /** Return's current distros release number */
  QString ReleaseNumber();
  /** Returns true if this distribution is supported. */
  bool SupportedDistribution();
  /** Sets the distros type. */
  void setDistroType( int d );
  /** Returns a list of serial ports. */
  SerialPortList *ExistingSerialPorts();
  /** Searches the system for existing serial ports. */
  void searchExistingSerialPorts();
  /** Returns the list of Netmos cards that are on this system */
  NetmosCardList *ExistingNetmosCards();
  /** Searches the system for existing NetMos cards. */
  void searchExistingNetmosCards();
  /** List of serials that are valid for netmos cards. */
  QStringList ValidSerials();
  /** Saves configuration. */
  bool saveConf();
  /** Find's init directory. */
  bool FindInitDirectory();
  /** Test if init script exists. If not creates it. */
  bool testInitScript();
  /** Saves serial configuration. */
  bool saveSerialConf( QString *log );
  /** Saves serial configuration. ( for suse 7.3 ) */
  bool saveSerialConfSuse73( QString *log );
  /** Save configuration into /etc/serial.conf */
  bool saveSerialConfRedHatMandrake( QString *log );
  /** Saves parallel configuration. */
  bool saveParallelConf( QString *log );
  /** Searches system for existing parallel ports. */
  void FindExistingParallelPorts( QStringList *io, QStringList *io_hi, QStringList *irq );
  /** Returns TRUE if this given port ( p ) is port on netmos card. */
  bool isNetmosPort( int p );
  /** Activates new parallel configuration. */
  bool restartParallel();
  /** Activates new serial configuration. */
  bool restartSerial();
  /** Removes with setserial old netmoscards serial configuration. */
  void removeOldSerialConf();
  /** Return's device files group for current distribution. */
  char * getDevGroup();
  /** Return's device files owner for current distribution. */
  char * getDevOwner();
  /** Test if this system has all components */
  bool testSystem();
  /** Returns last error message as QString */
  QString ErrorMsg();
  /** Checks if given two serial ports are acceptable. */
  bool suitableSerials( QString *s1, QString *s2 );
  /** Returns a README as a string ( for Welcome screen ) */
  QString README();
  /** Returns a message to displaying after successful configuration */
  QString saveOkMsg();
protected: // Protected methods
  /** Try's to figure out on which distribution program is run. */
  void IdentifyDistro();
  /** Reads an open issue fail and trys to identify Distribution. */
  void IdentifyDistroByIssue( QFile *f );
  /** Reads in a open file /etc/redhat-release and trys to identify current Distribution. */
  void IdentifyDistroByRedhatrelease( QFile *f );
  /** Specifies which type of distro access we use. */
  int distrotype, realdistrotype;
  /** Reads an open release file and trys to identify Distribution. */
  void IdentifyDistroBySuserelease( QFile *f );
  /** Searches wether a program with given name exists in system or not.
  Returns a full path to program. */
  QString FindApp( QString s );
protected: // Protected attributes
  /** Release name as a QString */
  QString d_name;
  /** Release number as a QString */
  QString rel_number;
  /** Full path to setserial command */
  QString setserial_cmnd;
  /** Full path to modprobe */
  QString modprobe;
  /** Full path to rmmod */
  QString rmmod;
  /** List of existing netmos cards */
  NetmosCardList netmoscards;
  /** List of existing netmos cards */
  SerialPortList serialports;
  /** Location of procfs */
  QString procfs;
  /** Mark that the fail was modified */
  bool etc_serial_conf; // /etc/serial.conf
  bool etc_initd_serial; // /etc/init.d/<serial init script>
  bool etc_modules_conf; // /etc/modules.conf
private: // Private methods
  /** Finds all the configured serials that belong to netmos cards. */
  void FindSameNetmosSerials();
  /** Executes a given command. And returns its return value */
  int execsyscmnd( QString cmnd );
public: // Public attributes
  /** Init.d direcotry */
  QString initddir;
  /** Path to rcscript. */
  QString rcscript;
  /** Last error msg */
  QString errormsg;
private: // Private methods
  /** Test if we have LPT module */
  bool testLPTModule();
  /** Test if we have a proc filesystem */
  bool testProcFs();
  /** Test if we have root privileges */
  bool testIsRootId();
  /** Test if we modprobe */
  bool testModprobe();
  /** Test if we rmmod */
  bool testRmmod();
  /** Test if we have serial support */
  bool testSerial();
  /** Test that we have a netmos card */
  bool testNetmosCards();
  QStringList readFileToLines( QString fname );
  QString distributor();
};

#endif
