/***************************************************************************
                          netmoscard.h  -  description
                             -------------------
    begin                : Fri May 3 2002
    copyright            : (C) 2002 by Argo Vessmann (ARTEC Design)
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NETMOSCARD_H
#define NETMOSCARD_H

#include <qvaluelist.h>
extern "C" {
#include <pci/pci.h>
}

#include <qlistview.h>

#include "serialport.h"

/**
  *@author Argo Vessmann
  */

struct nmdefsstr {
	int	devid;
	int	ios;
	int 	types[6];
};

#define NM_NO	0
#define NM_SER	1
#define NM_PRN	2
#define NM_ECPP	3
#define NM_DEV	4

#define NM_VENDOR_ID	0x9710

class NetmosCard {
public: 
	NetmosCard();
	~NetmosCard();
  void debug( void );
  /** Initialise this card from pci device. */
  void init( struct pci_dev *dev );
  /** Returns TRUE if info is valid */
  bool isValid();
  /** Creats a listview item into listview parent */
  void newListViewItem( QListView *parent );
  /** Returns an information string about current card */
  QString InfoStrForNewt();
  /** Returns cards name ( Nm<NR>CV ) */
  QString CardName();
  /** Returns cards pci id */
  QString CardID();
  /** Returns TRUE if this card has one or many serial ports */
  bool hasSerials();
  /** Returns TRUE if this card has two serial Ports. */
  bool has2SerialPorts();
  /** Returns true if given serial port is configured to this card. Also remembers to
himself this port. */
  bool hasExistingSerial( SerialPort *sp );
  /** Returns a string of serial devices name of serial port on netmoscard. */
  QString serialDevName( int nr );
  /** Returns the serial ports speed number. nr says which port on netmos card is used. */
  int serialDevSpeed( int nr );
  /** Returns true if this ( nr ) port on this card is already configured. */
  bool isSerialConfigured( int nr );
  /** Print into string current cards configuration. This string is displayed to user with QTextView. ( as a rich text ). */
  void sprintConfiguration( QString *s );
  /** Sets this cards nr serial port to serialport sp. */
  void setSerial( int nr, SerialPort *sp );
  /** Returns the serial port that is configured as serial port nr on netmos card. */
  SerialPort *GetConfiguredSerialPort(int nr);
  /** Returns true if this card has parallel number nr and it's ECP is enabled. */
  bool parallelECP( int nr );
  /** Returns TRUE if this card has parallel nr and it is enabled. */
  bool parallelenabled( int nr );
  /** Returns true if this card has parallel with number nr. */
  bool hasParallel( int nr );
  /** Sets ECP enabled or nor. */
  void setParallelECP( int nr, bool enab );
  /** Set wether the parallel is enabled or not. */
  void setParallel( int nr, bool enab );
  /** Returns nr parallel port as a QString. */
  QString getsParallelPort( int nr );
  /** Returns nr parallel irq as a QString. */
  QString getsIrq();
  /** Returns nr parallel hi-port as a QString. */
  QString getsParallelPortHi( int nr );
  /** Returns TRUE if given port belongs to us. */
  bool isNetmosPort( int p );
  /** Returns true when this card is already configured */
  bool fixedConf();
  /** Set's that this card is already configured or not */
  void setFixedConf( bool v );
private: // Private attributes
  /** Wether this is a valid netmos card */
  bool valid;
  /** Current cards definition */
  struct nmdefsstr *definition;
  /** I/O ports */
  int ioports[6];
  /** It's true when corresponding Parallel port is enabled */
  bool parenabled[6];
  /** It's true when corresponding ECP on parallel is enabled */
  bool ecpenabled[6];
  /** Serial ports */
  SerialPort *serports[6];
  /** PCI bus */
  int bus;
  /** PCI device */
  int dev;
  /** PCI function */
  int func;
  /** IRQ */
  int irq;
  /** If this card is in fixed configuration stat. */
  int _fixedconf;
  /** Sub vendor and device */
  word sub_vendor_id, sub_device_id;
  /** number of parallel and serial ports as read form sub system id */
  int parallel_count, serial_count;
private: // Private methods
  /** Convert external nummeration into classes internal numeration.  */
  int convertnrtoint( int nr, int type );
};

typedef QValueList<NetmosCard> NetmosCardList;

#endif
