/***************************************************************************
                          netmoswiz.h  -  description
                             -------------------
    begin                : Mon Apr 29 2002
    copyright            : (C) 2002 by Argo Vessmann (ARTEC Design)
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NETMOSWIZ_H
#define NETMOSWIZ_H

#include "distroaccess.h"

#include <qwidget.h>
#include <netmoswizbase.h>
#include <netmoscard.h>
#include <qcombobox.h>

/**
  *@author Argo Vessmann
  */

class Netmoswiz : public netmoswizbase  {
   Q_OBJECT
public: 
	Netmoswiz(QWidget *parent=0, const char *name=0);
	~Netmoswiz();
  /** Reimplemented showPage */
  void showPage( QWidget *page);
  /** Enables/Disables second serial port configuration. */
  void enableSecondSerial( bool t );
  /** Fills a wizards page for configuration. */
  void fillPgCardConf( QWidget *page );
  /** Fills already configured serial values. */
  void fillSerialValues( int nr, QComboBox *dev, QComboBox *sp );
  /** Read given configuration of one serial port. */
  void readOneSerialConf( int nr, QComboBox *dev, QComboBox *sp);
  /** Reads parameters of one parallel port. */
  void readOneParallelConf( int nr, QCheckBox *enab, QCheckBox *ecp );
public: // Public attributes
  /** An object throw which all accesses to distribution are done. */
  distroaccess Distro;
protected slots: // Protected slots
  /** No descriptions */
  void newClosestDistro(int d);
protected: // Protected methods
  /** Show error message that we don't have an needed application. */
  void ErrorNoApp( int app );
  /** Show error message that we don't have any netmos cards. */
  void ErrorNoCards();
  /** When back is clicked */
  void back();
  /** When next is clicked */
  void next();
  /** Tests if the system has all parts we are needinig */
  void SysError( void );
private: // Private attributes
  /** Current card that we are configuring. */
#if ( QT_VERSION >= 300 )
  NetmosCardList::iterator currentcard;
#else
  NetmosCardList::Iterator currentcard;
#endif
public slots: // Public slots
  /** Serial device has changed on either of serial configurations. */
  void serDevChanged();
  /** Read current configuration */
  void readCurrentConf();
};

#endif
