/***************************************************************************
                          newtwizard.h  -  description
                             -------------------
    begin                : Thu May 9 2002
    copyright            : (C) 2002 by Argo Vessmann (ARTEC Design)
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NEWTWIZARD_H
#define NEWTWIZARD_H


#include "distroaccess.h"

#include <newt.h>

/**Wizard for newt interface.
  *@author Argo Vessmann
  */

#define BUTTON_CANCEL	(1<<0)
#define BUTTON_PREV	(1<<1)
#define BUTTON_NEXT	(1<<2)
#define BUTTON_FINISH	(1<<3)
#define BUTTON_DEFAULT	(BUTTON_CANCEL|BUTTON_PREV|BUTTON_NEXT)


#define PG_WELCOME	1
#define PG_IDENTDISTRO	2
#define PG_INFO		3
#define PG_CARDCONF	4
#define PG_CONFIRM	5
#define PG_FINISH	6

#define PG_ERROR	7

class newtWizard {
public: 
	newtWizard();
	~newtWizard();
	int exec( void );

	int PgWelcome();
	int PgInfo();
	int PgIdentDistro();
	int PgCardConf();
	int PgConfirm();
	int PgFinish();
	int PgError();
	int showPage();
	void baseElements();
	void prepareWizPage( const char *title );
	void cleanupWizPage();
	void addButtons( int which = BUTTON_DEFAULT );
	void fillSerialValues(int, newtComponent, newtComponent, QStringList *, int spcount);
	void readOneSerialConf( int nr, newtComponent dev, newtComponent sp );
	void readOneParallelConf( int nr, newtComponent par, newtComponent ecp );
	QString convertRichText( QString str );

	int maxcols, maxrows;
	int wcols, wrows;
	newtComponent form;
	newtComponent nextbutton, prevbutton, cancelbutton, finishbutton;
	newtComponent current;
	int prevpage, nextpage, currentpage;

	distroaccess Distro;
#if ( QT_VERSION >= 300 )
	NetmosCardList::iterator currentcard;
#else
	NetmosCardList::Iterator currentcard;
#endif

};

#endif
