/***************************************************************************
                          serialport.h  -  description
                             -------------------
    begin                : Thu May 2 2002
    copyright            : (C) 2002 by Argo Vessmann (ARTEC Design)
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SERIALPORT_H
#define SERIALPORT_H

#include <qvaluelist.h>
#include <qlistview.h>

/**A class that defines one serial port.
  *@author Argo Vessmann
  */

class SerialPort {
public: 
	SerialPort();
	~SerialPort();
  /** Set's all values to NULL */
  void clean();
  /** Creats a listview item into listview parent */
  void newListViewItem( QListView *parent );
  /** Set's that this port has netmos card nc. */
  void setNetmosCard( bool v );
  /** Returns serial ports device name "/dev/ttySx" */
  QString DevName();
  /** Return's true when this port is on Netmos Card. */
  bool isNetmosPort();
  /** Return's seriaports speed( baud ) */
  int Speed();
  /** Set's a new baud rate. */
  void setSpeed( int speed );
  /** Saves current serial port into Suse's rc script. */
  void saveForSuse73( QStringList *list, QString *log );
  /** Test if device file for this serial port exists. If not creates it. Writes log about actions into str. */
  bool testDeviceFile( QString *str, const char *owner, const char *group  );
  /** Saves serial configuration into RedHat/Mandrake serial configuration file. */
  void saveForMandrakeRedHat( QStringList *lines, QString *log );
  /** Returns true if this is detected port. */
  bool isDetected();
  /** Set's wether this is detected port. */
  void setDetected( bool b );
  /** Returns true if this is system port ( not NetMos port ). */
  bool isSystemPort();
  /** Set's wether this is system port or NetMos port. */
  void setSystemPort( bool b );
  /** Returns an info string about this port */
  QString InfoStrForNewt();
public: // Public attributes
  /** Serial ports IRQ */
  int irq;
  /** Serial ports I/O */
  int io;
  /** Serial ports baud rate. */
  int baud;
  /** Serial ports uart. */
  QString uart;
  /** Port number */
  int port;
private: // Private attributes
  /** Is true when this is port on netmos card. */
  bool _isnetmosport;
  /** Set to TRUE if this is detected port. */
  bool detected;
  /** Set to TRUE if this is system port. (not NetMos port) */
  bool _systemport;
};

typedef QValueList<SerialPort> SerialPortList;

#endif
