/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.service.DllLogFileService;
import com.ray.wing.resorep.service.DllSettingsService;
import com.ray.wing.resorep.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DllLogFileServiceImpl
implements DllLogFileService {
    private static final String DLL_LOG_FILE_PATH_PROPERTY = "dll_log_file";
    private static final String DEFAULT_DLL_LOG_FILE_NAME = "resorepDll.log";
    @Autowired
    private DllSettingsService dllSettingsService;

    @Override
    public String getDllLogFilePath() throws IOException {
        String result = this.dllSettingsService.getPropertyString(DLL_LOG_FILE_PATH_PROPERTY);
        if (result == null || result.isEmpty()) {
            result = FileUtils.appendSlashIfRequired(new File(".").getCanonicalPath()) + DEFAULT_DLL_LOG_FILE_NAME;
            this.dllSettingsService.setPropertyString(DLL_LOG_FILE_PATH_PROPERTY, result);
        }
        return result;
    }

    @Override
    public void setDllLogFilePath(String value) throws IOException {
        this.dllSettingsService.setPropertyString(DLL_LOG_FILE_PATH_PROPERTY, value);
    }
}

