/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.service.SettingsService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SettingsServiceImpl
implements SettingsService {
    protected abstract File getSettingsFile() throws IOException;

    protected abstract Charset getSettingsFileCharset();

    @Override
    public String getPropertyString(String propertyName) throws IOException {
        File settingsFile = this.getSettingsFile();
        if (!settingsFile.exists()) {
            return "";
        }
        return Files.readAllLines(settingsFile.toPath()).stream().filter(s -> s.startsWith(propertyName + "=")).findFirst().orElse("").replace(propertyName + "=", "");
    }

    @Override
    public void setPropertyString(String propertyName, String value) throws IOException {
        File settingsFile = this.getSettingsFile();
        boolean[] foundAndReplaced = new boolean[]{false};
        List modifiedSettings = Files.readAllLines(settingsFile.toPath()).stream().map(s -> {
            if (s.startsWith(propertyName + "=")) {
                foundAndReplaced[0] = true;
                return propertyName + "=" + value;
            }
            return s;
        }).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (!foundAndReplaced[0]) {
            modifiedSettings.add(propertyName + "=" + value);
        }
        Files.write(settingsFile.toPath(), modifiedSettings, this.getSettingsFileCharset(), StandardOpenOption.TRUNCATE_EXISTING);
    }
}

