/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.exception.UpdateException;
import com.ray.wing.resorep.service.UpdateService;
import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class UpdateServiceImpl
implements UpdateService {
    private static final Logger log = LoggerFactory.getLogger(UpdateServiceImpl.class);
    private static final String VERSION_PREFIX = "Latest Resorep version is ";
    @Autowired
    private MessageSource messageSource;

    @Override
    public boolean isNewVersionAvailable(String version) throws IOException, UpdateException {
        return this.getNewVersionString().compareToIgnoreCase(version) > 0;
    }

    @Override
    public String getNewVersionUrl() {
        return this.messageSource.getMessage("dialog.update.url", null, LocaleContextHolder.getLocale());
    }

    @Override
    public String getNewVersionString() throws IOException, UpdateException {
        String url = this.messageSource.getMessage("update.version_check_url", null, LocaleContextHolder.getLocale());
        Document doc = Jsoup.connect(url).get();
        Element versionElement = doc.select("p:contains(Latest Resorep version is )").first();
        if (versionElement == null) {
            throw new UpdateException("Version element is not found");
        }
        String versionH3String = versionElement.text();
        String version = versionH3String.replaceFirst(VERSION_PREFIX, "");
        log.info("{}{}", (Object)VERSION_PREFIX, (Object)version);
        return version;
    }
}

