/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.service.DllSettingsService;
import com.ray.wing.resorep.service.HookedApplicationsService;
import com.ray.wing.resorep.service.impl.SettingsServiceImpl;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DllSettingsServiceImpl
extends SettingsServiceImpl
implements DllSettingsService {
    private static final Charset DLL_SETTINGS_FILE_CHARSET = Charset.forName("UTF-8");
    @Value(value="${dll.settings.file}")
    private String dllSettingsFileName;
    @Autowired
    private HookedApplicationsService hookedApplicationsService;

    @Override
    public void setPropertyString(String propertyName, String value) throws IOException {
        super.setPropertyString(propertyName, value);
        this.updateSettingsFileForAllHookedApplications();
    }

    private void updateSettingsFileForAllHookedApplications() {
        this.hookedApplicationsService.getHookedApplications().forEach(app -> {
            File file = new File(app.getExecutablePath());
            if (file.exists()) {
                File gameFolder = file.getParentFile();
                try {
                    this.copyDllSettingsToGameFolder(gameFolder);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    protected Charset getSettingsFileCharset() {
        return DLL_SETTINGS_FILE_CHARSET;
    }

    @Override
    protected File getSettingsFile() throws IOException {
        File settingsFile = new File(new File("."), this.dllSettingsFileName);
        settingsFile.createNewFile();
        return settingsFile;
    }

    @Override
    public Boolean getPropertyBoolean(String propertyName) throws IOException {
        return Boolean.valueOf(this.getPropertyString(propertyName));
    }

    @Override
    public List<String> getPropertyValues(String propertyName) throws IOException {
        File settingsFile = this.getSettingsFile();
        if (!settingsFile.exists()) {
            return Collections.emptyList();
        }
        return Files.readAllLines(settingsFile.toPath()).stream().filter(s -> s.startsWith(propertyName + "=")).map(s1 -> s1.replace(propertyName + "=", "")).collect(Collectors.toList());
    }

    @Override
    public void addNonUniqueProperty(String propertyName, String value) throws IOException {
        File settingsFile = this.getSettingsFile();
        this.createFileIfNotExists(settingsFile);
        String optionalNewline = this.endsWithNewLine(settingsFile) ? "" : "\r\n";
        Files.write(settingsFile.toPath(), (optionalNewline + propertyName + "=" + value).getBytes(DLL_SETTINGS_FILE_CHARSET), StandardOpenOption.APPEND);
        this.updateSettingsFileForAllHookedApplications();
    }

    @Override
    public void removeNonUniqueProperty(String propertyName, String valueToRemove) throws IOException {
        File settingsFile = this.getSettingsFile();
        List modifiedSettings = Files.readAllLines(settingsFile.toPath()).stream().map(s -> {
            if (s.startsWith(propertyName + "=") && s.replace(propertyName + "=", "").equals(valueToRemove)) {
                return "";
            }
            return s;
        }).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Files.write(settingsFile.toPath(), modifiedSettings, DLL_SETTINGS_FILE_CHARSET, StandardOpenOption.TRUNCATE_EXISTING);
        this.updateSettingsFileForAllHookedApplications();
    }

    @Override
    public void copyDllSettingsToGameFolder(File gameFolder) throws IOException {
        File dllSettingsFile = new File(this.dllSettingsFileName);
        File dllSettingsFileInGameFolder = new File(gameFolder, this.dllSettingsFileName);
        Files.copy(dllSettingsFile.toPath(), dllSettingsFileInGameFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void removeDllSettingsFileFromGameFolder(File gameDir) throws IOException {
        File dllSettingsFileInGameFolder = new File(gameDir, this.dllSettingsFileName);
        if (dllSettingsFileInGameFolder.exists()) {
            Files.delete(new File(gameDir, this.dllSettingsFileName).toPath());
        }
    }

    private boolean endsWithNewLine(File file) throws IOException {
        RandomAccessFile fileHandler = new RandomAccessFile(file, "r");
        long fileLength = fileHandler.length() - 1L;
        if (fileLength < 0L) {
            fileHandler.close();
            return true;
        }
        fileHandler.seek(fileLength);
        byte readByte = fileHandler.readByte();
        fileHandler.close();
        return readByte == 10 || readByte == 13;
    }

    private void createFileIfNotExists(File file) throws IOException {
        if (!file.exists()) {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
    }
}

