/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixPlatformTools;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class AixExecCmd {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    private static Properties cacheEnvVar = null;
    private boolean collectOutput = false;
    private OutputStream[] outputs = null;
    private int outputType = 0;
    public static final int NORMAL = 1;
    public static final int ERRORS = 2;
    private Process process = null;
    private int result = -1;
    private String __cmd = "";
    private String output = "";
    private String errors = "";
    private String both = "";
    private boolean state = false;
    private String errorMessage = null;

    public AixExecCmd(String command) {
        this(command, (String[])null, 3, null);
    }

    public AixExecCmd(String[] command) {
        this(command, (String[])null, 3, null);
    }

    public AixExecCmd(String[] command, String envOpt) {
        this(command, (String[])null, 3, envOpt);
    }

    public AixExecCmd(String command, String[] logOutputFiles, int which, String envOpt) {
        this(AixPlatformTools.createStringArray(command, " "), logOutputFiles, which, null);
    }

    public AixExecCmd(String[] command, String[] logOutputFiles, int which, String envOpt) {
        this.collectOutput = which != 0;
        this.outputType = which;
        FileOutputStream[] fouts = null;
        if (logOutputFiles != null && logOutputFiles.length > 0) {
            int i = 0;
            fouts = new FileOutputStream[logOutputFiles.length];
            for (i = 0; i < fouts.length; ++i) {
                try {
                    fouts[i] = new FileOutputStream(logOutputFiles[i], true);
                    continue;
                }
                catch (IOException e) {
                    AixPlatformTools.aixDebugLog(1, "Can't open for writing: " + logOutputFiles[i]);
                    fouts = null;
                    break;
                }
            }
            if (which != 0 && fouts != null && (which & 1) != 0) {
                this.output.concat("---> " + logOutputFiles[0]);
                this.both.concat("---> " + logOutputFiles[0]);
            }
        }
        this.outputs = fouts;
        this.runCommand(command, envOpt);
    }

    public AixExecCmd(String command, OutputStream[] outputs, int which) {
        this.collectOutput = which != 0;
        this.outputType = which;
        this.outputs = outputs;
        this.runCommand(AixPlatformTools.createStringArray(command, " "), null);
    }

    private void runCommand(String[] cmd, String envOpt) {
        BufferedReader in = null;
        BufferedReader err = null;
        try {
            this.cmdToString(cmd);
            AixPlatformTools.aixDebugLog(32, " exec'ing command: " + this.__cmd);
            if (envOpt != null && envOpt.trim().length() > 0) {
                AixPlatformTools.aixDebugLog(32, " cmd: setting additional environment variable of: " + envOpt);
                String[] envp = this.changeExistingEnv(envOpt);
                if (envp == null) {
                    envp = new String[]{envOpt};
                }
                this.process = Runtime.getRuntime().exec(cmd, envp);
            } else {
                this.process = Runtime.getRuntime().exec(cmd);
            }
            if (this.process != null) {
                in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                err = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                if (this.collectOutput) {
                    this.readOutput(in, err);
                }
                this.result = this.process.waitFor();
                in.close();
                err.close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
                this.process.getErrorStream().close();
                this.process.destroy();
                this.process = null;
                AixPlatformTools.aixDebugLog(32, " command completed rc: " + this.result);
                this.state = true;
            } else {
                AixPlatformTools.aixDebugLog(1, "AixExecCmd command never started a process.");
            }
        }
        catch (IOException ex) {
            if (this.process == null) {
                this.errorMessage = "AixExecCmd: " + cmd + " failed";
            }
            AixPlatformTools.aixDebugLog(1, "AixExecCmd Error: " + ex);
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            if (this.process == null) {
                this.errorMessage = "AixExecCmd: " + cmd + " failed";
            }
            AixPlatformTools.aixDebugLog(1, "AixExecCmd Error:" + ex);
            ex.printStackTrace();
        }
    }

    public String getCmdString() {
        return this.__cmd;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getState() {
        return this.state;
    }

    public int getResult() {
        return this.result;
    }

    public String getOutput() {
        return this.output;
    }

    public String getErrors() {
        return this.errors;
    }

    public String getAllOutput() {
        return this.both;
    }

    public void readOutput(BufferedReader in, BufferedReader err) {
        String nextLine = null;
        String newLine = System.getProperty("line.separator");
        if (newLine == null) {
            newLine = "\r\n";
        }
        try {
            int logs;
            PrintWriter[] outWriters = null;
            if (this.outputs != null) {
                outWriters = new PrintWriter[this.outputs.length];
                for (int i = 0; i < this.outputs.length; ++i) {
                    outWriters[i] = new PrintWriter(new OutputStreamWriter(this.outputs[i]));
                }
            }
            while ((nextLine = in.readLine()) != null) {
                if ((this.outputType & 1) == 0) continue;
                if (outWriters != null) {
                    for (logs = 0; logs < outWriters.length; ++logs) {
                        outWriters[logs].println(nextLine);
                    }
                    continue;
                }
                this.output = this.output.concat(nextLine + newLine);
                this.both = this.both.concat(nextLine + newLine);
            }
            while ((nextLine = err.readLine()) != null) {
                if ((this.outputType & 2) == 0) continue;
                if (outWriters != null) {
                    for (logs = 0; logs < outWriters.length; ++logs) {
                        outWriters[logs].println(nextLine);
                    }
                    continue;
                }
                this.errors = this.errors.concat(nextLine + newLine);
                this.both = this.both.concat(nextLine + newLine);
            }
            if (outWriters != null) {
                for (logs = 0; logs < outWriters.length; ++logs) {
                    outWriters[logs].flush();
                    outWriters[logs].close();
                    this.outputs[logs].flush();
                    this.outputs[logs].close();
                }
            }
        }
        catch (IOException ex) {
            if (ex instanceof EOFException) {
                return;
            }
            AixPlatformTools.aixDebugLog(1, "AixExecCmd Error:" + ex);
            ex.printStackTrace();
        }
    }

    private void cmdToString(String[] cmd) {
        for (int ix = 0; ix < cmd.length; ++ix) {
            this.__cmd = this.__cmd + cmd[ix] + " ";
        }
    }

    private String[] changeExistingEnv(String newEntry) {
        int ix;
        String[] value = null;
        String newKey = null;
        int isNew = 1;
        if (cacheEnvVar == null) {
            String[] cmd = new String[]{"env"};
            try {
                Process process = Runtime.getRuntime().exec(cmd);
                cacheEnvVar = new Properties();
                cacheEnvVar.load(process.getInputStream());
            }
            catch (Exception e) {
                AixPlatformTools.aixDebugLog(1, "Couldn't acquire env");
                return null;
            }
        }
        if (newEntry != null && newEntry.trim().length() > 0 && (ix = newEntry.indexOf(61)) > 0 && ((Hashtable)cacheEnvVar).containsKey(newKey = newEntry.substring(0, ix))) {
            isNew = 0;
        }
        value = new String[((Hashtable)cacheEnvVar).size() + isNew];
        ix = 0;
        Enumeration<?> e = cacheEnvVar.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (isNew == 0 && key.equals(newKey)) {
                value[ix++] = newEntry;
                continue;
            }
            value[ix++] = key + "=" + cacheEnvVar.getProperty(key);
        }
        if (isNew == 1) {
            value[ix] = newEntry;
        }
        return value;
    }
}

