/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixExecCmd;
import com.ibm.wizard.platform.aix.AixFileUtils;
import com.ibm.wizard.platform.aix.AixPlatformTools;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AixFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    private final int[] ATTRS = new int[]{256, 128, 64, 32, 16, 8, 4, 2, 1};
    private static int SETMODIFIEDTIME = 0;
    private static int SETACCESSTIME = 1;

    public static native int initializeJNI();

    private native int getNativeFileAttributes(String var1);

    private native String getNativeFileOwner(String var1);

    private native String getNativeFileOwnerGroup(String var1);

    private native int setNativeFileModified(String var1, long var2, int var4);

    private native int setNativeFileAttributes(String var1, int var2);

    private native int setNativeFileOwner(String var1, String var2);

    private native int setNativeFileGroup(String var1, String var2);

    private native double getNativePartitionFreeSpace(String var1);

    public int getSystemCompatibility() {
        int result = 0;
        result = AixPlatformTools.isCompatible() ? 5 : 0;
        AixPlatformTools.aixDebugLog(128, "getSystemCompatibility in FileService returning: " + result);
        return result;
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        GenericUnixCommands.createSymbolicLink(target, linkName, forceLink);
    }

    protected void initialized() {
        super.initialized();
        try {
            AixPlatformTools.loadJNILibrary(this.getServices());
        }
        catch (Exception e) {
            AixPlatformTools.aixDebugLog(1, "initialized: failed to call loadJNILibrary()" + e);
        }
    }

    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "deleteDirectory(" + directory + "," + ifEmpty + "," + includeSubDirs + ") in AixFileServiceImpl");
        int result = 0;
        File destDir = new File(directory);
        if (!destDir.exists()) {
            return result;
        }
        if (destDir.isDirectory()) {
            String[] dirFiles = destDir.list();
            for (int ix = 0; ix < dirFiles.length; ++ix) {
                File loc = new File(directory, dirFiles[ix]);
                if (!loc.isFile() && !includeSubDirs) {
                    throw new ServiceException(399, "Unable to remove file: " + destDir.getAbsolutePath() + ". It contains subdirectories");
                }
                result = this.deleteDirectory(loc.getAbsolutePath(), ifEmpty, includeSubDirs);
            }
            if (new File(directory).list().length == 0 && !destDir.delete()) {
                throw new ServiceException(399, "Unable to remove directory: " + destDir.getAbsolutePath());
            }
        } else if (!ifEmpty) {
            if (!destDir.delete()) {
                throw new ServiceException(399, "Unable to remove file: " + destDir.getAbsolutePath());
            }
        } else {
            throw new ServiceException(399, "Unable to remove file: " + destDir.getAbsolutePath() + ". It is not empty");
        }
        return result;
    }

    public void setFileTimes(String fileName, long creationDate, long accessDate, long writeDate) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileTimes(" + fileName + ") in AixFileServiceImpl");
        boolean rc = true;
        this.setFileCreated(fileName, creationDate);
        rc |= this.modifyFileTime(fileName, accessDate, SETACCESSTIME);
        this.setFileModified(fileName, writeDate);
    }

    public void removeSymbolicLink(String linkName) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "removeSymbolicLink in AixFileServiceImpl");
        GenericUnixCommands.removeSymbolicLink(linkName);
    }

    public void setFileCreated(String fileName, long date) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileCreated(" + fileName + "," + date + ") in AixFileServiceImpl");
        boolean rc = this.modifyFileTime(fileName, date, SETMODIFIEDTIME);
    }

    public void setFileModified(String fileName, long date) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileModified(" + fileName + "," + date + ") in AixFileServiceImpl");
        boolean rc = this.modifyFileTime(fileName, date, SETMODIFIEDTIME);
    }

    private boolean modifyFileTime(String fileName, long date, int type) throws ServiceException {
        AixPlatformTools.aixDebugLog(8, "modifyFileTime(" + fileName + "," + date + "," + type + ") in AixFileServiceImpl");
        if (fileName == null || fileName.trim().length() <= 0) {
            throw new ServiceException(314, "Empty fileName value.");
        }
        if (date <= 0L) {
            throw new ServiceException(314, "Empty date value.");
        }
        boolean returnCode = false;
        if (AixPlatformTools.AixJNILoaded) {
            try {
                int result = this.setNativeFileModified(fileName, date, type);
                if (result == -1) {
                    returnCode = false;
                } else {
                    if (result != 0) {
                        throw new ServiceException(315, "setFileModified failed: " + fileName);
                    }
                    returnCode = true;
                }
            }
            catch (ServiceException se) {
                throw new ServiceException(se);
            }
            catch (Exception e) {
                returnCode = false;
            }
        }
        if (!returnCode) {
            AixPlatformTools.aixDebugLog(8, "set file modified old fashion way: " + fileName);
            String _date = AixPlatformTools.toAixDate(date, true);
            String[] command = new String[6];
            int idx = 0;
            command[idx++] = "touch";
            command[idx++] = "-c";
            if (type == SETMODIFIEDTIME) {
                command[idx++] = "-m";
            } else if (type == SETACCESSTIME) {
                command[idx++] = "-a";
            }
            command[idx++] = "-t";
            command[idx++] = _date;
            command[idx++] = fileName;
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() == 0) {
                returnCode = true;
            }
        }
        return returnCode;
    }

    protected String getLibraryDirectory() throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getLibraryDirectory() in AixFileServiceImpl");
        return "/usr/lib";
    }

    protected String getLogFileDirectory() {
        String rootLogDir = "/var/adm/sw";
        String userLogDir = "/var/adm/ras";
        File rootDirectory = new File(rootLogDir);
        File userDirectory = new File(userLogDir);
        AixPlatformTools.aixDebugLog(136, "getLogFileDirectory() in AixFileServiceImpl");
        if (rootDirectory.canWrite()) {
            return rootLogDir;
        }
        if (userDirectory.canWrite()) {
            return userLogDir;
        }
        return "/tmp";
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getStandardInstallDirectory() in AixFileServiceImpl");
        return "/opt";
    }

    protected String getTempDirectory() throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getTempDirectory() in AixFileServiceImpl");
        return "/tmp";
    }

    protected String getHomeDirectory() {
        AixPlatformTools.aixDebugLog(136, "getHomeDirectory() in AixFileServiceImpl");
        return System.getProperty("user.home");
    }

    public boolean isDirectoryWritable(String directory) throws ServiceException {
        if (directory == null || directory.trim().length() == 0) {
            throw new ServiceException(314, "Empty directoryName value.");
        }
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new ServiceException(314, "Directory does not exist.");
        }
        return dir.canWrite();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] getPartitionNames() throws ServiceException {
        String[] items;
        AixPlatformTools.aixDebugLog(136, "getPartitionNames() in AixFileServiceImpl");
        if (System.getProperty("user.name").equals("root")) {
            if (!AixFileUtils.getPartitionData()) throw new ServiceException(2, "Failed to get data for getPartitionNames.");
            int j = 0;
            Vector<String> fsList = new Vector<String>();
            Enumeration e = AixFileUtils.cachePartitionFreeSpace.keys();
            while (e.hasMoreElements()) {
                String fileSystem = (String)e.nextElement();
                if (!fileSystem.startsWith("/")) continue;
                fsList.addElement(fileSystem);
            }
            items = new String[fsList.size()];
            Enumeration ee = fsList.elements();
            while (ee.hasMoreElements()) {
                items[j++] = (String)ee.nextElement();
            }
        } else {
            String _info = "";
            String[] cmdStr = new String[]{"df", "-M"};
            AixExecCmd cmd = new AixExecCmd(cmdStr);
            _info = cmd.getOutput().trim();
            String[] vfs = AixPlatformTools.createStringArray(_info, "\n");
            items = new String[vfs.length - 1];
            String vfsName = "";
            for (int i = 1; i < vfs.length; ++i) {
                String thisVfs = vfs[i];
                thisVfs = thisVfs.trim();
                AixPlatformTools.aixDebugLog(8, "thisVfs from df -M command is " + thisVfs);
                Vector _thisVfs = AixPlatformTools.convertStringToVector(thisVfs, " ");
                items[i - 1] = (String)_thisVfs.elementAt(1);
            }
        }
        AixPlatformTools.aixDebugLog(136, "   - returning partition names: ");
        for (int i = 0; i < items.length; ++i) {
            AixPlatformTools.aixDebugLog(136, "items[" + i + "] is: " + items[i]);
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getPartitionFreeSpace(String partitionName, long requiredSpace) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "Entering AixFileServiceImpl.getPartitionFreeSpace(" + partitionName + "," + requiredSpace + ")");
        String fsData = "";
        long freespace = 0L;
        String userName = System.getProperty("user.name");
        AixPlatformTools.aixDebugLog(8, "In getPartitionFreeSpace user name is: " + userName);
        if (!userName.equals("root")) {
            double fspace = 0.0;
            AixPlatformTools.aixDebugLog(8, "User is not root.  Checking freespace.");
            fspace = this.getNativePartitionFreeSpace(partitionName);
            AixPlatformTools.aixDebugLog(8, "User is not root.  Returning " + (long)fspace + " from getNativePartitionFreeSpace");
            return (long)fspace;
        }
        if (!AixFileUtils.getPartitionData()) throw new ServiceException(2, "Could not get partition data for " + partitionName);
        if (!AixFileUtils.cachePartitionFreeSpace.containsKey(partitionName)) throw new ServiceException(2, "Could not get partition data for " + partitionName);
        fsData = (String)AixFileUtils.cachePartitionFreeSpace.get(partitionName);
        if (fsData == null) throw new ServiceException(2, "No partition data available for " + partitionName);
        if (AixFileUtils.adjustedFreeSpaceCache != null && !AixFileUtils.adjustedFreeSpaceCache.isEmpty() && AixFileUtils.adjustedFreeSpaceCache.containsKey("installing")) {
            AixPlatformTools.aixDebugLog(8, "Calling getPartitionFreeSpace with installing flag in adjustedFreeSpaceCache");
            freespace = Long.parseLong(AixPlatformTools.getFieldFromString(fsData, ":", 1));
            AixPlatformTools.aixDebugLog(8, "Free space available in " + partitionName + " is " + freespace);
            return freespace;
        }
        freespace = this.getAdjustedValueForPartition(partitionName, requiredSpace);
        AixPlatformTools.aixDebugLog(8, "New free space value for file system: " + partitionName);
        AixPlatformTools.aixDebugLog(8, "\t--  is " + freespace);
        AixPlatformTools.aixDebugLog(136, "Leaving AixFileServiceImpl.getPartitionFreeSpace(" + partitionName + "," + requiredSpace + ")");
        return freespace;
    }

    private long getAdjustedValueForPartition(String partitionName, long requiredSpace) {
        long freespace = 0L;
        long fsfree = 0L;
        long blockSize = 0L;
        long vgfree = -999L;
        long extraSpace = 0L;
        String fsData = (String)AixFileUtils.cachePartitionFreeSpace.get(partitionName);
        String vgroup = AixPlatformTools.getFieldFromString(fsData, ":", 5);
        fsfree = Long.parseLong(AixPlatformTools.getFieldFromString(fsData, ":", 1));
        AixPlatformTools.aixDebugLog(8, "Before adjusting, fsfree is: " + fsfree);
        blockSize = Long.parseLong(AixPlatformTools.getFieldFromString(fsData, ":", 2));
        if (AixFileUtils.adjustedFreeSpaceCache != null && !AixFileUtils.adjustedFreeSpaceCache.isEmpty()) {
            if (AixFileUtils.adjustedFreeSpaceCache.containsKey(vgroup)) {
                vgfree = Long.parseLong((String)AixFileUtils.adjustedFreeSpaceCache.get(vgroup));
            }
            if (AixFileUtils.adjustedFreeSpaceCache.containsKey(partitionName)) {
                AixPlatformTools.aixDebugLog(2, "File system expansion hit duplicate partition name.  Overriding and continuing.");
                String data = (String)AixFileUtils.adjustedFreeSpaceCache.get(partitionName);
                long spaceAvail = Long.parseLong(AixPlatformTools.getFieldFromString(data, ":", 1));
                vgfree += spaceAvail;
                AixFileUtils.adjustedFreeSpaceCache.remove(partitionName);
            }
        }
        if (vgfree == -999L) {
            if (AixFileUtils.cachePartitionFreeSpace.containsKey(vgroup)) {
                vgfree = Long.parseLong((String)AixFileUtils.cachePartitionFreeSpace.get(vgroup));
            } else {
                vgfree = 0L;
                String vfsType = AixPlatformTools.getFieldFromString(fsData, ":", 3).trim();
                if (AixPlatformTools.getFieldFromString(fsData, ":", 4).equals("ro")) {
                    this.log(this, "wrn", LocalizedStringResolver.resolve("com.ibm.wizard.platform.aix.i18n.AixResources", "writePermissionDenied", new String[]{partitionName, AixPlatformTools.getFieldFromString(fsData, ":", 3)}));
                    return 0L;
                }
                if (vfsType.startsWith("afs") || vfsType.startsWith("dfs")) {
                    AixFileUtils.adjustedFreeSpaceCache.put(partitionName, vfsType);
                    return requiredSpace;
                }
            }
        }
        AixPlatformTools.aixDebugLog(8, "In getPartitionFreeSpace, called prior to preInstallProduct. Values are: ");
        AixPlatformTools.aixDebugLog(8, "\t-- fsfree: " + fsfree + " blockSize: " + blockSize + " vgroup: " + vgroup + " vgfree: " + vgfree + " requiredSpace-with buffer-: " + (requiredSpace += blockSize / 2L));
        if (requiredSpace > fsfree) {
            if (blockSize != 0L && requiredSpace % blockSize != 0L) {
                requiredSpace += blockSize - requiredSpace % blockSize;
            }
            extraSpace = requiredSpace - fsfree;
            AixPlatformTools.aixDebugLog(8, "Need extra space in " + partitionName + " extraSpace: " + extraSpace);
            if (extraSpace < vgfree) {
                fsfree += extraSpace;
            } else {
                extraSpace = 0L;
            }
        }
        freespace = fsfree;
        AixFileUtils.adjustedFreeSpaceCache.put(partitionName, String.valueOf(fsfree) + ":" + String.valueOf(extraSpace));
        AixPlatformTools.aixDebugLog(8, "Value in adjustedFreeSpaceCache for " + partitionName + ": " + (String)AixFileUtils.adjustedFreeSpaceCache.get(partitionName));
        if (!vgroup.equals("NONE")) {
            AixFileUtils.adjustedFreeSpaceCache.put(vgroup, String.valueOf(vgfree - extraSpace));
            AixPlatformTools.aixDebugLog(8, "Value in adjustedFreeSpaceCache for " + vgroup + ": " + (String)AixFileUtils.adjustedFreeSpaceCache.get(vgroup));
        }
        return freespace;
    }

    public long getPartitionFreeSpace(String partitionName) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getPartitionFreeSpace(" + partitionName + ") in AixFileServiceImpl");
        if (partitionName == null || partitionName.trim().length() <= 0) {
            throw new ServiceException(314, "Empty partitionName value.");
        }
        long freespace = 0L;
        String userName = System.getProperty("user.name");
        AixPlatformTools.aixDebugLog(8, "In getPartitionFreeSpace user name is: " + userName);
        if (!userName.equals("root")) {
            double fspace = 0.0;
            AixPlatformTools.aixDebugLog(8, "User is not root.  Checking freespace.");
            fspace = this.getNativePartitionFreeSpace(partitionName);
            AixPlatformTools.aixDebugLog(8, "User is not root.  Returning " + (long)fspace + " from getNativePartitionFreeSpace");
            return (long)fspace;
        }
        if (AixFileUtils.getPartitionData()) {
            String fsData;
            if (AixFileUtils.cachePartitionFreeSpace.containsKey(partitionName) && (fsData = (String)AixFileUtils.cachePartitionFreeSpace.get(partitionName)) != null) {
                freespace = Long.parseLong(AixPlatformTools.getFieldFromString(fsData, ":", 1));
            }
        } else {
            throw new ServiceException(2, "Failed to get data for getPartitionFreeSpace.");
        }
        AixPlatformTools.aixDebugLog(136, "  - size of " + partitionName + " is:" + freespace);
        return freespace;
    }

    public FileAttributes getFileAttributes(String file) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getFileAttributes(" + file + ") in AixFileServiceImpl");
        if (file == null || file.trim().length() <= 0) {
            throw new ServiceException(314, "Empty file value.");
        }
        boolean returnCode = false;
        FileAttributes file_attrs = new FileAttributes();
        if (AixPlatformTools.AixJNILoaded) {
            int mode = this.getNativeFileAttributes(file);
            if (mode == -1) {
                AixPlatformTools.aixDebugLog(8, "Returned -1 from jni in getFileAttributes");
                returnCode = false;
            } else {
                returnCode = true;
            }
            if (returnCode) {
                file_attrs = this.convertAixNumbersToISJEAttrs(mode);
            }
        }
        if (!returnCode) {
            String[] command = new String[3];
            command[0] = new String("/usr/bin/ls");
            if (!new File(file).exists()) {
                throw new ServiceException(314, "File does not exists: " + file);
            }
            command[1] = new File(file).isDirectory() ? "-dgo" : "-go";
            command[2] = file;
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() == 0) {
                file_attrs = this.convertAixlsToISJEAttrs(cmd.getOutput());
            } else {
                throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
            }
        }
        return file_attrs;
    }

    public void setFileAttributes(String file, FileAttributes attributes) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileAttributes(" + file + "," + attributes + ") in AixFileServiceImpl");
        boolean returnCode = false;
        if (file == null || file.trim().length() <= 0) {
            throw new ServiceException(314, "Empty file value.");
        }
        if (attributes == null) {
            throw new ServiceException(314, "Empty attributes value.");
        }
        int numValue = this.convertISJEAttrsToAixNumbers(attributes);
        if (AixPlatformTools.AixJNILoaded) {
            try {
                int result = this.setNativeFileAttributes(file, numValue);
                if (result == -1) {
                    returnCode = false;
                } else {
                    if (result != 0) {
                        throw new ServiceException(315, "setFileAttributes failed: " + file + " attributes: " + numValue);
                    }
                    returnCode = true;
                }
            }
            catch (ServiceException se) {
                throw new ServiceException(se);
            }
            catch (Exception e) {
                returnCode = false;
            }
        }
        if (!returnCode) {
            AixPlatformTools.aixDebugLog(8, "set file attributes old fashion way: " + file);
            String numAttributes = Integer.toOctalString(numValue);
            String[] command = new String[]{new String("/bin/chmod"), numAttributes, file};
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() != 0) {
                throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
            }
        }
    }

    public void setFileExecutable(String file) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileExecutable(" + file + ") in AixFileServiceImpl");
        if (file == null || file.trim().length() <= 0) {
            throw new ServiceException(314, "Empty file value.");
        }
        boolean jniSuccess = false;
        if (AixPlatformTools.AixJNILoaded) {
            int mode = this.getNativeFileAttributes(file);
            if (mode == -1) {
                AixPlatformTools.aixDebugLog(8, "Returned -1 from jni in getFileAttributes");
                jniSuccess = false;
            } else {
                jniSuccess = true;
            }
            if (jniSuccess) {
                FileAttributes file_attrs = this.convertAixNumbersToISJEAttrs(mode);
                file_attrs.setAttributeState(4, true);
                file_attrs.setAttributeState(256, true);
                file_attrs.setAttributeState(32, true);
                mode = this.convertISJEAttrsToAixNumbers(file_attrs);
                jniSuccess = false;
                int returnCode = this.setNativeFileAttributes(file, mode);
                if (returnCode == -1) {
                    AixPlatformTools.aixDebugLog(8, "Returned -1 from jni in getFileAttributes");
                    jniSuccess = false;
                } else {
                    jniSuccess = true;
                }
            }
        }
        if (!jniSuccess) {
            AixPlatformTools.aixDebugLog(8, "JNI failed -- setFileExecutable the old way");
            AixFileUtils.setFileExecutable(file);
        }
    }

    public String getFileOwner(String file) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getFileOwner(" + file + ") in AixFileServiceImpl");
        String owner = null;
        boolean returnCode = false;
        if (AixPlatformTools.AixJNILoaded) {
            owner = this.getNativeFileOwner(file);
            returnCode = owner != null && owner.trim().length() != 0;
        }
        if (!returnCode) {
            AixPlatformTools.aixDebugLog(8, "get file owner old fashion way: " + file);
            if (file == null || file.trim().length() <= 0) {
                throw new ServiceException(314, "Empty file value.");
            }
            String[] command = new String[3];
            command[0] = new String("/usr/bin/ls");
            if (!new File(file).exists()) {
                throw new ServiceException(314, "File does not exists: " + file);
            }
            command[1] = new File(file).isDirectory() ? "-dl" : "-l";
            command[2] = file;
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() == 0) {
                owner = AixPlatformTools.getFieldFromString(cmd.getOutput(), 3);
            } else {
                throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
            }
        }
        return owner;
    }

    public void setFileOwner(String file, String userId) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileOwner(" + file + "," + userId + ") in AixFileServiceImpl");
        boolean returnCode = false;
        if (file == null || file.trim().length() <= 0) {
            throw new ServiceException(314, "Empty file value.");
        }
        if (userId == null || userId.trim().length() <= 0) {
            throw new ServiceException(314, "Empty userId value.");
        }
        if (AixPlatformTools.AixJNILoaded) {
            try {
                int result = this.setNativeFileOwner(file, userId);
                if (result == -1) {
                    returnCode = false;
                } else {
                    if (result != 0) {
                        throw new ServiceException(315, "setFileOwner failed: " + file + " Owner: " + userId);
                    }
                    returnCode = true;
                }
            }
            catch (ServiceException se) {
                throw new ServiceException(se);
            }
            catch (Exception e) {
                returnCode = false;
            }
        }
        if (!returnCode) {
            AixPlatformTools.aixDebugLog(8, "set file owner old fashion way: " + file);
            if (!new File(file).exists()) {
                throw new ServiceException(314, "File does not exists: " + file);
            }
            String[] command = new String[]{new String("/bin/chown"), userId, file};
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() != 0) {
                throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
            }
        }
    }

    public String getFileOwnerGroup(String file) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getFileOwnerGroup(" + file + ") in AixFileServiceImpl");
        if (file == null || file.trim().length() <= 0) {
            throw new ServiceException(314, "Empty file value.");
        }
        String owner = null;
        boolean returnCode = false;
        if (AixPlatformTools.AixJNILoaded) {
            owner = this.getNativeFileOwnerGroup(file);
            returnCode = owner != null && owner.trim().length() != 0;
        }
        if (!returnCode) {
            AixPlatformTools.aixDebugLog(8, "get file owner group old fashion way: " + file);
            String[] command = new String[3];
            command[0] = new String("/usr/bin/ls");
            if (!new File(file).exists()) {
                throw new ServiceException(314, "File does not exists: " + file);
            }
            command[1] = new File(file).isDirectory() ? "-dl" : "-l";
            command[2] = file;
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() == 0) {
                owner = AixPlatformTools.getFieldFromString(cmd.getOutput(), 4);
            } else {
                throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
            }
        }
        return owner;
    }

    public void setFileOwnerGroup(String file, String groupId) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "setFileOwnerGroup(" + file + "," + groupId + ") in AixFileServiceImpl");
        boolean returnCode = false;
        if (file == null || file.trim().length() <= 0) {
            throw new ServiceException(314, "Empty file value.");
        }
        if (groupId == null || groupId.trim().length() <= 0) {
            throw new ServiceException(314, "Empty groupId value.");
        }
        if (AixPlatformTools.AixJNILoaded) {
            try {
                int result = this.setNativeFileGroup(file, groupId);
                if (result == -1) {
                    returnCode = false;
                } else {
                    if (result != 0) {
                        throw new ServiceException(315, "setFileGroup failed: " + file + " GroupId: " + groupId);
                    }
                    returnCode = true;
                }
            }
            catch (ServiceException se) {
                throw new ServiceException(se);
            }
            catch (Exception e) {
                returnCode = false;
            }
        }
        if (!returnCode) {
            AixPlatformTools.aixDebugLog(8, "set file group owner old fashion way: " + file);
            if (!new File(file).exists()) {
                throw new ServiceException(314, "File does not exists: " + file);
            }
            String[] command = new String[]{new String("/bin/chgrp"), groupId, file};
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() != 0) {
                throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
            }
        }
    }

    public boolean supportsLongFileNames(String partitionName) {
        AixPlatformTools.aixDebugLog(136, "supportsLongFileNames(" + partitionName + ") in AixFileServiceImpl");
        return true;
    }

    public int getPartitionType(String partition) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getPartitionType(" + partition + ") in AixFileServiceImpl");
        partition = partition.trim();
        if (partition.startsWith("/dev/") && (partition.substring(5).startsWith("rmt") || partition.substring(5).startsWith("cd") || partition.substring(5).startsWith("fd"))) {
            return 2;
        }
        return 1;
    }

    public String getPartitionFormat(String partition) throws ServiceException {
        AixPlatformTools.aixDebugLog(136, "getPartitionFormat(" + partition + ") in AixFileServiceImpl");
        String[] command = new String[]{"lsfs", "-c", partition};
        AixExecCmd lsfsCommand = new AixExecCmd(command);
        String result = lsfsCommand.getOutput().trim();
        String format = AixPlatformTools.getFieldFromString(result, ":", 11);
        return format;
    }

    private FileAttributes convertAixlsToISJEAttrs(String lsOutput) throws ServiceException {
        AixPlatformTools.aixDebugLog(8, "convertAixlsToISJEAttrs() in AixFileServiceImpl");
        FileAttributes file_attrs = new FileAttributes();
        int lsOutputLength = lsOutput.length();
        if (lsOutputLength < 10) {
            throw new ServiceException(399, "Output of ls command is invalid: " + lsOutput);
        }
        block11: for (int i = 1; i < 10; ++i) {
            char curChar = lsOutput.charAt(i);
            if (curChar == '-') continue;
            switch (i) {
                case 1: {
                    if (curChar != 'r') continue block11;
                    file_attrs.setAttributeState(1, true);
                    continue block11;
                }
                case 2: {
                    if (curChar != 'w') continue block11;
                    file_attrs.setAttributeState(2, true);
                    continue block11;
                }
                case 3: {
                    if (curChar != 'x' && curChar != 's') continue block11;
                    file_attrs.setAttributeState(4, true);
                    continue block11;
                }
                case 4: {
                    if (curChar != 'r') continue block11;
                    file_attrs.setAttributeState(8, true);
                    continue block11;
                }
                case 5: {
                    if (curChar != 'w') continue block11;
                    file_attrs.setAttributeState(16, true);
                    continue block11;
                }
                case 6: {
                    if (curChar != 'x' && curChar != 't') continue block11;
                    file_attrs.setAttributeState(32, true);
                    continue block11;
                }
                case 7: {
                    if (curChar != 'r') continue block11;
                    file_attrs.setAttributeState(64, true);
                    continue block11;
                }
                case 8: {
                    if (curChar != 'w') continue block11;
                    file_attrs.setAttributeState(128, true);
                    continue block11;
                }
                case 9: {
                    if (curChar != 'x') continue block11;
                    file_attrs.setAttributeState(256, true);
                }
            }
        }
        return file_attrs;
    }

    private int convertISJEAttrsToAixNumbers(FileAttributes attrs) throws ServiceException {
        AixPlatformTools.aixDebugLog(8, "convertISJEAttrsToAixNumbers() in AixFileServiceImpl");
        int value = 0;
        for (int idx = 8; idx >= 0; --idx) {
            if (attrs.getAttributeState(this.ATTRS[idx])) {
                ++value;
            }
            if (idx == 0) continue;
            value <<= 1;
        }
        AixPlatformTools.aixDebugLog(8, "  ATTRS: " + attrs + " converts to: " + value);
        return value;
    }

    private FileAttributes convertAixNumbersToISJEAttrs(int mode) {
        FileAttributes attrs = new FileAttributes();
        AixPlatformTools.aixDebugLog(8, "convertAixNumbersToISJEAttrs() in AixFileServiceImpl");
        int idx = 0;
        for (int _mode = mode; _mode > 0; _mode >>= 1) {
            if ((_mode & 1) == 1) {
                attrs.setAttributeState(this.ATTRS[idx], true);
            }
            ++idx;
        }
        AixPlatformTools.aixDebugLog(8, "file mode: " + mode + " converts to: " + attrs);
        return attrs;
    }

    public int moveFile(String sourceFileName, String destFileName, boolean overwrite) throws ServiceException {
        File source = new File(sourceFileName);
        File destination = new File(destFileName);
        try {
            if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
                this.log(this, "wrn", "Attempting to move source file " + sourceFileName + " to destination " + destFileName + " when they are the same.");
                return 0;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (destination.exists()) {
            if (overwrite) {
                if (!destination.delete()) {
                    throw new ServiceException(315, "unable to delete file " + destFileName + ", therefore the move of file " + sourceFileName + " failed");
                }
            } else {
                throw new ServiceException(315, destFileName + " already exists. Cannot overwrite.");
            }
        }
        boolean success = false;
        try {
            if (!source.renameTo(destination)) {
                int copyResult = this.copyFile(sourceFileName, destFileName, overwrite);
                int delResult = this.deleteFile(sourceFileName);
            }
        }
        catch (Exception e) {
            throw new ServiceException(315, "Could not move file " + source.getAbsolutePath() + " to " + destination.getAbsolutePath());
        }
        return 0;
    }

    public void cleanup() throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "cleanup() in AixFileServiceImpl");
        if (AixPlatformTools.itemsToInventory.size() > 0) {
            String dirName = "";
            Enumeration components = AixPlatformTools.itemsToInventory.keys();
            while (components.hasMoreElements()) {
                String fileName = (String)AixPlatformTools.itemsToInventory.get(components.nextElement());
                AixPlatformTools.aixDebugLog(4, "Removing inventory file: " + fileName);
                File file = new File(fileName);
                if (dirName == null || dirName.trim().length() == 0) {
                    dirName = file.getParent();
                }
                if (!file.exists() || file.delete()) continue;
                this.log(this, "wrn", "Could not remove inventory file: " + fileName);
            }
            if (dirName != null && dirName.trim().length() > 0) {
                this.deleteDirectory(dirName, true, false);
            }
        }
        super.cleanup();
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = "`'\"^()\\|{}[]<>";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    public native void setSystemUMask(int var1) throws ServiceException;

    public native int getSystemUMask() throws ServiceException;
}

