/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixExecCmd;
import com.ibm.wizard.platform.aix.AixPlatformTools;
import com.installshield.wizard.service.ServiceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AixFileUtils
implements Serializable {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    public static Hashtable cachePartitionFreeSpace = new Hashtable();
    public static Hashtable adjustedFreeSpaceCache = new Hashtable();

    private static native String getNativePartitionData();

    public static void setFileExecutable(String file) {
        AixPlatformTools.aixDebugLog(128, "setFileExecutable(" + file + ") in AixFileUtils");
        String[] command = new String[]{"/bin/chmod", "ugo+x", file};
        AixExecCmd cmd = new AixExecCmd(command);
    }

    public static boolean getPartitionData() throws ServiceException {
        AixPlatformTools.aixDebugLog(4, "getPartitionData() in AixFileUtils");
        long startTime = new Date().getTime();
        String partitionData = null;
        if (cachePartitionFreeSpace.isEmpty()) {
            boolean jniSuccess = false;
            if (AixPlatformTools.AixJNILoaded) {
                try {
                    partitionData = AixFileUtils.getNativePartitionData();
                    AixPlatformTools.aixDebugLog(4, "Back from getNativePartitionData()");
                    if (partitionData == null || partitionData.trim().length() == 0) {
                        AixPlatformTools.aixDebugLog(1, "getPartitionData() received no data back from JNI.");
                        jniSuccess = false;
                    } else {
                        if (partitionData.trim().length() == -1) {
                            throw new ServiceException(2, "Failure getting partition data with JNI");
                        }
                        jniSuccess = true;
                    }
                }
                catch (ServiceException se) {
                    AixPlatformTools.aixDebugLog(1, "getPartitionData() received an exception from JNI: " + se.getMessage());
                    jniSuccess = false;
                }
                catch (Exception e) {
                    jniSuccess = false;
                }
            }
            if (!jniSuccess) {
                AixPlatformTools.aixDebugLog(4, "getPartitionData() in AixFileUtils the old way");
                partitionData = AixFileUtils.getPartitionDataWithExecs();
            }
            if (partitionData == null) {
                return false;
            }
            AixFileUtils.createPartitionDataCache(partitionData);
        }
        long endTime = new Date().getTime();
        long elapseTime = endTime - startTime;
        AixPlatformTools.aixDebugLog(4, "cachePartitionFreeSpace.size() b4 exiting getPartitionData: ");
        AixPlatformTools.aixDebugLog(4, "\t--\t" + cachePartitionFreeSpace.size());
        AixPlatformTools.aixDebugLog(32, "        -- elapse time in millsecs: " + elapseTime);
        return cachePartitionFreeSpace.size() > 0;
    }

    private static String getPartitionDataWithExecs() throws ServiceException {
        String partitionDataList = "";
        Hashtable mountInfo = AixFileUtils.getMountInformation();
        String[] vgroups = AixFileUtils.getVolumeGroups();
        Hashtable vg_filesystems = new Hashtable();
        for (int i = 0; i < vgroups.length; ++i) {
            String vgroup = "";
            String vgFree = "";
            vgroup = vgroups[i];
            vgFree = AixFileUtils.getVgFreeSpace(vgroup);
            String[] fsListData = AixFileUtils.getFileSystemList(vgroup);
            for (int k = 0; k < fsListData.length; ++k) {
                String fsData = "";
                String val = fsListData[k].trim();
                if (!val.startsWith("/") || (fsData = AixFileUtils.getFileSystemData(val, vg_filesystems)) == null) continue;
                String vfsData = (String)mountInfo.get(val);
                mountInfo.remove(val);
                partitionDataList = partitionDataList + fsData + ":" + AixPlatformTools.getFieldFromString(vfsData, ":", 1) + ":" + AixPlatformTools.getFieldFromString(vfsData, ":", 2) + ":" + vgroup + ":" + vgFree + ":";
            }
        }
        String nfsData = AixFileUtils.getNFSData(mountInfo, vg_filesystems);
        partitionDataList = partitionDataList + nfsData;
        AixPlatformTools.aixDebugLog(64, "Partition Data List\t--");
        AixPlatformTools.aixDebugLog(64, partitionDataList);
        AixPlatformTools.aixDebugLog(64, "");
        return partitionDataList;
    }

    private static Hashtable getMountInformation() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        String _info = "";
        AixExecCmd mount = new AixExecCmd("mount");
        _info = mount.getOutput().trim();
        String[] vfs = AixPlatformTools.createStringArray(_info, "\n");
        for (int i = 2; i < vfs.length; ++i) {
            String permissions;
            String vfsType;
            String vfsName;
            block16: {
                String thisVfs = vfs[i];
                if (!(thisVfs = thisVfs.trim()).startsWith("DFS") && !thisVfs.startsWith("AFS")) {
                    thisVfs = thisVfs.substring(thisVfs.indexOf(47));
                }
                Vector _thisVfs = AixPlatformTools.convertStringToVector(thisVfs, " ");
                vfsName = (String)_thisVfs.elementAt(1);
                vfsType = (String)_thisVfs.elementAt(2);
                permissions = "ro";
                if (vfsType.startsWith("dfs") || vfsType.startsWith("afs")) {
                    permissions = "rw";
                } else {
                    if (!vfsType.startsWith("nfs")) {
                        try {
                            if (_thisVfs.size() > 6) {
                                permissions = (String)_thisVfs.elementAt(6);
                            } else if (((String)_thisVfs.elementAt(1)).startsWith("auto")) {
                                vfsType = (String)_thisVfs.elementAt(1);
                                vfsName = (String)_thisVfs.elementAt(0);
                                if (((String)_thisVfs.elementAt(5)).startsWith("r")) {
                                    permissions = (String)_thisVfs.elementAt(5);
                                }
                            }
                            if (permissions.indexOf(44) != -1) {
                                permissions = permissions.substring(0, permissions.indexOf(44));
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            AixPlatformTools.aixDebugLog(8, "Caught an exception in getMountInformation");
                            int debugLogLevelVal = 0;
                            try {
                                String[] cmd = new String[]{"env", "ISJELOG"};
                                Process process = Runtime.getRuntime().exec(cmd);
                                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                String logLevel = reader.readLine();
                                debugLogLevelVal = new Integer(logLevel);
                            }
                            catch (Exception ee) {
                                // empty catch block
                            }
                            if ((debugLogLevelVal & 8) != 0) {
                                e.printStackTrace();
                            }
                            break block16;
                        }
                    }
                    File vfsSubDir = new File(vfsName + "/_____test__ismp__");
                    if (vfsSubDir.mkdir()) {
                        permissions = "rw";
                        vfsSubDir.delete();
                    }
                }
            }
            info.put(vfsName, vfsType + ":" + permissions);
        }
        return info;
    }

    private static String getNFSData(Hashtable mountInfo, Hashtable tb) {
        String nfsData = "";
        if (mountInfo != null && mountInfo.size() > 0) {
            Enumeration e = mountInfo.keys();
            while (e.hasMoreElements()) {
                String vfsName = (String)e.nextElement();
                String vfsData = (String)mountInfo.get(vfsName);
                String vfsType = AixPlatformTools.getFieldFromString(vfsData, ":", 1);
                String freespace = "0";
                String permissions = AixPlatformTools.getFieldFromString(vfsData, ":", 2);
                if (permissions.equals("rw") && tb.containsKey(vfsName)) {
                    String data = (String)tb.get(vfsName);
                    freespace = data.indexOf(":") != -1 ? data.substring(0, data.indexOf(":")) : data;
                }
                nfsData = nfsData + vfsName + ":" + freespace + ":0:" + vfsType + ":" + permissions + ":NONE:0:";
            }
        }
        return nfsData;
    }

    private static String[] getVolumeGroups() {
        String vgrps = "";
        String[] lsvgcmd = new String[]{"lsvg", "-o"};
        AixExecCmd lsvg_o = new AixExecCmd(lsvgcmd);
        vgrps = lsvg_o.getOutput().trim();
        String[] vgroups = AixPlatformTools.createStringArray(vgrps, null);
        return vgroups;
    }

    private static String getVgFreeSpace(String vgroup) {
        String vgFree = "";
        String[] vgfreecmd = new String[]{"lsvg", vgroup};
        AixExecCmd lsvg = new AixExecCmd(vgfreecmd);
        String vgtmp = lsvg.getOutput().trim();
        String vgfreeData = AixPlatformTools.getFieldFromString(vgtmp, ":", 9);
        vgfreeData = AixPlatformTools.getFieldFromString(vgfreeData, "(", 2);
        vgfreeData = AixPlatformTools.getFieldFromString(vgfreeData, " ", 1).trim();
        long space = Long.parseLong(vgfreeData);
        space = space * 1024L * 1024L;
        vgFree = String.valueOf(space);
        return vgFree;
    }

    private static String[] getFileSystemList(String vgroup) {
        String[] lsvg_lcmd = new String[]{"lsvg", "-l", vgroup};
        AixExecCmd lsvg_l = new AixExecCmd(lsvg_lcmd);
        String fstmp = lsvg_l.getOutput().trim();
        String[] list = AixPlatformTools.createStringArray(fstmp, "\n");
        Vector<String> _list = new Vector<String>();
        for (int i = 2; i < list.length; ++i) {
            String[] fsdata = AixPlatformTools.createStringArray(list[i], null);
            String fsname = fsdata[fsdata.length - 1].trim();
            if (!fsname.startsWith("/")) continue;
            _list.addElement(fsname);
        }
        String[] fsListData = new String[_list.size()];
        for (int j = 0; j < _list.size(); ++j) {
            fsListData[j] = (String)_list.elementAt(j);
        }
        return fsListData;
    }

    private static String getFileSystemData(String fsName, Hashtable tb) {
        String fsData;
        String fsFree = "";
        String blockSize = "";
        if (tb.isEmpty()) {
            String[] cmdStr = new String[]{"df", "-Mk"};
            AixExecCmd cmd = new AixExecCmd(cmdStr);
            String dftmp = cmd.getOutput().trim();
            String[] dfvals = AixPlatformTools.createStringArray(dftmp, "\n");
            for (int i = 1; i < dfvals.length; ++i) {
                fsFree = AixPlatformTools.getFieldFromString(dfvals[i], null, 4);
                String name = AixPlatformTools.getFieldFromString(dfvals[i], null, 2);
                if (Character.isDigit(fsFree.charAt(0))) {
                    long space = Long.parseLong(fsFree);
                    fsFree = String.valueOf(space *= 1024L);
                } else {
                    fsFree = "0";
                }
                AixPlatformTools.aixDebugLog(64, "Adding key: " + name + " data: " + fsFree);
                tb.put(name, fsFree);
            }
            cmdStr = new String[]{"lsfs", "-q"};
            cmd = new AixExecCmd(cmdStr);
            String lstmp = cmd.getOutput().trim();
            String[] lsvals = AixPlatformTools.createStringArray(lstmp, "\n");
            for (int i = 1; i < lsvals.length; ++i) {
                String name = AixPlatformTools.getFieldFromString(lsvals[i], null, 3).trim();
                String fstype = AixPlatformTools.getFieldFromString(lsvals[i], null, 4).trim();
                String tmpStr = (String)tb.get(name);
                if (tmpStr == null || tmpStr.length() <= 0 || !fstype.startsWith("jfs")) continue;
                if (i + 1 < lsvals.length && lsvals[i + 1].indexOf(44) != -1) {
                    if (++i >= lsvals.length) continue;
                    String blocktmp = AixPlatformTools.getFieldFromString(lsvals[i], ",", 3);
                    blockSize = AixPlatformTools.getFieldFromString(blocktmp, ":", 2).trim();
                    tmpStr = tmpStr + ":" + blockSize;
                    AixPlatformTools.aixDebugLog(64, "Changing key: " + name + " data: " + tmpStr);
                    tb.put(name, tmpStr);
                    continue;
                }
                tmpStr = tmpStr + ":4096";
                AixPlatformTools.aixDebugLog(64, "Changing key: " + name + " data: " + tmpStr);
                tb.put(name, tmpStr);
            }
        }
        if ((fsData = (String)tb.get(fsName)) != null && fsData.length() > 0) {
            return fsName + ":" + fsData;
        }
        return null;
    }

    private static void createPartitionDataCache(String data) {
        AixPlatformTools.aixDebugLog(128, "Entering createPartitionDataCache with data: " + data);
        data = data.trim();
        if (data.endsWith(":")) {
            data = data.substring(0, data.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(data, ":");
        int tokens = st.countTokens() / 7;
        for (int i = 0; i < tokens; ++i) {
            while (st.hasMoreTokens()) {
                String fskey = st.nextToken();
                String fsspace = st.nextToken();
                String fsblock = st.nextToken();
                String fstype = st.nextToken();
                String perms = st.nextToken();
                perms = perms.equals("1") || perms.equals("rw") ? "rw" : "ro";
                String fsvg = st.nextToken();
                String vgspace = st.nextToken();
                cachePartitionFreeSpace.put(fskey, fsspace + ":" + fsblock + ":" + fstype + ":" + perms + ":" + fsvg);
                if (fsvg.equals("NONE") || cachePartitionFreeSpace.containsKey(fsvg)) continue;
                cachePartitionFreeSpace.put(fsvg, vgspace);
            }
        }
        AixPlatformTools.aixDebugLog(128, "Leaving createPartitionDataCache with values: ");
        Enumeration e = cachePartitionFreeSpace.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            AixPlatformTools.aixDebugLog(128, "Key: " + key + " : " + (String)cachePartitionFreeSpace.get(key));
        }
    }
}

