/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixPlatformTools;
import com.installshield.wizard.service.MutableOperationState;

class AixPackageProgressTimer
implements Runnable {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    private MutableOperationState state;
    private boolean stop;
    private boolean thread_done;
    private int totalTime;
    private int approcTime;
    private int numIncrements;
    private int currentChunkEnd;
    private int currentChunkNumber;
    private int chunkSize;
    private static long SLEEPTIME = 250L;
    private static long TIMEINCREMENT = 10L * SLEEPTIME / 1000L;

    public AixPackageProgressTimer(MutableOperationState state, int totalTime, int currentComplete) {
        this(state, totalTime, currentComplete, 1);
    }

    public AixPackageProgressTimer(MutableOperationState state, int totalTime, int currentComplete, int numIncrements) {
        AixPlatformTools.aixDebugLog(4, "AixPackageProgressTimer Constructor()");
        this.state = state;
        this.stop = false;
        this.thread_done = false;
        this.approcTime = currentComplete;
        this.totalTime = totalTime;
        this.numIncrements = numIncrements;
        this.currentChunkEnd = this.chunkSize = this.totalTime / this.numIncrements;
        this.currentChunkNumber = 1;
        if (this.totalTime <= 0) {
            this.totalTime = 10;
        }
        int pctComp = Math.round(this.approcTime * 100 / this.totalTime);
        state.setPercentComplete(pctComp);
    }

    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(SLEEPTIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if ((long)this.approcTime + TIMEINCREMENT >= (long)this.currentChunkEnd) continue;
            this.approcTime = (int)((long)this.approcTime + TIMEINCREMENT);
            int pctComp = Math.round(this.approcTime * 100 / this.totalTime);
            this.state.setPercentComplete(pctComp);
        }
        this.thread_done = true;
    }

    public void done() {
        this.stop = true;
        int iterations = 0;
        while (!this.thread_done && iterations++ < 5) {
            try {
                Thread.sleep(SLEEPTIME);
            }
            catch (InterruptedException e) {}
        }
        AixPlatformTools.aixDebugLog(4, "  - done: " + this.approcTime + " of: " + this.totalTime);
        AixPlatformTools.aixDebugLog(4, "  - do: " + (this.totalTime - this.approcTime));
        int pctComp = 100;
        this.state.setPercentComplete(pctComp);
        AixPlatformTools.aixDebugLog(4, "  (done)- PercentComplete: " + this.state.getProgress().getPercentComplete());
        AixPlatformTools.aixDebugLog(4, "  (done)- currentProgress: " + this.approcTime);
        AixPlatformTools.aixDebugLog(4, "  (done)- TotalTime: " + this.totalTime);
    }

    public void moveToNextIncrement() {
        ++this.currentChunkNumber;
        if (this.currentChunkNumber > this.numIncrements) {
            this.done();
        } else {
            this.approcTime = this.currentChunkEnd;
            this.currentChunkEnd += this.chunkSize;
        }
    }
}

