/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixFileServiceImpl;
import com.installshield.util.LibraryLoader;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AixPlatformTools
implements Serializable {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    private static final String POWERPC = "POWER_PC";
    private static final String AIX = "AIX";
    private static boolean isCompatibleArchitecture = false;
    public static Hashtable itemsToInventory = new Hashtable();
    public static boolean AixJNILoaded = false;
    public static final String INSTALLP_LOG_DIR = "/var/adm/sw";
    private static boolean gotDebugLogLevel = false;
    private static int debugLogLevelVal = 0;
    public static Hashtable toDoAtCleanup = new Hashtable();
    private static Vector postInstallComments = new Vector();
    private static Vector postUninstallComments = new Vector();
    public static final String LS_CMD = "/usr/bin/ls";
    public static final String CHMOD_CMD = "/bin/chmod";
    public static final String CHGRP_CMD = "/bin/chgrp";
    public static final String CHOWN_CMD = "/bin/chown";
    public static final String INUTOC_CMD = "/usr/sbin/inutoc";
    public static final String INSTALLP_CMD = "/usr/sbin/installp ";
    public static final String SYSCK_CMD = "/usr/bin/sysck";
    public static final String MKITAB_CMD = "/usr/sbin/mkitab";
    public static final String LSITAB_CMD = "/usr/sbin/lsitab";
    public static final String CHITAB_CMD = "/usr/sbin/chitab";
    public static final String RMITAB_CMD = "/usr/sbin/rmitab";
    public static final String OSLEVEL_CMD = "/usr/bin/oslevel";
    public static final String MKUSER_CMD = "/usr/bin/mkuser";
    public static final String MKGROUP_CMD = "/usr/bin/mkgroup";
    public static final String RMUSER_CMD = "/usr/sbin/rmuser";
    public static final String RMGROUP_CMD = "/usr/sbin/rmgroup";
    public static final String VPDADD_CMD = "/usr/sbin/vpdadd";
    public static final String VPDDEL_CMD = "/usr/sbin/vpddel";
    public static final String DT_ACTION = "/usr/dt/bin/dtaction";
    public static final String DT_APP_INT = "/etc/dtappintegrate";
    public static final String CHFS_CMD = "/usr/sbin/chfs";
    public static final String CKPREREQ_CMD = "/usr/sbin/ckprereq";
    public static final int LOG_ERR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 4;
    public static final int LOG_FILE = 8;
    public static final int LOG_REG = 16;
    public static final int LOG_CMD = 32;
    public static final int LOG_MISC = 64;
    public static final int LOG_METH = 128;
    public static final int LOG_FILE_METH = 136;
    public static final int LOG_REG_METH = 144;
    public static final int LOG_ALL = 255;
    private static final String AIX_JNI_NAME = "reslib/aixppk/libaixppk.so";
    private static final String AIX_IA64_JNI_NAME = "reslib/aixppk/libaixia64ppk.so";
    public static final String AIX_LAUNCHERMAIN_NAME = "reslib/aixppk/scriptlauncherstub.sh";
    public static final String AIX_IA64_LAUNCHERMAIN_NAME = "reslib/aixppk/scriptlauncherstub.sh";
    public static final String AIX_LAUNCHERMAIN_NAME_BASE = "aixppk/scriptlauncherstub.sh";
    public static final String AIX_IA64_LAUNCHERMAIN_NAME_BASE = "aixppk/scriptlauncherstub.sh";
    public static final String JVM_VERIFY_CLASS_NAME_BASE = "aixppk/Verify.jar";
    public static int desktopInstalled = 0;

    public AixPlatformTools() {
        AixPlatformTools.aixDebugLog(64, "Constructor for AixPlatformTools");
    }

    public static boolean isCompatible() {
        AixPlatformTools.aixDebugLog(4, "isCompatible() in AixPlatformTools");
        String osName = System.getProperty("os.name");
        if (osName == null || osName.length() != AIX.length() || !osName.equalsIgnoreCase(AIX)) {
            return false;
        }
        isCompatibleArchitecture = true;
        return true;
    }

    public static void loadJNILibrary(WizardServices services) {
        AixPlatformTools.aixDebugLog(4, "Attempting to loaded JNI.");
        if (AixJNILoaded) {
            return;
        }
        String loadedJNI = "";
        try {
            File libFile;
            SystemUtilService suservice = (SystemUtilService)services.getService(SystemUtilService.NAME);
            String altJNILoc = suservice.getEnvironmentVariable("AIX_LIB_LOC");
            if (altJNILoc != null && (altJNILoc = altJNILoc.trim()).length() > 0 && altJNILoc.endsWith("libaixppk.so") && (libFile = new File(altJNILoc)).exists() && libFile.canRead()) {
                AixPlatformTools.aixDebugLog(4, "Using JNI library in tmp location: " + altJNILoc);
                LibraryLoader.loadLibrary(altJNILoc);
                loadedJNI = altJNILoc;
            }
            if (loadedJNI == null || loadedJNI.length() == 0) {
                String osArch = System.getProperty("os.arch");
                loadedJNI = osArch != null && osArch.equalsIgnoreCase("IA64") ? LibraryLoader.loadLibrary(((WizardServicesImpl)services).getServiceResource(AIX_IA64_JNI_NAME), "libaixia64ppk.so") : LibraryLoader.loadLibrary(((WizardServicesImpl)services).getServiceResource(AIX_JNI_NAME), "libaixppk.so");
            }
            AixPlatformTools.aixDebugLog(4, "Loaded JNI: " + loadedJNI);
            if (AixFileServiceImpl.initializeJNI() == 1) {
                AixJNILoaded = true;
            }
        }
        catch (Exception e) {
            AixPlatformTools.aixDebugLog(1, "caught exception in initialized!: " + e.getMessage());
            AixJNILoaded = false;
        }
        catch (Error er) {
            AixPlatformTools.aixDebugLog(1, "caught error in initialized!: " + er.getMessage());
            AixJNILoaded = false;
        }
    }

    public static String convertVectorToString(Vector in, String tok) {
        String result = "";
        if (in != null && in.size() > 0) {
            for (int i = 0; i < in.size(); ++i) {
                result = result + (String)in.elementAt(i);
                if (i >= in.size() - 1) continue;
                result = result + tok;
            }
        }
        return result;
    }

    public static Vector convertStringToVector(String in) {
        return AixPlatformTools.convertStringToVector(in, ":");
    }

    public static Vector convertStringToVector(String in, String tok) {
        return AixPlatformTools.convertStringToVector(in, tok, false);
    }

    public static Vector convertStringToVector(String in, String tok, boolean returnNullsAsBlanks) {
        Vector<String> outv = new Vector<String>();
        AixPlatformTools.aixDebugLog(64, "convertStringToVector(" + in + ", " + tok + " )");
        StringTokenizer st = new StringTokenizer(in, tok, returnNullsAsBlanks);
        boolean prevWasTokenizer = true;
        boolean skip = false;
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            if (returnNullsAsBlanks) {
                boolean isTokenizer = val.equals(tok);
                if (isTokenizer && prevWasTokenizer) {
                    outv.addElement(" ");
                }
                prevWasTokenizer = isTokenizer;
                skip = isTokenizer;
            }
            if (skip || val.length() <= 0 || val.equals("\n")) continue;
            outv.addElement(val);
        }
        if (returnNullsAsBlanks && prevWasTokenizer) {
            outv.addElement(" ");
        }
        return outv;
    }

    public static String getFieldFromString(String in, int whichField) {
        return AixPlatformTools.getFieldFromString(in, null, whichField);
    }

    public static String getFieldFromString(String in, String token, int whichField) {
        String outv = null;
        StringTokenizer st = token == null ? new StringTokenizer(in) : new StringTokenizer(in, token);
        for (int ix = 1; st.hasMoreTokens() && ix <= whichField; ++ix) {
            String val = st.nextToken();
            if (ix != whichField || val.length() <= 0 || val.equals("\n")) continue;
            outv = new String(val);
        }
        return outv;
    }

    public static String[] createStringArray(String source, String separators) {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer st = separators != null ? new StringTokenizer(source, separators) : new StringTokenizer(source);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            tokens.addElement(token);
        }
        String[] array = null;
        if (tokens.size() > 0) {
            array = new String[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                array[i] = (String)tokens.elementAt(i);
            }
        }
        return array;
    }

    public static String toAixDate(long date, boolean yearfirst) throws ServiceException {
        if (date <= 0L) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setTime(new Date(date));
        String _date = "";
        if (yearfirst) {
            _date = _date + cal.get(1);
        }
        _date = _date + AixPlatformTools.makeTwoDigit(cal.get(2) + 1) + AixPlatformTools.makeTwoDigit(cal.get(5)) + AixPlatformTools.makeTwoDigit(cal.get(11)) + AixPlatformTools.makeTwoDigit(cal.get(12));
        _date = yearfirst ? _date + "." + AixPlatformTools.makeTwoDigit(cal.get(13)) : _date + AixPlatformTools.makeTwoDigit(cal.get(1));
        return _date;
    }

    private static String makeTwoDigit(int value) {
        String tmp_value = Integer.toString(value);
        int tmpLength = tmp_value.length();
        if (tmpLength == 0) {
            tmp_value = "00";
        } else if (tmpLength == 1) {
            tmp_value = "0" + tmp_value;
        } else if (tmpLength > 2) {
            tmp_value = tmp_value.substring(tmpLength - 2);
        }
        return tmp_value;
    }

    public static void aixDebugLog(String out) {
        AixPlatformTools.aixDebugLog(255, out);
    }

    public static void aixDebugLog(int level, String out) {
        if (!gotDebugLogLevel && isCompatibleArchitecture) {
            try {
                String[] cmd = new String[]{"env", "ISJELOG"};
                Process process = Runtime.getRuntime().exec(cmd);
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String logLevel = reader.readLine();
                debugLogLevelVal = new Integer(logLevel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            gotDebugLogLevel = true;
        }
        if ((debugLogLevelVal & level) != 0) {
            System.out.println("AIX: " + out);
        }
    }

    public static Vector findLinesWithPattern(String[] output, String pattern) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < output.length; ++i) {
            if (output[i].indexOf(pattern) == -1) continue;
            result.addElement(output[i]);
        }
        return result;
    }

    public static void addPostInstallComment(String comment) {
        if (!postInstallComments.contains(comment)) {
            postInstallComments.addElement(comment);
        }
    }

    public static void addPostUninstallComment(String comment) {
        if (!postUninstallComments.contains(comment)) {
            postUninstallComments.addElement(comment);
        }
    }

    public static Vector getPostInstallComments() {
        return postInstallComments;
    }

    public static Vector getPostUninstallComments() {
        return postUninstallComments;
    }
}

