/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixExecCmd;
import com.ibm.wizard.platform.aix.AixPlatformTools;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.File;

public class AixSecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    private final String ROOT_USER = "root";

    private native int setNativeUserPasswd(String var1, String var2);

    private native int getNativeUid(String var1);

    private native int getNativeGid(String var1);

    public int getSystemCompatibility() {
        int result = 0;
        result = AixPlatformTools.isCompatible() ? 5 : 0;
        AixPlatformTools.aixDebugLog(128, "getSystemCompatibility in SecurityService returning: " + result);
        return result;
    }

    protected void initialized() {
        super.initialized();
        try {
            AixPlatformTools.loadJNILibrary(this.getServices());
        }
        catch (Exception e) {
            AixPlatformTools.aixDebugLog(1, "initialized: failed to call loadJNILibrary()" + e);
        }
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        String userName = System.getProperty("user.name");
        return userName.equals("root");
    }

    public boolean canCurrentUserWrite(String directory) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, " canCurrentUserWrite(" + directory + ") in AixSecurityServiceImpl.");
        File dir = new File(directory);
        return dir.exists() && dir.isDirectory() && dir.canWrite();
    }

    public void createUser(UserSpecification userSpec) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, " createUser() in AixSecurityServiceImpl.");
        if (userSpec == null) {
            throw new ServiceException(314, "Empty UserSpec value.");
        }
        int uid = -1;
        String name = userSpec.getUserName();
        if (AixPlatformTools.AixJNILoaded) {
            uid = this.getNativeUid(name);
            if (uid > 0) {
                throw new ServiceException(1, "User (" + name + ") already exists.");
            }
        } else {
            this.log(this, "wrn", "Can't verify if user: " + name + " already exists.  Preceeding blindly.");
        }
        long expireDate = userSpec.getAccountExpirationDate();
        AixPlatformTools.aixDebugLog(4, "expiration Date in securityservice:\t" + expireDate);
        String desc = userSpec.getDescription();
        GroupSpecification[] groups = userSpec.getGroups();
        String home = userSpec.getHomeDirectory();
        String shell = userSpec.getLogonScript();
        String pwd = userSpec.getPassword();
        String gecos = userSpec.getUserFullName();
        boolean isdisabled = userSpec.isAccountDisabled();
        boolean ispwdChangeRequired = userSpec.isPasswordChangeRequired();
        int cmd_idx = 0;
        String[] t_command = new String[9];
        t_command[cmd_idx++] = new String("/usr/bin/mkuser");
        String _expireDate = AixPlatformTools.toAixDate(expireDate, false);
        if (home != null && home.trim().length() > 0) {
            t_command[cmd_idx++] = "home=" + home;
        }
        if (shell != null && shell.trim().length() > 0) {
            t_command[cmd_idx++] = "shell=" + shell;
        }
        if (_expireDate != null && _expireDate.trim().length() > 0) {
            t_command[cmd_idx++] = "expires=" + _expireDate;
        }
        if (gecos != null && gecos.trim().length() > 0) {
            t_command[cmd_idx] = "gecos=" + gecos;
            if (desc != null && desc.trim().length() > 0) {
                int n = cmd_idx;
                t_command[n] = t_command[n] + ", " + desc;
            }
            ++cmd_idx;
        } else if (desc != null && desc.trim().length() > 0) {
            t_command[cmd_idx++] = "gecos=" + desc;
        }
        if (groups != null && groups.length > 0) {
            AixPlatformTools.aixDebugLog(4, "Attempting to add " + groups.length + " groups to user: " + name);
            boolean addedOne = false;
            t_command[cmd_idx] = "groups=";
            for (int i = 0; i < groups.length; ++i) {
                AixPlatformTools.aixDebugLog(4, " -- Attempting group: " + groups[i].getGroupName().trim());
                if (groups[i] == null || groups[i].getGroupName().trim().length() <= 0) continue;
                String curGroup = new String(groups[i].getGroupName().trim());
                int gid = 0;
                if (AixPlatformTools.AixJNILoaded) {
                    gid = this.getNativeGid(curGroup);
                } else {
                    this.log(this, "wrn", "Can't verify if group: " + curGroup + " already exists.  Preceeding blindly.");
                }
                if (gid < 0) {
                    try {
                        GroupSpecification newGrp = new GroupSpecification();
                        newGrp.setGroupName(curGroup);
                        this.createGroup(newGrp);
                        gid = this.getNativeGid(curGroup);
                    }
                    catch (ServiceException se) {
                        // empty catch block
                    }
                }
                if (gid < 0) {
                    AixPlatformTools.aixDebugLog(4, " -- Unrecognized group: " + curGroup + " and unable to create it.");
                    continue;
                }
                if (addedOne) {
                    int n = cmd_idx;
                    t_command[n] = t_command[n] + ",";
                }
                int n = cmd_idx;
                t_command[n] = t_command[n] + curGroup;
                addedOne = true;
            }
        }
        int n = ++cmd_idx;
        t_command[n] = name;
        String[] command = new String[++cmd_idx];
        for (int ix = 0; ix < cmd_idx; ++ix) {
            command[ix] = t_command[ix];
        }
        AixExecCmd cmd = new AixExecCmd(command);
        if (cmd.getResult() != 0) {
            throw new ServiceException(399, "Failure creating user: " + name + " rc: " + cmd.getResult() + " StdErr: " + cmd.getErrors());
        }
        if (!AixPlatformTools.AixJNILoaded || this.setNativeUserPasswd(name, pwd) != 0) {
            this.log(this, "wrn", "Unable to set password for user: " + name);
        }
    }

    public void deleteUser(String userid) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, " deleteUser(" + userid + ") in AixSecurityServiceImpl.");
        if (userid == null || userid.trim().length() <= 0) {
            throw new ServiceException(314, "Empty userId value.");
        }
        String[] command = new String[]{new String("/usr/sbin/rmuser"), "-p", userid};
        AixExecCmd cmd = new AixExecCmd(command);
        if (cmd.getResult() != 0) {
            throw new ServiceException(399, "Failure removing user: " + userid + " rc: " + cmd.getResult() + " StdErr: " + cmd.getErrors());
        }
    }

    public void createGroup(GroupSpecification groupSpec) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, " createGroup() in AixSecurityServiceImpl.");
        if (groupSpec == null) {
            throw new ServiceException(314, "Empty groupSpec value.");
        }
        UserSpecification[] users = groupSpec.getUsers();
        String[] t_command = new String[9];
        int cmd_idx = 0;
        t_command[cmd_idx++] = new String("/usr/bin/mkgroup");
        if (users != null && users.length > 0) {
            boolean added_one = false;
            for (int i = 0; i < users.length; ++i) {
                String name = users[i].getUserName();
                int uid = -1;
                if (AixPlatformTools.AixJNILoaded) {
                    uid = this.getNativeUid(name);
                    if (uid < 0) {
                        this.log(this, "wrn", "User: " + name + " does not exists.  " + "Not adding it to group definition.");
                        continue;
                    }
                    if (!added_one) {
                        t_command[cmd_idx++] = new String("-a");
                        t_command[cmd_idx] = new String("users=");
                        added_one = true;
                    } else {
                        int n = cmd_idx;
                        t_command[n] = t_command[n] + ",";
                    }
                    int n = cmd_idx;
                    t_command[n] = t_command[n] + name;
                    continue;
                }
                this.log(this, "wrn", "Can't verify if user: " + name + " exists.  Not adding it to group definition.");
            }
            if (added_one) {
                // empty if block
            }
        }
        int n = ++cmd_idx;
        t_command[n] = groupSpec.getGroupName();
        String[] command = new String[++cmd_idx];
        for (int ix = 0; ix < cmd_idx; ++ix) {
            command[ix] = t_command[ix];
        }
        AixExecCmd cmd = new AixExecCmd(command);
        int result = cmd.getResult();
        if (result != 0) {
            if (result == 17) {
                this.log(this, "wrn", "Group: " + groupSpec.getGroupName() + " already exists.");
            } else {
                throw new ServiceException(399, "Failure creating group: " + groupSpec.getGroupName() + " rc: " + cmd.getResult() + " StdErr: " + cmd.getErrors());
            }
        }
    }

    public void deleteGroup(String groupid) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, " deleteGroup() in AixSecurityServiceImpl.");
        if (groupid == null || groupid.trim().length() <= 0) {
            throw new ServiceException(314, "Empty groupId value.");
        }
        String[] command = new String[]{new String("/usr/sbin/rmgroup"), groupid};
        AixExecCmd cmd = new AixExecCmd(command);
        if (cmd.getResult() != 0) {
            throw new ServiceException(399, "Failure removing group: " + groupid + " rc: " + cmd.getResult() + " StdErr: " + cmd.getErrors());
        }
    }

    public void cleanup() throws ServiceException {
        super.cleanup();
    }
}

