/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.aix;

import com.ibm.wizard.platform.aix.AixExecCmd;
import com.ibm.wizard.platform.aix.AixPlatformTools;
import com.ibm.wizard.platform.aix.AixProcessEnvironmentVariableManager;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilServiceImplementor;
import com.installshield.wizardx.ascii.ModifyFile;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AixSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl
implements SystemUtilServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2003.";
    private boolean _rebootRequired = false;
    private boolean _rebootOnExit = false;
    private Hashtable cacheStartupCommands = null;
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private AixProcessEnvironmentVariableManager currentProcessEnvVarManager;
    private static final String systemScript = "/etc/profile";
    private static final String userCshScript = ".login";
    private static final String userBourne_KshScript = ".profile";
    public static String PLATFORM_ID;

    public static native void nativePutenv(String var0);

    public static native String nativeGetenv(String var0);

    public native void nativeDeleteFilesAfterExit(String var1);

    public int getSystemCompatibility() {
        int result = 0;
        result = AixPlatformTools.isCompatible() ? 5 : 0;
        AixPlatformTools.aixDebugLog(128, "getSystemCompatibility in SystemUtilService returning: " + result);
        return result;
    }

    public boolean conditionsMet() {
        AixPlatformTools.aixDebugLog(128, "conditionsMet() in AixSystemUtilServiceImpl");
        return true;
    }

    public void deleteEnvironmentVariable(String variableName, int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "deleteEnvironmentVariable(" + variableName + ",level) in AixSystemUtilServiceImpl");
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            AixPlatformTools.aixDebugLog(4, "Calling delete variable for group");
            group.deleteVariable(variableName);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.deleteVariable(variableName);
    }

    public void deleteEnvironmentVariable(String variableName) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "deleteEnvironmentVariable(" + variableName + ") in AixSystemUtilServiceImpl");
        if (variableName == null || variableName.trim().length() <= 0) {
            throw new ServiceException(314, "Empty variableName value.");
        }
        try {
            FileService fs = (FileService)this.getServices().getService(FileService.NAME);
            ModifyFile mfile = null;
            mfile = new ModifyFile(null);
            mfile.setFile("/etc/environment");
            mfile.setFileService(fs);
            mfile.loadFile();
            mfile.setCaseSensitive(true);
            mfile.setCommentChar("#");
            mfile.setOccurrenceFrequency(1);
            mfile.setReturnPosition(0);
            mfile.setTokensNotFound(2);
            Vector<String> search = new Vector<String>();
            search.addElement(variableName);
            search.addElement("=");
            mfile.setMatch(search);
            mfile.searchStringsOnlyWhtSpc();
            if (mfile.areMatches()) {
                mfile.deleteLine();
            }
            mfile.writeFile();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public String getJavaCommand(String applicationName, String[] applicationArgs, String classpath) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "getJavaCommand() in AixSystemUtilServiceImpl");
        if (applicationName == null || applicationName.trim().length() <= 0) {
            throw new ServiceException(314, "Empty applicationName value.");
        }
        String javaCommand = null;
        try {
            String javaHome;
            File java = new File("/bin/java");
            if (java.exists()) {
                javaCommand = java.getAbsolutePath();
            }
            if (javaCommand == null && (java = new File((javaHome = this.getEnvironmentVariable("JAVA_HOME")) + File.separator + "bin" + File.separator + "java")).exists()) {
                javaCommand = java.getAbsolutePath();
            }
            if (javaCommand != null) {
                String javaClass = this.getEnvironmentVariable("CLASSPATH");
                if (javaClass == null || javaClass.trim().length() <= 0) {
                    javaClass = System.getProperty("java.class.path");
                }
                javaCommand = javaCommand + " -classpath " + classpath;
                if (javaClass != null && javaClass.trim().length() > 0) {
                    javaCommand = javaCommand + System.getProperty("path.separator") + javaClass;
                }
            }
            if (javaCommand != null) {
                javaCommand = javaCommand + " " + applicationName;
            }
            if (javaCommand != null && applicationArgs != null) {
                for (int index = 0; index < applicationArgs.length; ++index) {
                    javaCommand = javaCommand + " " + applicationArgs[index];
                }
            }
            return javaCommand;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void setEnvironmentVariable(String variableName, String variableValue, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.setVariable(variableName, variableValue);
        }
        this.currentProcessEnvVarManager.setVariable(variableName, variableValue);
        this.setLogoutRequired(true);
    }

    public void setEnvironmentVariable(String variableName, String variableValue) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "setEnvironmentVariable(" + variableName + "," + variableValue + ") in AixSystemUtilServiceImpl");
        if (variableName == null || variableName.trim().length() <= 0) {
            throw new ServiceException(314, "Empty variableName value.");
        }
        try {
            FileService fs = (FileService)this.getServices().getService(FileService.NAME);
            ModifyFile mfile = null;
            mfile = new ModifyFile(null);
            mfile.setFile("/etc/environment");
            mfile.setFileService(fs);
            mfile.loadFile();
            mfile.setCaseSensitive(true);
            mfile.setCommentChar("#");
            mfile.setOccurrenceFrequency(1);
            mfile.setReturnPosition(0);
            mfile.setTokensNotFound(2);
            Vector<String> search = new Vector<String>();
            search.addElement(variableName);
            search.addElement("=");
            mfile.setMatch(search);
            mfile.searchStringsOnlyWhtSpc();
            if (mfile.areMatches()) {
                mfile.replaceLine(new String[]{variableName + "=" + variableValue});
            } else {
                mfile.getAllLines().addElement(variableName + "=" + variableValue);
            }
            mfile.writeFile();
        }
        catch (Exception ee) {
            throw new ServiceException(ee);
        }
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        String val = "";
        AixPlatformTools.aixDebugLog(128, "getEnvironmentVariable(" + variableName + ") in AixSystemUtilServiceImpl");
        if (variableName == null || variableName.trim().length() <= 0) {
            throw new ServiceException(314, "Empty variableName value.");
        }
        try {
            String[] cmd = new String[]{"env"};
            Process process = Runtime.getRuntime().exec(cmd);
            Properties envProperties = new Properties();
            envProperties.load(process.getInputStream());
            val = envProperties.getProperty(variableName);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return val;
    }

    public String getOSServiceLevel() throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "getOSServiceLevel() in AixSystemUtilServiceImpl");
        String command = new String("/usr/bin/oslevel");
        String serviceLevel = null;
        try {
            AixExecCmd cmd = new AixExecCmd(command);
            serviceLevel = cmd.getOutput();
            if (cmd.getResult() == 0 && serviceLevel.trim().length() > 7) {
                serviceLevel = serviceLevel.substring(0, serviceLevel.trim().length() - 1);
            } else {
                this.log(this, "err", cmd.getErrors());
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        return serviceLevel;
    }

    public void rebootsystem() throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "rebootsystem() in AixSystemUtilServiceImpl");
    }

    public void addSystemStartupCommand(String inCommand) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "addSystemStartupCommand(" + inCommand + ") in AixSystemUtilServiceImpl");
        this.cacheStartupCommands = null;
        if (inCommand == null || inCommand.trim().length() <= 0) {
            throw new ServiceException(314, "Empty command value.");
        }
        String identifier = this.isCommandInStartup(inCommand);
        if (identifier != null && identifier.trim().length() > 0) {
            AixPlatformTools.aixDebugLog(4, "  ++Looks like the entry is already in the Startup Commands: " + identifier + " Command: " + inCommand);
            return;
        }
        identifier = this.getUniqueIdentifierPrefix(inCommand);
        if (identifier == null || identifier.trim().length() <= 0) {
            throw new ServiceException(314, "Couldn't create identifier from command:" + inCommand);
        }
        String[] command = new String[]{new String("/usr/sbin/mkitab"), identifier + ":2:once:" + inCommand};
        AixExecCmd cmd = new AixExecCmd(command);
        if (cmd.getResult() != 0) {
            throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
        }
    }

    public void removeSystemStartupCommand(String inCommand) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "removeSystemStartupCommand(" + inCommand + ") in AixSystemUtilServiceImpl");
        this.cacheStartupCommands = null;
        String identifier = null;
        if (inCommand == null || inCommand.trim().length() <= 0) {
            throw new ServiceException(314, "Empty command value.");
        }
        identifier = this.isCommandInStartup(inCommand);
        if (identifier == null || identifier.trim().length() <= 0) {
            AixPlatformTools.aixDebugLog(4, "  ++Nothing to remove: " + inCommand);
            this.log(this, "wrn", "Could not find command in startup to remove");
            return;
        }
        String[] command = new String[]{new String("/usr/sbin/rmitab"), identifier};
        AixExecCmd cmd = new AixExecCmd(command);
        if (cmd.getResult() != 0) {
            throw new ServiceException(399, "Command failed: '" + cmd.getCmdString() + "'  rc = " + cmd.getResult() + " Error message: " + cmd.getErrors());
        }
    }

    public Enumeration systemStartupCommands() throws ServiceException {
        this.cacheStartupCommands = null;
        if (!this.getStartupCommands()) {
            throw new ServiceException(399, "Failed to get list of Startup Commands.");
        }
        return this.cacheStartupCommands.elements();
    }

    private String getUniqueIdentifierPrefix(String command) throws ServiceException {
        if (!this.getStartupCommands()) {
            this.log(this, "wrn", "Could not figure out if command is in startup list: " + command);
            AixPlatformTools.aixDebugLog(2, "  -- Can't figure out if command is in list: " + command);
            return null;
        }
        String identPrefix = new String(this.getIdentifierPrefix(command));
        if (identPrefix == null || identPrefix.trim().length() <= 0) {
            this.log(this, "wrn", "Could not get identifier for command: " + command);
            AixPlatformTools.aixDebugLog(2, "  -- Can't get identifier for command: " + command);
            return null;
        }
        int index = 0;
        String identifier = identPrefix + "IS" + index;
        while (this.cacheStartupCommands.containsKey(identifier)) {
            identifier = identPrefix + "IS" + ++index;
        }
        return identifier;
    }

    private String getIdentifierPrefix(String command) {
        String firstWord = "";
        String value = "";
        String result = "";
        firstWord = AixPlatformTools.getFieldFromString(command, 1);
        if (firstWord == null || firstWord.trim().length() <= 0) {
            return null;
        }
        int ix = firstWord.lastIndexOf(File.separator);
        value = ix < 0 || ix + 1 >= firstWord.trim().length() ? firstWord : firstWord.substring(ix + 1);
        for (ix = 0; ix < value.length() && result.length() < 10; ++ix) {
            char c = value.charAt(ix);
            if (!Character.isDigit(c) && !Character.isLetter(c)) continue;
            result = result + c;
        }
        return result;
    }

    private boolean getStartupCommands() throws ServiceException {
        if (this.cacheStartupCommands == null) {
            boolean result = false;
            String[] command = new String[]{new String("/usr/sbin/lsitab"), "-a"};
            AixExecCmd cmd = new AixExecCmd(command);
            if (cmd.getResult() == 0) {
                result = true;
                this.cacheStartupCommands = new Hashtable(20);
                Vector aLine = AixPlatformTools.convertStringToVector(cmd.getOutput(), "\n");
                Enumeration e = aLine.elements();
                while (e.hasMoreElements()) {
                    Vector lineFields = AixPlatformTools.convertStringToVector((String)e.nextElement(), ":", true);
                    if (lineFields.size() == 4) {
                        String simpleCommand = ((String)lineFields.elementAt(3)).trim();
                        int index = simpleCommand.indexOf("#");
                        if (index != -1) {
                            simpleCommand = simpleCommand.substring(0, index).trim();
                        }
                        this.cacheStartupCommands.put(lineFields.elementAt(0), simpleCommand);
                        continue;
                    }
                    this.log(this, "wrn", "  -- Failure adding element to hashtable: " + lineFields.elementAt(0) + " size: " + lineFields.size());
                    AixPlatformTools.aixDebugLog(2, "  -- Failure adding element to hashtable: " + lineFields.elementAt(0) + " size: " + lineFields.size());
                }
            } else {
                this.log(this, "wrn", "  -- Failure attempting to get list of commands rc: " + cmd.getResult() + " message: " + cmd.getErrors());
                AixPlatformTools.aixDebugLog(2, "  -- Failure attempting to get list of commands rc: " + cmd.getResult() + " message: " + cmd.getErrors());
            }
            return result;
        }
        return true;
    }

    private String isCommandInStartup(String inCommand) throws ServiceException {
        if (!this.getStartupCommands()) {
            this.log(this, "wrn", "Could not find command in startup list: " + inCommand);
            AixPlatformTools.aixDebugLog(2, "  -- Can't figure out if command is in list: " + inCommand);
            return null;
        }
        if (this.cacheStartupCommands.contains(inCommand)) {
            Enumeration e = this.cacheStartupCommands.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!((String)this.cacheStartupCommands.get(key)).equals(inCommand)) continue;
                return key;
            }
        }
        return null;
    }

    public void appendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "Entering appendEnvironmentVariable(" + variableName + "," + variableValue + "," + delimiter + ",level) in AixSystemUtilServiceImpl");
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            AixPlatformTools.aixDebugLog(4, "Calling append variable for group");
            group.appendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.appendVariable(variableName, variableValue, delimiter);
    }

    public void unAppendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "Entering unAppendEnvironmentVariable(" + variableName + "," + variableValue + "," + delimiter + ",level) in AixSystemUtilServiceImpl");
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            AixPlatformTools.aixDebugLog(4, "Calling unappend variable for group");
            group.unAppendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unAppendVariable(variableName, variableValue, delimiter);
    }

    public void prependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "Entering prependEnvironmentVariable(" + variableName + "," + variableValue + "," + delimiter + ",level) in AixSystemUtilServiceImpl");
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            AixPlatformTools.aixDebugLog(4, "Calling prepend variable for group");
            group.prependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.prependVariable(variableName, variableValue, delimiter);
    }

    public void unPrependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "Entering unPrependEnvironmentVariable(" + variableName + "," + variableValue + "," + delimiter + ",level) in AixSystemUtilServiceImpl");
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            AixPlatformTools.aixDebugLog(4, "Calling unprepend variable for group");
            group.unPrependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unPrependVariable(variableName, variableValue, delimiter);
    }

    public String getRawEnvironmentVariable(String variableName, int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "Entering getRawEnvironmentVariable(" + variableName + ",level) in AixSystemUtilServiceImpl");
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            AixPlatformTools.aixDebugLog(4, "Calling get raw variable for group");
            this.setLogoutRequired(true);
            return group.getVariable(variableName);
        }
        return null;
    }

    public boolean isRebootRequired() {
        AixPlatformTools.aixDebugLog(128, "isRebootRequired() in AixSystemUtilServiceImpl");
        if (this._rebootRequired) {
            this.log(this, "wrn", "Reboot after installation is requested.  You must reboot manually if necessary.");
        }
        return false;
    }

    public void setRebootRequired(boolean rebootRequired) {
        AixPlatformTools.aixDebugLog(128, "setRebootRequired() in AixSystemUtilServiceImpl");
        this._rebootRequired = rebootRequired;
    }

    private void verifyVariableName(String variableName) throws ServiceException {
        if (variableName == null || variableName.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.ibm.wizard.platform.aix.i18n.AixResources", "variableNameRequired"));
        }
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int level) throws ServiceException {
        AixPlatformTools.aixDebugLog(128, "Entering getEnvVarGroup");
        EnvironmentVariableManagerGroup group = null;
        ScriptEnvironmentVariableManager manager = null;
        if (this.currentProcessEnvVarManager == null) {
            this.currentProcessEnvVarManager = new AixProcessEnvironmentVariableManager();
        }
        try {
            if (level == 2) {
                AixPlatformTools.aixDebugLog(4, "level is user level");
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    File scriptFile = new File(System.getProperty("user.home"), userBourne_KshScript);
                    AixPlatformTools.aixDebugLog(4, "scriptfile for b/ksh is: " + scriptFile);
                    if (scriptFile.exists()) {
                        AixPlatformTools.aixDebugLog(4, scriptFile + " exists.");
                        manager = new BourneShellManager(scriptFile.getAbsolutePath());
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                    scriptFile = new File(System.getProperty("user.home"), userCshScript);
                    AixPlatformTools.aixDebugLog(4, "scriptfile for csh is: " + scriptFile);
                    if (scriptFile.exists()) {
                        AixPlatformTools.aixDebugLog(4, scriptFile + " exists.");
                        manager = new CShellManager(scriptFile.getAbsolutePath());
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                }
                group = userEnvVarGroup;
            } else {
                AixPlatformTools.aixDebugLog(4, "level is system level");
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String scriptFile = systemScript;
                    AixPlatformTools.aixDebugLog(4, "scriptfile for system is: " + scriptFile);
                    if (new File(scriptFile).exists()) {
                        AixPlatformTools.aixDebugLog(4, scriptFile + " exists.");
                        manager = new BourneShellManager(scriptFile);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                }
                group = systemEnvVarGroup;
            }
        }
        catch (IOException ex) {
            throw new ServiceException(ex);
        }
        return group;
    }

    protected void deleteFilesAfterExit() {
        String dirName;
        String dirInVector;
        int i;
        boolean placed;
        AixPlatformTools.aixDebugLog(128, "Entering deleteFilesAfterExit");
        super.deleteFilesAfterExit();
        String fileArgs = "";
        Vector<String> sortedDirectories = new Vector<String>();
        Enumeration files = this.filesToDeleteOnExit();
        while (files.hasMoreElements()) {
            String fileName = (String)files.nextElement();
            if (sortedDirectories == null || sortedDirectories.size() == 0) {
                sortedDirectories.addElement(fileName);
            } else {
                placed = false;
                for (i = 0; i < sortedDirectories.size(); ++i) {
                    dirInVector = (String)sortedDirectories.elementAt(i);
                    if (fileName.compareTo(dirInVector) > 0) {
                        sortedDirectories.insertElementAt(fileName, i);
                        placed = true;
                        break;
                    }
                    if (fileName.compareTo(dirInVector) != 0) continue;
                    placed = true;
                }
                if (!placed) {
                    sortedDirectories.addElement(fileName);
                }
            }
            AixPlatformTools.aixDebugLog(4, " Remove file: " + fileName + " after exit");
            super.removeFileToDeleteOnExit(fileName);
        }
        Enumeration dirs = this.directoriesToRecursivelyDeleteOnExit();
        while (dirs.hasMoreElements()) {
            dirName = (String)dirs.nextElement();
            if (sortedDirectories == null || sortedDirectories.size() == 0) {
                sortedDirectories.addElement(dirName);
            } else {
                placed = false;
                for (i = 0; i < sortedDirectories.size(); ++i) {
                    dirInVector = (String)sortedDirectories.elementAt(i);
                    if (dirName.compareTo(dirInVector) > 0) {
                        sortedDirectories.insertElementAt(dirName, i);
                        placed = true;
                        break;
                    }
                    if (dirName.compareTo(dirInVector) != 0) continue;
                    placed = true;
                }
                if (!placed) {
                    sortedDirectories.addElement(dirName);
                }
            }
            super.removeDirectoryToRecursivelyDeleteOnExit(dirName);
        }
        Enumeration sortedDirs = sortedDirectories.elements();
        while (sortedDirs.hasMoreElements()) {
            dirName = (String)sortedDirs.nextElement();
            AixPlatformTools.aixDebugLog(4, " Remove directory: " + dirName + " after exit");
            fileArgs = fileArgs + dirName + " ";
        }
        if ((fileArgs = fileArgs.trim()) != null && fileArgs.length() > 0) {
            this.nativeDeleteFilesAfterExit(fileArgs);
        }
        AixPlatformTools.aixDebugLog(128, "Leaving deleteFilesAfterExit");
    }

    public void cleanup() throws ServiceException {
        super.cleanup();
        if (userEnvVarGroup != null) {
            userEnvVarGroup.makeUpdatePersistent();
        }
        if (systemEnvVarGroup != null) {
            systemEnvVarGroup.makeUpdatePersistent();
        }
    }

    static {
        PLATFORM_ID = "aixppk";
    }
}

