/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.CommandLineListener;
import com.ibm.wizard.platform.linux.JProcessCommand;
import com.ibm.wizard.platform.linux.LinuxCalderaCommands;
import com.ibm.wizard.platform.linux.UnixCrypt;
import com.ibm.wizard.platform.linux.utils.NativeProcessProxy;
import com.ibm.wizard.platform.linux.utils.RPM;
import com.ibm.wizard.platform.linux.utils.SimpleLinuxPPKLogger;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.File;
import java.util.StringTokenizer;

public class GenericLinuxCommands {
    protected static String sh = "sh";
    protected static String c = "-c";
    public static boolean debugEnabled = false;
    static RPM rpm;
    protected static String[] distributions;
    protected static String[] versions;
    public static final int GETFILEATTRIBUTES = 0;
    public static final int GETFILEOWNER = 1;
    public static final int GETFILEOWNERGROUP = 2;
    public static final int GETFILESIZE = 3;
    protected static CommandLineListener commandListener;
    protected static String[] cmdArray;
    protected static JProcessCommand process;
    UnixCrypt encryptPassword;

    public static boolean isValidDistribution() {
        return true;
    }

    public String locateExecutable(String exeName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("type -path \"" + exeName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String result = commandListener.getOutput();
        if (result.indexOf(10) != -1) {
            result = result.substring(0, result.lastIndexOf(10));
        }
        return result;
    }

    public String mountInfo() {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("mount");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String fileSystemInfo(String partitionName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("df " + partitionName);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String fileSystemType(String partitionName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("df -T " + partitionName);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public void makeDirectory(String pathName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("mkdir -p \"" + pathName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void removeFiles(String pathName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rm -rf \"" + pathName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public String doesUserExist(String name) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("cat /etc/passwd | grep \"" + name + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public void deleteUser(String userName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("userdel \"" + userName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void deleteGroup(String groupName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("groupdel \"" + groupName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public String getEnvVariable(String envVariable) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("echo $" + envVariable);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public void source(String fileName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("source " + fileName);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public String getKernelVersion() {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("uname -r");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public String queryRPMDB(String packageName) {
        String queryOutput = this.getCommandLineResult(new String[]{"sh", "-c", "rpm -q " + packageName});
        if (queryOutput != null) {
            return queryOutput;
        }
        return "";
    }

    public String getRPMName(String packageName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -qp \"" + packageName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        return commandListener.getOutput();
    }

    public boolean doesRPMPackageExist(String packageName) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("rpm -qa | grep -x \"" + packageName + "\"");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        String result = commandListener.getOutput();
        if (result.indexOf(10) != -1) {
            result = result.substring(0, result.lastIndexOf(10));
        }
        return result.equals(packageName);
    }

    public void kpanelRestart() {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("kwmcom kpanel:restart");
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void removeRPMPackage(String packageName) {
        this.getCommandLineResult(new String[]{"sh", "-c", "rpm -e --allmatches \"" + packageName + "\""});
    }

    public void createGroup(GroupSpecification groupSpec) {
        String groupadd = "groupadd ";
        groupadd = groupadd + groupSpec.getGroupName();
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray(groupadd);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void createUser(UserSpecification userSpec) {
        String fullName;
        String encPassword = null;
        String useradd = "useradd ";
        String home = userSpec.getHomeDirectory();
        if (home != null) {
            useradd = useradd + "-d \"" + home + "\" ";
        }
        if ((fullName = userSpec.getUserFullName()) != null) {
            useradd = useradd + "-c \"" + fullName + "\" ";
        }
        useradd = useradd + "-m ";
        String password = userSpec.getPassword();
        if (password != null) {
            encPassword = UnixCrypt.crypt(this.getRandomSalt(), password);
            if (!LinuxCalderaCommands.isValidDistribution()) {
                useradd = useradd + "-p \"" + encPassword + "\" ";
            }
        }
        if (userSpec.getGroups() != null) {
            useradd = useradd + "-n ";
            useradd = useradd + "-G ";
            GroupSpecification[] g = userSpec.getGroups();
            for (int i = 0; i < g.length; ++i) {
                if (i > 0) {
                    useradd = useradd + ",";
                }
                useradd = useradd + g[i].getGroupName();
            }
            useradd = useradd + " ";
        }
        useradd = useradd + userSpec.getUserName();
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray(useradd);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void createUserHomeDirectory(String directoryPath, String userName, String groupName) {
        this.copyFiles("/etc/skel", "/home/skel/", "-r");
        this.moveFiles("/home/skel", directoryPath, "");
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("chown -R " + userName + "." + groupName + " " + directoryPath);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void copyFiles(String sourceDir, String targetDir, String flags) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("cp " + flags + " " + sourceDir + " " + targetDir);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void moveFiles(String sourceDir, String targetDir, String flags) {
        commandListener = new CommandLineListener();
        cmdArray = GenericLinuxCommands.getCommandArray("mv " + flags + " " + sourceDir + " " + targetDir);
        process = new JProcessCommand(commandListener, cmdArray, null, true);
        commandListener.getOutput();
    }

    public void modifyUserPassword(String userName, String password) {
    }

    protected static String[] getCommandArray(String command) {
        String[] cmdArray = new String[]{sh, c, command};
        return cmdArray;
    }

    protected String getRandomSalt() {
        int[] naSalts = new int[62];
        int index = 0;
        int rNum = 0;
        StringBuffer sbSalt = new StringBuffer();
        int i = 48;
        while (i < 58) {
            naSalts[index++] = i++;
        }
        i = 65;
        while (i < 91) {
            naSalts[index++] = i++;
        }
        i = 97;
        while (i < 123) {
            naSalts[index++] = i++;
        }
        rNum = (int)(Math.random() * 62.0);
        sbSalt.append((char)naSalts[rNum]);
        rNum = (int)(Math.random() * 62.0);
        sbSalt.append((char)naSalts[rNum]);
        return sbSalt.toString();
    }

    public void installRPMPackage(String packageName, String flags) {
        if (flags == null) {
            flags = "";
        }
        NativeProcessProxy proxy = null;
        try {
            proxy = new NativeProcessProxy(new String[]{"sh", "-c", "rpm -i " + flags + " \"" + packageName + "\""});
            Thread thread = new Thread(proxy);
            thread.start();
            thread.join();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    boolean isRPMSpecInstalled(RPM rpm2) {
        String result;
        boolean installed = false;
        String rpmspecBinaryName = rpm2.major.equals("3") ? RPM.RPMSPEC : RPM.RPMSPEC4;
        String rpmdbCheck = this.queryRPMDB(rpmspecBinaryName);
        installed = rpmdbCheck.startsWith(rpmspecBinaryName);
        if (!installed && (result = this.getCommandLineResult(new String[]{"sh", "-c", "type -path " + rpmspecBinaryName})) != null) {
            installed = new File(result).getName().equals(rpmspecBinaryName);
        }
        if (System.getProperty("is.debug") != null) {
            if (installed) {
                System.out.println("rpmspec.debug - rpmspec utility is installed in the system");
            } else {
                System.out.print("rpmspec.debug - generic linux commands - rpmspec utility is not installed in the sytem - RPM package registration will be skipped -");
                System.out.println("rpmspec utility can be installed on demand by using LinuxRPMCheckInstallPanel");
            }
        }
        return installed;
    }

    boolean isRPMSpecRunnable(RPM rpmVersion) {
        Object proxy = null;
        boolean runnable = false;
        if (rpmVersion.major.equals("3")) {
            return true;
        }
        String result = this.getCommandLineResult(new String[]{"sh", "-c", "type -path " + RPM.RPMSPEC4});
        if (result != null) {
            boolean bl = runnable = this.getCommandLineExitValue(new String[]{"sh", "-c", result + " -test"}) == 0;
        }
        if (System.getProperty("is.debug") != null) {
            if (runnable) {
                System.out.println("rpmspec.debug -" + RPM.RPMSPEC4 + " test mode succeded");
            } else {
                System.out.print("rpmspec.debug -" + RPM.RPMSPEC4 + " test mode failed - ");
                System.out.print("some dynamic libraries required by rpmspec4 may not be available in the system -");
                System.out.println("contact support.installshield.com/kb for further details");
            }
        }
        return runnable;
    }

    private String getCommandLineResult(String[] command) {
        NativeProcessProxy proxy = null;
        try {
            proxy = new NativeProcessProxy(command);
            Thread thread = new Thread(proxy);
            thread.start();
            thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proxy.getResult();
    }

    private int getCommandLineExitValue(String[] command) {
        NativeProcessProxy proxy = null;
        try {
            proxy = new NativeProcessProxy(command);
            Thread thread = new Thread(proxy);
            thread.start();
            thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return proxy.getExitValue();
    }

    public boolean isHostRPMSupported(RPM rpm2) {
        NativeProcessProxy proxy = null;
        boolean supported = false;
        try {
            proxy = new NativeProcessProxy(new String[]{"sh", "-c", "rpm --version"});
            Thread thread = new Thread(proxy);
            thread.start();
            thread.join();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (proxy.getResult() != null) {
            try {
                StringTokenizer tokens = new StringTokenizer(proxy.getResult());
                tokens.nextToken();
                tokens.nextToken();
                tokens = new StringTokenizer(tokens.nextToken(), ".");
                String major = tokens.nextToken(".");
                supported = major.equals(rpm2.major);
            }
            catch (Exception e) {
                supported = false;
            }
        }
        return supported;
    }

    public static void linuxPPKDebugPrint(String mesg) {
        SimpleLinuxPPKLogger.log(mesg);
    }

    static {
        debugEnabled = System.getProperty("is.debug") != null;
    }
}

