/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.JProcessListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class JProcessCommand
implements Runnable {
    private static String dataString;
    private static int returnCode;
    private static int processReturnCode;
    private static Thread runner;
    private String[] args;
    private String[] env;
    private boolean waitBoolean;
    private JProcessListener caller;

    public JProcessCommand(JProcessListener jProcess, String[] argArray, String[] envArray, boolean aBoolean) throws IllegalArgumentException {
        if (argArray == null || argArray.length == 0 || jProcess == null) {
            throw new IllegalArgumentException();
        }
        this.caller = jProcess;
        this.args = argArray;
        this.env = envArray;
        this.waitBoolean = aBoolean;
        runner = new Thread(this);
        runner.start();
    }

    public void run() {
        block12: {
            try {
                block11: {
                    if (System.getProperty("is.debug.linux.jprocesscommand") != null) {
                        for (int i = 0; i < this.args.length; ++i) {
                            System.out.println("args" + i + " = " + this.args[i]);
                        }
                    }
                    returnCode = 0;
                    processReturnCode = 0;
                    Process process = Runtime.getRuntime().exec(this.args, this.env);
                    returnCode = this.waitBoolean ? process.waitFor() : process.exitValue();
                    StringBuffer buf = new StringBuffer();
                    String line = null;
                    BufferedReader data = returnCode != 0 ? new BufferedReader(new InputStreamReader(process.getErrorStream())) : new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        while ((line = data.readLine()) != null) {
                            buf.append(line + System.getProperty("line.separator"));
                        }
                        dataString = buf.toString();
                        if (System.getProperty("is.debug.linux.jprocesscommand") != null) {
                            String debugLine;
                            StringBuffer debugBuf = new StringBuffer();
                            BufferedReader debugReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            while ((debugLine = debugReader.readLine()) != null) {
                                debugBuf.append(debugLine + System.getProperty("line.separator"));
                            }
                            System.out.println("Debug RC = " + returnCode + " Output = " + debugBuf.toString());
                        }
                    }
                    catch (Exception e) {
                        dataString = "Process Returned RC " + returnCode;
                        if (System.getProperty("is.debug.linux.jprocesscommand") == null) break block11;
                        System.out.println("In inner nulldata process RC = " + dataString);
                    }
                }
                if (this.waitBoolean) {
                    this.caller.JProcessComplete(JProcessCommand.getData(), JProcessCommand.returnCode());
                }
            }
            catch (Exception e) {
                returnCode = 20;
                processReturnCode = 20;
                dataString = e.toString();
                this.caller.JProcessComplete(JProcessCommand.getData(), JProcessCommand.returnCode());
                if (System.getProperty("is.debug.linux.jprocesscommand") == null) break block12;
                System.out.println("In outer nulldata process RC = " + dataString);
            }
        }
        if (runner != null) {
            runner = null;
        }
    }

    public static boolean isAlive() {
        return runner.isAlive();
    }

    public static int processReturnCode() {
        return processReturnCode;
    }

    public static int returnCode() {
        return returnCode;
    }

    public static String getData() {
        return dataString;
    }

    public static void yieldThread() {
        if (runner.isAlive()) {
            runner.yield();
        }
    }

    public static void killThread() {
        if (runner.isAlive()) {
            runner = null;
        }
    }
}

