/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.utils.SimpleLinuxPPKLogger;
import com.ibm.wizard.platform.linux.utils.UnixShellInterface;
import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.GenericUnixFileAttributes;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinuxFileServiceImpl
extends PureJavaFileServiceImpl {
    private static final String copyright = "(C) Copyright IBM Corporation 2000, 2001.";
    private static String UX = "u+x";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();
    private boolean initialized = false;

    public String getName() {
        return "LinuxFileServiceImpl";
    }

    public int getSystemCompatibility() {
        int result = 0;
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            result = 5;
        }
        return result;
    }

    protected void initialized() {
        super.initialized();
        try {
            this.initialized = UnixShellInterface.initialize(this.getServiceResource("reslib/linuxppk/gushellsupport.sh"));
        }
        catch (IOException ex) {
            System.err.println("Error: Linux File Service Initialization Failed. Turn on the System property 'EnableLinuxPPKLogger' for more stack trace details");
            SimpleLinuxPPKLogger.log(ex);
        }
        catch (ServiceException se) {
            System.err.println("Error: Linux File Service Initialization Failed. Turn on the System property 'EnableLinuxPPKLogger' for more stack trace details");
            SimpleLinuxPPKLogger.log(se);
        }
    }

    public void cleanup() throws ServiceException {
        UnixShellInterface.shutDown();
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String directory, boolean ifEmpty, boolean includeSubDirs) throws ServiceException {
        returnValue = 0;
        error = false;
        errorMessage = "";
        dirName = this.createFileName(this.getCurrentDirectory(), directory);
        if (this.fileExists(dirName) && this.isDirectory(dirName) && this.getParent(dirName) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(dirName)) {
            if (!ifEmpty && !includeSubDirs) {
                try {
                    dirCmdString = CoreFileUtils.appendSeparator(dirName, this.getSeparator()) + "*";
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + dirCmdString + "\""});
                    if (info.getExitCode() == 0) {
                        info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                        if (info.getExitCode() == 0) ** GOTO lbl42
                        error = true;
                        errorMessage = info.getStderr();
                    }
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (ifEmpty && !includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else if (!ifEmpty && includeSubDirs) {
                try {
                    info = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + dirName + "\""});
                    if (info.getExitCode() == 0) ** GOTO lbl42
                    error = true;
                    errorMessage = info.getStderr();
                }
                catch (Exception genErr) {
                    throw new ServiceException(genErr);
                }
            } else {
                returnValue = super.deleteDirectory(directory, ifEmpty, includeSubDirs);
            }
        }
lbl42:
        // 10 sources

        if (error) {
            throw new ServiceException(2, "Error deleting directory: " + errorMessage);
        }
        return returnValue;
    }

    public void setFileCreated(String fileName, long date) throws ServiceException {
    }

    public void setFileModified(String fileName, long date) throws ServiceException {
        if (this.initialized) {
            UnixShellInterface.getNativeObject().invokeMethod("setFileModified", new String[]{GenericUnixCommands.formatFileName(fileName), LinuxFileServiceImpl.convertDate(date)});
        }
    }

    public void setFileTimes(String fileName, long creationDate, long accessDate, long writeDate) throws ServiceException {
        if (this.initialized) {
            UnixShellInterface.getNativeObject().invokeMethod("setFileTimes", new String[]{GenericUnixCommands.formatFileName(fileName), LinuxFileServiceImpl.convertDate(creationDate), LinuxFileServiceImpl.convertDate(accessDate), LinuxFileServiceImpl.convertDate(writeDate)});
        }
    }

    public String getSeparator() {
        return "/";
    }

    public String getNamedDirectory(String directoryName) throws ServiceException {
        if (directoryName.equals("home")) {
            return System.getProperty("user.home");
        }
        if (directoryName.equals("install")) {
            return "/opt";
        }
        if (directoryName.equals("lib")) {
            return "/usr/lib";
        }
        if (directoryName.equals("log")) {
            return "/var/log";
        }
        if (directoryName.equals("temp")) {
            return "/tmp";
        }
        if (directoryName.equals("timestamp")) {
            return "" + new Date().getTime();
        }
        return super.getNamedDirectory(directoryName);
    }

    public void validateFileName(String fileName) throws ServiceException {
        String invalidChars = ":*?\"<>|^!";
        for (int i = 0; i < fileName.length(); ++i) {
            if (invalidChars.indexOf(fileName.charAt(i)) == -1) continue;
            throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{invalidChars}));
        }
    }

    public String[] getPartitionNames() throws ServiceException {
        String output = GenericUnixCommands.getMountPoints();
        Vector<String> names = new Vector<String>();
        int startIndex = 0;
        int endIndex = output.indexOf(10);
        while (endIndex != -1) {
            StringTokenizer tokenizer = new StringTokenizer(output.substring(startIndex, endIndex), " ");
            String token = tokenizer.nextToken();
            if (token.indexOf("/") >= 0) {
                token = tokenizer.nextToken();
                names.addElement(tokenizer.nextToken());
            }
            startIndex = endIndex + 1;
            endIndex = output.indexOf(10, startIndex);
        }
        Object[] partitions = new String[names.size()];
        names.copyInto(partitions);
        return partitions;
    }

    public long getPartitionFreeSpace(String partitionName) throws ServiceException {
        if (this.initialized) {
            return Long.parseLong(UnixShellInterface.getNativeObject().invokeMethod("getPartitionFreeSpace", new String[]{partitionName}));
        }
        return -1L;
    }

    public boolean isPartitionWritable(String partitionName) throws ServiceException {
        String value = GenericUnixCommands.getMountPoints();
        boolean found = false;
        boolean writable = false;
        int startIndex = 0;
        int endIndex = value.indexOf(10);
        while (endIndex != -1 && !found) {
            String line = value.substring(startIndex, endIndex);
            if (this.getToken(line, " ", 3).compareTo(partitionName) == 0) {
                found = true;
                if (this.getToken(line, " ", 6).indexOf(119) != -1) {
                    writable = true;
                }
            }
            startIndex = endIndex + 1;
            endIndex = value.indexOf(10, startIndex);
        }
        return writable;
    }

    public int getPartitionType(String partitionName) throws ServiceException {
        return !(partitionName = partitionName.trim()).startsWith("/dev/") || !partitionName.substring(5).endsWith("cd") && !partitionName.substring(5).endsWith("fd") && !partitionName.substring(5).endsWith("rmt") ? 1 : 2;
    }

    public String getPartitionFormat(String partitionName) throws ServiceException {
        String output = this.commandLineInterface.fileSystemType(partitionName);
        int startIndex = output.indexOf(10);
        return this.getToken(output.substring(startIndex), " ", 2);
    }

    public boolean supportsLongFileNames(String partitionName) throws ServiceException {
        try {
            File longFile = new File(partitionName + "\\Longfilename.test.temporary");
            if (!longFile.exists()) {
                FileOutputStream fos = new FileOutputStream(longFile);
                fos.close();
                longFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public FileAttributes getFileAttributes(String fileName) throws ServiceException {
        if (this.initialized) {
            String attrib = UnixShellInterface.getNativeObject().invokeMethod("getFileAttributes", new String[]{GenericUnixCommands.formatFileName(fileName)});
            return GenericUnixFileAttributes.getAttributeObject(Integer.parseInt(attrib));
        }
        return null;
    }

    public void setFileAttributes(String fileName, FileAttributes attributes) throws ServiceException {
        try {
            if (this.initialized) {
                UnixShellInterface.getNativeObject().invokeMethod("setFileAttributes", new String[]{GenericUnixCommands.formatFileName(fileName), LinuxFileServiceImpl.getGUMode(attributes)});
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public void setFileExecutable(String fileName) throws ServiceException {
        FileAttributes attrib = this.getFileAttributes(fileName);
        if (attrib != null) {
            attrib.setAttributeState(292, true);
            this.setFileAttributes(fileName, attrib);
        }
    }

    public String getFileOwner(String fileName) throws ServiceException {
        if (this.initialized) {
            return UnixShellInterface.getNativeObject().invokeMethod("getFileOwner", new String[]{GenericUnixCommands.formatFileName(fileName)});
        }
        return null;
    }

    public void setFileOwner(String fileName, String userid) throws ServiceException {
        if (this.initialized) {
            UnixShellInterface.getNativeObject().invokeMethod("setFileOwner", new String[]{GenericUnixCommands.formatFileName(fileName), userid});
        }
    }

    public String getFileOwnerGroup(String fileName) throws ServiceException {
        if (this.initialized) {
            return UnixShellInterface.getNativeObject().invokeMethod("getFileOwnerGroup", new String[]{GenericUnixCommands.formatFileName(fileName)});
        }
        return null;
    }

    public void setFileOwnerGroup(String fileName, String groupid) throws ServiceException {
        if (this.initialized) {
            UnixShellInterface.getNativeObject().invokeMethod("setFileOwnerGroup", new String[]{GenericUnixCommands.formatFileName(fileName), groupid});
        }
    }

    public void setSystemUMask(int mode) throws ServiceException {
        throw new ServiceException(305, FileService.NAME + "Setting umask is not supported by Linux File Service Impl");
    }

    public int getSystemUMask() throws ServiceException {
        if (this.initialized) {
            return Integer.parseInt(UnixShellInterface.getNativeObject().invokeMethod("getSystemUMask", new String[0]));
        }
        return -1;
    }

    public static String getGUMode(FileAttributes attributes) {
        return GenericUnixFileAttributes.getGUMode(attributes);
    }

    private String getToken(String string, String delimeter, int tokenNum) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimeter);
        String token = null;
        for (int x = 0; x < tokenNum; ++x) {
            token = tokenizer.nextToken();
        }
        return token;
    }

    private String getCalendarField(Calendar cal, int field) {
        StringBuffer temp = new StringBuffer();
        if (field == 2) {
            temp.append(cal.get(field) + 1);
        } else {
            temp.append(cal.get(field));
        }
        if (field != 1 && temp.length() < 2) {
            temp.insert(0, 0);
        }
        return temp.toString();
    }

    private void debug(String s) {
        if (System.getProperty("linux.gusupport") != null) {
            System.out.println(s);
        }
    }

    private static String convertDate(long time) {
        return sdf.format(new Date(time));
    }

    public void createSymbolicLink(String target, String linkName, boolean forceLink) throws ServiceException {
        GenericUnixCommands.createSymbolicLink(target, linkName, forceLink);
    }

    public void removeSymbolicLink(String linkName) throws ServiceException {
        GenericUnixCommands.removeSymbolicLink(linkName);
    }
}

