/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.installshield.util.CommandResult;
import com.installshield.util.CommandUtils;
import java.io.File;

public class LinuxPlatform {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    public static final int LINUX_ANY = 1;
    public static final int ARCH_ANY = 0;
    private static final String SH = "sh";
    private static final String C = "-c";
    private static final String QUERY = "rpm -q --queryformat '%VERSION'";
    public static final int ARCH_X86 = 0;

    public static boolean isCompatibleWith(int nOS, int nArch) {
        boolean osCompatibility = false;
        boolean archCompatibility = false;
        String osName = System.getProperty("os.name");
        String checkName = "Linux";
        if (osName.length() >= checkName.length() && osName.substring(0, checkName.length()).equalsIgnoreCase(checkName) && nOS == 1) {
            osCompatibility = true;
        }
        if (System.getProperty("os.arch").indexOf("86") != -1) {
            archCompatibility = true;
        }
        return osCompatibility;
    }

    public static boolean isLinuxByUname() {
        try {
            CommandResult info;
            String unameCmd = "uname";
            if (new File("/usr/bin/uname").exists()) {
                unameCmd = "/usr/bin/uname";
            }
            if ((info = CommandUtils.executeCommand(SH, new String[]{C, unameCmd})).getExitCode() == 0) {
                return info.getStdout().toLowerCase().indexOf("linux") >= 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String[] getCommandArray(String command) {
        String[] cmdArray = new String[]{SH, C, command};
        return cmdArray;
    }
}

