/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.installshield.boot.CoreFileUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.util.GenericUnixCommands;
import com.installshield.wizard.platform.common.util.UnixCrypt;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.SecurityServiceImplementor;
import com.installshield.wizard.service.security.UserSpecification;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class LinuxSecurityServiceImpl
extends PureJavaSecurityServiceImpl
implements SecurityServiceImplementor {
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();
    UnixCrypt encryptPassword;
    static final String commandFile = "/tmp/_ISMP40_TMP/_Caldera/_EncryptedPassword/passwordCommand";
    String passwordFile = "/tmp/_ISMP40_TMP/_Caldera/_EncryptedPassword/passwordList";
    String passwordDir = "/tmp/_ISMP40_TMP/_Caldera/_EncryptedPassword/";
    private static int S_ISUID = 2048;
    private static int S_ISGID = 1024;
    private static int S_ISVTX = 512;
    private static int S_IRWXU = 448;
    private static int S_IRUSR = 256;
    private static int S_IWUSR = 128;
    private static int S_IXUSR = 64;
    private static int S_IRWXG = 56;
    private static int S_IRGRP = 32;
    private static int S_IWGRP = 16;
    private static int S_IXGRP = 8;
    private static int S_IRWXO = 7;
    private static int S_IROTH = 4;
    private static int S_IWOTH = 2;
    private static int S_IXOTH = 1;

    public int getSystemCompatibility() {
        int result = 0;
        try {
            if (LinuxPlatform.isCompatibleWith(1, 0)) {
                result = 5;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        return System.getProperty("user.name").equals("root");
    }

    private String getCurrentUserId() {
        return System.getProperty("user.name");
    }

    public void createGroup(GroupSpecification group) throws ServiceException {
        if (!this.isCurrentUserAdmin()) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "LinuxSecurityServiceImpl.cannotAddGroupNotAdmin", new String[]{group.getGroupName()}));
        }
        GenericUnixCommands.createGroup(group);
    }

    public void deleteGroup(String groupName) throws ServiceException {
        if (!this.isCurrentUserAdmin()) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "LinuxSecurityServiceImpl.cannotDeleteGroupNotAdmin", new String[]{groupName}));
        }
        GenericUnixCommands.deleteGroup(groupName);
    }

    private boolean userExists(String filepath, String user) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filepath)));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line.trim(), ":");
                String username = st.nextToken();
                if (username != null && username.trim().equals(user)) {
                    return true;
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String file1, String file2) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(new File(file1));
            out = new FileOutputStream(new File(file2));
            CoreFileUtils.copy(in, out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception genErr) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception genErr) {}
        }
    }

    private String updateUserPassword(String str, String pass) {
        StringBuffer line = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, ":", true);
        int ctr = 0;
        int passwordIdx = 2;
        while (st.hasMoreTokens()) {
            String thisToken = st.nextToken();
            if (ctr == passwordIdx) {
                line.append(pass);
            } else {
                line.append(thisToken);
            }
            ++ctr;
        }
        return line.toString();
    }

    private void updateTempFile(String user, String pass, String tempFile, String sourceFile) throws Exception {
        BufferedReader reader = null;
        FileOutputStream out = null;
        PrintWriter writer = null;
        reader = new BufferedReader(new InputStreamReader(new FileInputStream(sourceFile)));
        out = new FileOutputStream(tempFile);
        writer = new PrintWriter(out);
        String line = reader.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line.trim(), ":");
            String username = st.nextToken();
            String output = "";
            output = username != null && username.trim().equals(user) ? this.updateUserPassword(line, pass) : line;
            writer.println(output);
            line = reader.readLine();
        }
        reader.close();
        writer.flush();
        writer.close();
        writer = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createUser(UserSpecification user) throws ServiceException {
        if (!this.isCurrentUserAdmin()) throw new ServiceException(2, LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "LinuxSecurityServiceImpl.cannotAddUserNotAdmin", new String[]{user.getUserName()}));
        if (this.groupExists(user.getUserName())) {
            user.setPrimaryGroup(user.getUserName());
        }
        GenericUnixCommands.createUser(user);
        String password = user.getPassword();
        if (password == null) return;
        String shadowFilePath = "/etc/shadow";
        String passwdFilePath = "/etc/passwd";
        String backupShadowFilePath = "/etc/shadow.backup";
        String backupPasswdFilePath = "/etc/passwd.backup";
        File shadowFile = new File(shadowFilePath);
        String userName = user.getUserName();
        String encPassword = UnixCrypt.crypt(UnixCrypt.getRandomSalt(), password);
        try {
            if (shadowFile.exists() && this.userExists(shadowFilePath, userName)) {
                this.copyFile(shadowFilePath, backupShadowFilePath);
                String tempShadow = CoreFileUtils.createTempFile();
                try {
                    this.updateTempFile(userName, encPassword, tempShadow, shadowFilePath);
                    this.copyFile(tempShadow, shadowFilePath);
                    return;
                }
                catch (Exception e) {
                    this.copyFile(backupShadowFilePath, shadowFilePath);
                }
                return;
            } else {
                if (!this.userExists(passwdFilePath, userName)) return;
                this.copyFile(passwdFilePath, backupPasswdFilePath);
                String tempPasswd = CoreFileUtils.createTempFile();
                try {
                    this.updateTempFile(userName, encPassword, tempPasswd, passwdFilePath);
                    this.copyFile(tempPasswd, passwdFilePath);
                    return;
                }
                catch (Exception e) {
                    this.copyFile(backupPasswdFilePath, passwdFilePath);
                }
            }
            return;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    private boolean groupExists(String group) {
        boolean exists;
        block5: {
            if (group == null) {
                return false;
            }
            exists = false;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/etc/group")));
                String line = reader.readLine();
                while (line != null) {
                    StringTokenizer st = new StringTokenizer(line.trim(), ":");
                    String groupName = st.nextToken();
                    if (groupName != null && groupName.trim().equals(group)) {
                        exists = true;
                        break;
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception e) {
                if (System.getProperty("is.debug") == null) break block5;
                e.printStackTrace();
            }
        }
        return exists;
    }

    public void deleteUser(String user) throws ServiceException {
        if (!this.isCurrentUserAdmin()) {
            throw new ServiceException(2, LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "LinuxSecurityServiceImpl.cannotDeleteUserNotAdmin", new String[]{user}));
        }
        GenericUnixCommands.deleteUser(user);
    }

    private String getToken(String string, String delimiter, int tokenNum) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        String token = null;
        for (int x = 0; x < tokenNum; ++x) {
            token = tokenizer.nextToken();
        }
        return token;
    }

    protected String getRandomSalt() {
        int[] naSalts = new int[62];
        int index = 0;
        int rNum = 0;
        StringBuffer sbSalt = new StringBuffer();
        int i = 48;
        while (i < 58) {
            naSalts[index++] = i++;
        }
        i = 65;
        while (i < 91) {
            naSalts[index++] = i++;
        }
        i = 97;
        while (i < 123) {
            naSalts[index++] = i++;
        }
        rNum = (int)(Math.random() * 62.0);
        sbSalt.append((char)naSalts[rNum]);
        rNum = (int)(Math.random() * 62.0);
        sbSalt.append((char)naSalts[rNum]);
        return sbSalt.toString();
    }

    public static FileAttributes getAttributeObject(int mode) {
        FileAttributes attributes = new FileAttributes();
        if ((mode & S_IRUSR) == S_IRUSR) {
            attributes.setAttributeState(1, true);
        }
        if ((mode & S_IRGRP) == S_IRGRP) {
            attributes.setAttributeState(8, true);
        }
        if ((mode & S_IROTH) == S_IROTH) {
            attributes.setAttributeState(64, true);
        }
        if ((mode & S_IWUSR) == S_IWUSR) {
            attributes.setAttributeState(2, true);
        }
        if ((mode & S_IWGRP) == S_IWGRP) {
            attributes.setAttributeState(16, true);
        }
        if ((mode & S_IWOTH) == S_IWOTH) {
            attributes.setAttributeState(128, true);
        }
        if ((mode & S_IXUSR) == S_IXUSR) {
            attributes.setAttributeState(4, true);
        }
        if ((mode & S_IXGRP) == S_IXGRP) {
            attributes.setAttributeState(32, true);
        }
        if ((mode & S_IXOTH) == S_IXOTH) {
            attributes.setAttributeState(256, true);
        }
        return attributes;
    }
}

