/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.utils.ProcessEnvironmentVariableManager;
import com.ibm.wizard.platform.linux.utils.SimpleLinuxPPKLogger;
import com.ibm.wizard.platform.linux.utils.UnixShellInterface;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.environment.BashShellManager;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.IOException;

public class LinuxSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    private GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();
    private static final String systemCshScript = "/etc/csh.login";
    private static final String userCshScript = ".login";
    private static final String systemBourneScript = "/etc/profile";
    private static final String userBourneScript = ".profile";
    private static final String userBashProfileScript = ".bash_profile";
    private static final String userBashLoginScript = ".bash_login";
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private ProcessEnvironmentVariableManager currentProcessEnvVarManager;
    private static boolean envVarsCleanedUp;
    private boolean initialized = false;

    public String getName() {
        return SystemUtilService.NAME;
    }

    public int getSystemCompatibility() {
        int result = 0;
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            result = 5;
        }
        return result;
    }

    public String getOSServiceLevel() throws ServiceException {
        return this.commandLineInterface.getKernelVersion();
    }

    protected void initialized() {
        super.initialized();
        try {
            this.initialized = UnixShellInterface.initialize(this.getServiceResource("reslib/linuxppk/gushellsupport.sh"));
        }
        catch (IOException ex) {
            System.err.println("Error: Linux System Util Service Initialization Failed. Turn on the System property 'EnableLinuxPPKLogger' for more stack trace details");
            SimpleLinuxPPKLogger.log(ex);
        }
        catch (ServiceException se) {
            System.err.println("Error: Linux System Util Service Initialization Failed. Turn on the System property 'EnableLinuxPPKLogger' for more stack trace details");
            SimpleLinuxPPKLogger.log(se);
        }
    }

    public String getEnvironmentVariable(String variableName) throws ServiceException {
        if (this.initialized) {
            return UnixShellInterface.getNativeObject().invokeMethod("getEnvironmentVariable", new String[]{variableName});
        }
        return null;
    }

    public String getRawEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            return group.getVariable(variableName);
        }
        return null;
    }

    public void setEnvironmentVariable(String key, String value) throws ServiceException {
        this.setEnvironmentVariable(key, value, 2);
    }

    public void setEnvironmentVariable(String variableName, String variableValue, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.setVariable(variableName, variableValue);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.setVariable(variableName, variableValue);
    }

    public void deleteEnvironmentVariable(String key) throws ServiceException {
        this.deleteEnvironmentVariable(key, 2);
    }

    public void deleteEnvironmentVariable(String variableName, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.deleteVariable(variableName);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.deleteVariable(variableName);
    }

    public void appendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.appendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.appendVariable(variableName, variableValue, delimiter);
    }

    public void unAppendEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.unAppendVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unAppendVariable(variableName, variableValue, delimiter);
    }

    public void prependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.prependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.prependVariable(variableName, variableValue, delimiter);
    }

    public void unPrependEnvironmentVariable(String variableName, String variableValue, String delimiter, int level) throws ServiceException {
        this.verifyVariableName(variableName);
        EnvironmentVariableManagerGroup group = this.getEnvVarGroup(level);
        if (group != null) {
            group.unPrependVariable(variableName, variableValue, delimiter);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unPrependVariable(variableName, variableValue, delimiter);
    }

    private void verifyVariableName(String variableName) throws ServiceException {
        if (variableName == null || variableName.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "systemUtil.variableNameRequired"));
        }
    }

    public void cleanup() throws ServiceException {
        if (!envVarsCleanedUp) {
            if (userEnvVarGroup != null) {
                userEnvVarGroup.makeUpdatePersistent();
            }
            if (systemEnvVarGroup != null) {
                systemEnvVarGroup.makeUpdatePersistent();
            }
            envVarsCleanedUp = true;
        }
        UnixShellInterface.shutDown();
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int level) throws ServiceException {
        EnvironmentVariableManagerGroup group = null;
        ScriptEnvironmentVariableManager manager = null;
        if (this.currentProcessEnvVarManager == null) {
            this.currentProcessEnvVarManager = new ProcessEnvironmentVariableManager(this);
        }
        try {
            if (level == 1 && System.getProperty("user.name").equals("root")) {
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String scriptFile = systemBourneScript;
                    if (new File(scriptFile).exists()) {
                        manager = new BourneShellManager(scriptFile);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                    if (new File(scriptFile = systemCshScript).exists()) {
                        manager = new CShellManager(scriptFile);
                        manager.initialize();
                        systemEnvVarGroup.add(manager);
                    }
                }
                group = systemEnvVarGroup;
            } else if (level == 2) {
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    File scriptFile = new File(System.getProperty("user.home"), userBourneScript);
                    if (scriptFile.exists()) {
                        manager = new BourneShellManager(scriptFile.getAbsolutePath());
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                    if ((scriptFile = new File(System.getProperty("user.home"), userBashProfileScript)).exists()) {
                        manager = new BashShellManager(scriptFile.getAbsolutePath());
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                    if ((scriptFile = new File(System.getProperty("user.home"), userBashLoginScript)).exists()) {
                        manager = new BashShellManager(scriptFile.getAbsolutePath());
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                    if ((scriptFile = new File(System.getProperty("user.home"), userCshScript)).exists()) {
                        manager = new CShellManager(scriptFile.getAbsolutePath());
                        manager.initialize();
                        userEnvVarGroup.add(manager);
                    }
                }
                group = userEnvVarGroup;
            }
        }
        catch (IOException ex) {
            throw new ServiceException(ex);
        }
        return group;
    }

    static {
        envVarsCleanedUp = false;
    }
}

