/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux.utils;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.installshield.boot.CoreFileUtils;
import com.installshield.util.CommandResult;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.MemoryProcessOutputHandler;
import com.installshield.util.ProcessExec;
import com.installshield.util.ProcessExecException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

public class RPM {
    public String major = "";
    public String minor = "";
    public String update = "";
    public String arch = "";
    public String OS = "";
    public static String RPM_VERSION = "RPM_VERSION";
    public static String RPMSPEC = "rpmspec";
    public static String RPMSPEC4 = "rpmspec4";
    private static final String spaceSeparator = new String(new byte[]{32});

    public RPM(String major, String minor) {
        this.major = major;
        this.minor = minor;
    }

    public static String queryRPMDB(String packageName) {
        String queryOutput = "";
        try {
            String queryCommand = RPM.formatRPMqueryCommand(packageName);
            if (queryCommand != null) {
                queryOutput = RPM.RPMCommandLineInterface(queryCommand);
                GenericLinuxCommands.linuxPPKDebugPrint(queryOutput);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMQuerycommand. RPMDB can not be queried.");
            }
        }
        catch (Exception e) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while querying RPMDB. RPMDB can not be queried for the RPM Package " + packageName);
            e.printStackTrace();
        }
        return queryOutput;
    }

    public static void registerRPMPackage(String rpmPackage) {
        try {
            String installCommand = RPM.formatRPMinstallCommand(rpmPackage);
            if (installCommand != null) {
                String result = RPM.RPMCommandLineInterface(installCommand);
                GenericLinuxCommands.linuxPPKDebugPrint(result);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMInstallcommand. ISMP Components will not be entered in RPM DB.");
            }
        }
        catch (Exception e) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while installing RPM Package. ISMP Components is not entered in RPM DB.");
            e.printStackTrace();
        }
    }

    public static void createRPMPackage(String rpmSpecFile, String rpmPackage) {
        try {
            String buildCommand = RPM.formatRPMBuildCommand(rpmSpecFile, rpmPackage);
            if (buildCommand != null) {
                String result = RPM.RPMCommandLineInterface(buildCommand);
                GenericLinuxCommands.linuxPPKDebugPrint(result);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMBuildcommand. RPM package can not be created ");
            }
        }
        catch (Exception e) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while creating RPM Package. ISMP Components will not be registered in RPM DB.");
            e.printStackTrace();
        }
    }

    public static void removeRPMPackage(String rpmPackage) {
        try {
            String removeCommand = RPM.formatRPMRemoveCommand(rpmPackage);
            if (removeCommand != null) {
                String result = RPM.RPMCommandLineInterface(removeCommand);
                GenericLinuxCommands.linuxPPKDebugPrint(result);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating rpm remove command. RPM package can not be removed.");
            }
        }
        catch (Exception e) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while removing RPM Package. ISMP Components is not removed from RPM DB.");
            e.printStackTrace();
        }
    }

    public static boolean isHostRPMSupported() {
        boolean supported = false;
        try {
            String result = RPM.RPMCommandLineInterface("rpm --version");
            supported = result != null && result.length() > 0;
            GenericLinuxCommands.linuxPPKDebugPrint(result);
        }
        catch (Exception e) {
            GenericLinuxCommands.linuxPPKDebugPrint("Host RPM is not supported. ISMP Components will not be registered in RPM DB.");
            e.printStackTrace();
        }
        return supported;
    }

    private static String formatRPMBuildCommand(String specFile, String rpmPackageFile) throws IOException, Exception {
        String command = "rpm";
        CommandResult info = CommandUtils.executeCommand("sh", new String[]{"-c", "rpmbuild --version"});
        if (info.getExitCode() == 0) {
            command = "rpmbuild";
        }
        File specFilePath = new File(specFile);
        if (specFile != null && specFilePath.exists()) {
            File f = new File(rpmPackageFile);
            StringBuffer buffer = new StringBuffer();
            buffer.append(command).append(spaceSeparator);
            buffer.append("--define").append(spaceSeparator);
            buffer.append("'");
            buffer.append("_rpmdir").append(spaceSeparator);
            buffer.append(CoreFileUtils.getParent(f.getAbsolutePath()));
            buffer.append("'").append(spaceSeparator);
            buffer.append("--define").append(spaceSeparator);
            buffer.append("'");
            buffer.append("_rpmfilename").append(spaceSeparator);
            buffer.append(FileUtils.getName(f.getAbsolutePath()));
            buffer.append("'").append(spaceSeparator);
            buffer.append("-bb").append(spaceSeparator);
            specFile = specFilePath.getAbsolutePath();
            buffer.append(specFile);
            command = buffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmbuildCommand = " + command);
        return command;
    }

    private static String formatRPMinstallCommand(String rpmPackage) throws IOException {
        String command = null;
        File rpmPackagePath = new File(rpmPackage);
        if (rpmPackage != null && rpmPackagePath.exists()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rpm").append(spaceSeparator);
            buffer.append("-i").append(spaceSeparator);
            rpmPackage = rpmPackagePath.getAbsolutePath();
            buffer.append(rpmPackage);
            command = buffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpminstallCommand = " + command);
        return command;
    }

    private static String formatRPMqueryCommand(String packageName) {
        String command = null;
        if (packageName != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rpm").append(spaceSeparator);
            buffer.append("-q").append(spaceSeparator);
            buffer.append(packageName);
            command = buffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmqueryCommand = " + command);
        return command;
    }

    private static String formatRPMRemoveCommand(String packageName) {
        String command = null;
        if (packageName != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("rpm").append(spaceSeparator);
            buffer.append("-e").append(spaceSeparator);
            buffer.append(packageName);
            command = buffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmRemoveCommand = " + command);
        return command;
    }

    private static String RPMCommandLineInterface(String command) throws IOException, ProcessExecException {
        ProcessExec ps = new ProcessExec("sh", new String[]{"-c", command});
        ByteArrayOutputStream stdoutput = new ByteArrayOutputStream();
        ps.setProcessOutputHandler(new MemoryProcessOutputHandler(stdoutput, null));
        ps.executeProcess();
        stdoutput.close();
        return new String(stdoutput.toByteArray());
    }
}

