/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux.utils;

import com.ibm.wizard.platform.linux.utils.SimpleLinuxPPKLogger;
import com.installshield.boot.CoreFileUtils;
import com.installshield.wizard.platform.common.util.NativeObject;
import com.installshield.wizard.platform.common.util.NativeObjectImpl;
import com.installshield.wizard.service.ServiceException;
import java.io.IOException;
import java.net.URL;

public class UnixShellInterface {
    private static NativeObject nativeObject;
    private static boolean initialized;
    public static final String SHELL_SUPPORT_FILE = "reslib/linuxppk/gushellsupport.sh";

    private UnixShellInterface() {
    }

    public static boolean initialize(URL scriptLocation) throws IOException, ServiceException {
        if (nativeObject == null) {
            String script = CoreFileUtils.createTempFile(scriptLocation);
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "chmod 744 " + script});
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            nativeObject = new NativeObjectImpl(script);
            SimpleLinuxPPKLogger.log("shell script is initialized at location =" + script);
            initialized = true;
        }
        return initialized;
    }

    public static NativeObject getNativeObject() {
        return nativeObject;
    }

    public static void shutDown() {
        SimpleLinuxPPKLogger.log("native object is shutting down");
        nativeObject.destroy();
    }

    static {
        initialized = false;
    }
}

