/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import com.installshield.beans.BeanInfoAggregate;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.net.URL;
import java.util.Hashtable;

public class ISIntrospector {
    private static String[] paths = new String[0];
    private static Hashtable cache = new Hashtable();
    private static ClassLoader classLoader = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$installshield$util$TreeNode;
    static /* synthetic */ Class class$java$beans$BeanInfo;

    public static void setClassLoader(ClassLoader classLoader) {
        ISIntrospector.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setBeanInfoSearchPath(String[] path) {
        paths = path;
    }

    public static String[] getBeanInfoSearchPath() {
        return paths;
    }

    public static void addBeanInfoSearchPath(String path) {
        if (paths == null) {
            paths = new String[0];
        }
        String[] newPaths = new String[paths.length + 1];
        System.arraycopy(paths, 0, newPaths, 0, paths.length);
        newPaths[ISIntrospector.paths.length] = path;
        ISIntrospector.setBeanInfoSearchPath(newPaths);
    }

    public static BeanInfo getBeanInfo(Class beanClass) throws IntrospectionException {
        return ISIntrospector.getBeanInfo(beanClass, null);
    }

    public static BeanInfo getBeanInfo(Class beanClass, Class stopClass) throws IntrospectionException {
        BeanInfo beanInfo = (BeanInfo)cache.get(beanClass);
        if (beanInfo == null) {
            beanInfo = ISIntrospector.getBeanInfoImpl(beanClass);
            cache.put(beanClass, beanInfo);
        }
        if (beanInfo == null || beanClass.getSuperclass() == null || beanClass.getSuperclass().equals(stopClass)) {
            return beanInfo;
        }
        BeanInfo parentInfo = ISIntrospector.getBeanInfo(beanClass.getSuperclass(), stopClass);
        if (parentInfo != null) {
            beanInfo = new BeanInfoAggregate(beanInfo, parentInfo);
        }
        return beanInfo;
    }

    private static BeanInfo getBeanInfoImpl(Class beanClass) throws IntrospectionException {
        for (int i = 0; i < paths.length; ++i) {
            try {
                int pos = beanClass.getName().lastIndexOf(46);
                String className = beanClass.getName().substring(pos + 1);
                String packagePrefix = paths[i].length() > 0 ? paths[i] + "." : paths[i];
                BeanInfo info = (BeanInfo)ISIntrospector.loadClass(packagePrefix + className + "BeanInfo").newInstance();
                if (info != null && info.getBeanDescriptor() != null) {
                    Class<?> infoClass = info.getBeanDescriptor().getBeanClass();
                    if (!infoClass.isAssignableFrom(beanClass)) continue;
                    return info;
                }
                return info;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        BeanInfo bi = ISIntrospector.findInformant(beanClass);
        if (bi == null) {
            bi = Introspector.getBeanInfo(beanClass, beanClass.getSuperclass());
        }
        return bi;
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return classLoader != null ? classLoader.loadClass(name) : Class.forName(name);
    }

    public static Image getIcon(Class c, int type) {
        Image img = null;
        try {
            BeanInfo bi = ISIntrospector.getBeanInfo(c);
            if (bi != null) {
                img = bi.getIcon(type);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (img == null) {
            URL url = ISIntrospector.getIconResource(c, type);
            if (url == null) {
                url = ISIntrospector.getDefaultIconResource(c, type);
            }
            if (url != null) {
                try {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    img = tk.createImage((ImageProducer)url.getContent());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return img;
    }

    public static URL getDefaultIconResource(Class c, int type) {
        URL url = null;
        Class superC = c;
        while (url == null && !superC.equals(class$java$lang$Object == null ? ISIntrospector.class$("java.lang.Object") : class$java$lang$Object)) {
            url = ISIntrospector.getIconResource(superC, type);
            superC = superC.getSuperclass();
        }
        if (url == null) {
            url = ISIntrospector.getIconResource(class$com$installshield$util$TreeNode == null ? (class$com$installshield$util$TreeNode = ISIntrospector.class$("com.installshield.util.TreeNode")) : class$com$installshield$util$TreeNode, type);
        }
        return url;
    }

    public static URL getIconResource(Class c, int type) {
        URL url = c.getResource(ISIntrospector.createIconResourceName(c, type, "gif"));
        if (url == null) {
            url = c.getResource(ISIntrospector.createIconResourceName(c, type, "jpg"));
        }
        return url;
    }

    private static String createIconResourceName(Class c, int iconType, String extension) {
        String name = c.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        String size = iconType == 1 || iconType == 3 ? "16" : (iconType == 2 || iconType == 4 ? "32" : "");
        return Introspector.decapitalize(name) + size + "." + extension;
    }

    public static BeanInfo findInformant(Class beanClass) {
        String name = beanClass.getName() + "BeanInfo";
        try {
            return (BeanInfo)ISIntrospector.instantiate(beanClass, name);
        }
        catch (Exception ex) {
            try {
                if (ISIntrospector.isSubclass(beanClass, class$java$beans$BeanInfo == null ? (class$java$beans$BeanInfo = ISIntrospector.class$("java.beans.BeanInfo")) : class$java$beans$BeanInfo)) {
                    return (BeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            while (name.indexOf(46) > 0) {
                name = name.substring(name.indexOf(46) + 1);
            }
            String[] searchPath = Introspector.getBeanInfoSearchPath();
            for (int i = 0; i < searchPath.length; ++i) {
                try {
                    String fullName = searchPath[i] + "." + name;
                    return (BeanInfo)ISIntrospector.instantiate(beanClass, fullName);
                }
                catch (Exception ex3) {
                    continue;
                }
            }
            return null;
        }
    }

    private static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class x = a; x != null; x = x.getSuperclass()) {
            if (x == b) {
                return true;
            }
            if (!b.isInterface()) continue;
            Class<?>[] interfaces = x.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!ISIntrospector.isSubclass(interfaces[i], b)) continue;
                return true;
            }
        }
        return false;
    }

    private static Object instantiate(Class sibling, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Class<?> cls = Class.forName(className);
        return cls.newInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

