/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans;

import com.installshield.beans.ISIntrospector;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class ObjectArrayDictionary
extends Dictionary {
    private Class objectType;
    private PropertyDescriptor keyProperty;
    private Object[] objects;

    public ObjectArrayDictionary(Class objectType, String keyProperty) throws IntrospectionException, IllegalArgumentException {
        this.objectType = objectType;
        BeanInfo bi = ISIntrospector.getBeanInfo(objectType);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        this.keyProperty = null;
        for (int i = 0; this.keyProperty == null && i < pds.length; ++i) {
            Method read;
            if (!pds[i].getName().equals(keyProperty) || (read = pds[i].getReadMethod()) == null) continue;
            if (read.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("keyProperty " + keyProperty + " is indexed");
            }
            Method write = pds[i].getWriteMethod();
            if (write != null && write.getParameterTypes().length != 1) {
                throw new IllegalArgumentException("keyProperty " + keyProperty + " has invalid write method");
            }
            this.keyProperty = pds[i];
        }
        if (this.keyProperty == null) {
            throw new IllegalArgumentException(keyProperty + " is not a readable property of " + objectType);
        }
        try {
            this.objects = (Object[])Array.newInstance(objectType, 0);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot create instance of " + objectType + "[]");
        }
    }

    public void setObjects(Object[] objects) {
        this.objects = objects;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (this.objects == null) {
            return null;
        }
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            for (int i = 0; i < this.objects.length; ++i) {
                try {
                    Object curKey = this.keyProperty.getReadMethod().invoke(this.objects[i], new Object[0]);
                    if (!curKey.equals(key)) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.objects[i];
                }
                catch (Exception e) {
                    if (System.getProperty("is.debug") == null) continue;
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        if (this.objects == null) {
            return null;
        }
        if (!this.objectType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("value must be a " + this.objectType);
        }
        if (this.keyProperty.getWriteMethod() == null) {
            try {
                Object valueKey = this.keyProperty.getReadMethod().invoke(value, new Object[0]);
                if (!valueKey.equals(key)) {
                    throw new IllegalArgumentException("key must equal value's " + this.keyProperty.getName() + " property");
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("cannot confirm valid key: " + e);
            }
        }
        Object removed = this.remove(key);
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            Object[] newObjects;
            block12: {
                newObjects = (Object[])Array.newInstance(this.objectType, this.objects.length + 1);
                System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
                newObjects[this.objects.length] = value;
                if (this.keyProperty.getWriteMethod() != null) {
                    try {
                        this.keyProperty.getWriteMethod().invoke(value, key);
                    }
                    catch (Exception e) {
                        if (System.getProperty("is.debug") == null) break block12;
                        e.printStackTrace();
                    }
                }
            }
            this.objects = newObjects;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        if (this.objects == null) {
            return new Vector().elements();
        }
        Vector<Object> v = new Vector<Object>();
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            for (int i = 0; i < this.objects.length; ++i) {
                v.addElement(this.objects[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return v.elements();
        }
    }

    public int size() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration keys() {
        if (this.objects == null) {
            return new Vector().elements();
        }
        Vector<Object> v = new Vector<Object>();
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            for (int i = 0; i < this.objects.length; ++i) {
                try {
                    v.addElement(this.keyProperty.getReadMethod().invoke(this.objects[i], (Object[])new String[0]));
                    continue;
                }
                catch (Exception e) {
                    if (System.getProperty("is.debug") == null) continue;
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return v.elements();
        }
    }

    public boolean isEmpty() {
        if (this.objects == null) {
            return true;
        }
        return this.objects.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        if (this.objects == null) {
            return null;
        }
        Object removed = null;
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            for (int i = 0; removed == null && i < this.objects.length; ++i) {
                try {
                    Object curKey = this.keyProperty.getReadMethod().invoke(this.objects[i], new Object[0]);
                    if (!curKey.equals(key)) continue;
                    Object[] newObjects = (Object[])Array.newInstance(this.objectType, this.objects.length - 1);
                    removed = this.objects[i];
                    System.arraycopy(this.objects, 0, newObjects, 0, i);
                    System.arraycopy(this.objects, i + 1, newObjects, i, this.objects.length - i - 1);
                    this.objects = newObjects;
                    continue;
                }
                catch (Exception e) {
                    if (System.getProperty("is.debug") == null) continue;
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return removed;
        }
    }
}

