/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public class CoreFileUtils {
    private static final boolean isFileSystemCaseSensitive;
    public static final String systemLF;
    private static Vector tempFiles;
    private static final String isjeDirName = "ismp";
    private static int count;
    private static String curTempDirectory;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("use: CoreFileUtils [options]");
            System.err.println("\noptions:\n");
            System.err.println("   -temp : prints the temporary directory for the current JVM");
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-temp")) {
                    System.out.println(CoreFileUtils.getTempDir());
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.exit(-1);
            }
        }
    }

    public static String createTempDir() throws IOException {
        File f;
        String tempDir = CoreFileUtils.getIsjeTempDir();
        while ((f = new File(tempDir, CoreFileUtils.createTempDirName())).exists()) {
        }
        String[] createdDirs = CoreFileUtils.createDirs(f);
        for (int i = 0; i < createdDirs.length; ++i) {
            if (CoreFileUtils.getTempFiles().contains(createdDirs[i])) continue;
            CoreFileUtils.getTempFiles().addElement(createdDirs[i]);
        }
        String fileName = f.getAbsolutePath();
        return fileName;
    }

    public static String createTempDirName() {
        return new Integer((int)(Math.random() * 1.0E7)).toString();
    }

    public static String createTempFile() throws IOException {
        File f;
        String tempDir = CoreFileUtils.getIsjeTempDir();
        while ((f = new File(tempDir, CoreFileUtils.createTempFileName())).exists()) {
        }
        FileOutputStream out = new FileOutputStream(f);
        out.close();
        String fileName = f.getAbsolutePath();
        tempFiles.addElement(fileName);
        return fileName;
    }

    public static String createTempFile(URL source) throws IOException {
        String tempFileName = CoreFileUtils.createTempFile();
        InputStream in = source.openStream();
        FileOutputStream out = new FileOutputStream(tempFileName);
        try {
            CoreFileUtils.copy(in, out);
            in.close();
            in = null;
            out.close();
            return tempFileName;
        }
        catch (IOException ioe) {
            CoreFileUtils.close(in);
            CoreFileUtils.close(out);
            CoreFileUtils.deleteTempFile(tempFileName);
            throw ioe;
        }
    }

    public static String createTempFile(URL source, String fileName) throws IOException {
        String fullPath = CoreFileUtils.createFileName(CoreFileUtils.getIsjeTempDir(), fileName);
        File f = new File(fullPath);
        if (f.exists()) {
            while ((f = new File(CoreFileUtils.getIsjeTempDir(), CoreFileUtils.createTempFileName())).exists()) {
            }
            if (!f.mkdirs()) {
                throw new IOException("could not create temp directory " + f.getAbsolutePath());
            }
            CoreFileUtils.getTempFiles().addElement(f.getAbsolutePath());
            f = new File(f, fileName);
        }
        CoreFileUtils.getTempFiles().addElement(f.getAbsolutePath());
        InputStream in = source.openStream();
        FileOutputStream out = new FileOutputStream(f);
        try {
            CoreFileUtils.copy(in, out);
            in.close();
            in = null;
            out.close();
            return f.getAbsolutePath();
        }
        catch (IOException ioe) {
            CoreFileUtils.close(in);
            CoreFileUtils.close(out);
            CoreFileUtils.deleteTempFile(f.getAbsolutePath());
            throw ioe;
        }
    }

    public static boolean deleteTempFile(String fileName) {
        boolean deleted = new File(fileName).delete();
        if (deleted) {
            CoreFileUtils.getTempFiles().removeElement(fileName);
        }
        return deleted;
    }

    public static void clearTempFiles() {
        CoreFileUtils.getTempFiles().removeAllElements();
    }

    public static void addTempFile(String fileName) {
        if (!CoreFileUtils.getTempFiles().contains(fileName)) {
            CoreFileUtils.getTempFiles().addElement(fileName);
        }
    }

    public static void clearTempFile(String fileName) {
        CoreFileUtils.getTempFiles().removeElement(fileName);
    }

    protected static Vector getTempFiles() {
        return tempFiles;
    }

    public static String getTempDir() {
        String temp = System.getProperty("temp.dir");
        if (temp == null) {
            temp = System.getProperty("java.io.tmpdir");
        }
        if (temp == null) {
            temp = System.getProperty("user.home");
        }
        return temp;
    }

    protected static String getIsjeTempDir() {
        if (curTempDirectory == null) {
            CoreFileUtils.createIsjeTempDir();
        }
        return curTempDirectory;
    }

    private static void createIsjeTempDir() {
        boolean done = false;
        while (!done) {
            String dir = CoreFileUtils.getIsjeTempDirName();
            File f = new File(dir);
            if (!f.exists()) {
                f.mkdir();
                curTempDirectory = f.getAbsolutePath();
                if (!tempFiles.contains(curTempDirectory)) {
                    tempFiles.addElement(curTempDirectory);
                }
                done = true;
                continue;
            }
            ++count;
        }
    }

    protected static void resetCurrentTempDir() {
        curTempDirectory = null;
    }

    private static String getIsjeTempDirName() {
        String subStr = "";
        subStr = count < 10 ? "00" + count : (count >= 10 && count < 100 ? "0" + count : "" + count);
        return CoreFileUtils.appendSeparator(CoreFileUtils.getTempDir()) + isjeDirName + subStr;
    }

    public static String createTempFileName() {
        return (int)(Math.random() * 1.0E7) + ".tmp";
    }

    public static String[] createDirs(File target) throws IOException {
        Stack<File> parents = new Stack<File>();
        File parent = target;
        while (parent != null && !parent.exists()) {
            parents.push(parent);
            String parentName = parent.getParent();
            parent = parentName != null ? new File(parentName) : null;
        }
        Vector<String> created = new Vector<String>();
        while (!parents.isEmpty()) {
            parent = (File)parents.pop();
            if (parent.exists()) continue;
            if (!parent.mkdir()) {
                throw new IOException("Could not create directory " + parent.getAbsolutePath());
            }
            created.addElement(parent.getAbsolutePath());
        }
        Object[] ret = new String[created.size()];
        created.copyInto(ret);
        return ret;
    }

    public static String createFileName(String context, String fileName) {
        if (context == null) {
            context = "";
        }
        context = context.trim();
        if (fileName == null) {
            return CoreFileUtils.normalizeFileName(context);
        }
        fileName = fileName.trim();
        if (CoreFileUtils.isAbsolute(fileName = CoreFileUtils.normalizeFileName(fileName))) {
            return fileName;
        }
        if ((context = CoreFileUtils.normalizeFileName(context)).endsWith(File.separator)) {
            return context + fileName;
        }
        return context + File.separator + fileName;
    }

    public static String getParent(String fileName) {
        String normalizedFileName = CoreFileUtils.normalizeFileName(fileName);
        int len = normalizedFileName.length();
        if (normalizedFileName.endsWith(File.separator) && len > 1) {
            normalizedFileName = normalizedFileName.substring(0, len - 1);
        }
        return new File(normalizedFileName).getParent();
    }

    public static boolean isAbsolute(String fileName) {
        fileName = CoreFileUtils.normalizeFileName(fileName);
        File f = new File(fileName);
        return fileName.startsWith(File.separator) || f.isAbsolute();
    }

    public static String normalizeFileName(String fileName, char normalSeparator) {
        if (fileName == null) {
            throw new NullPointerException("fileName cannot be null");
        }
        return fileName.replace('/', normalSeparator).replace('\\', normalSeparator);
    }

    public static String normalizeFileName(String fileName) {
        return CoreFileUtils.normalizeFileName(fileName, File.separatorChar);
    }

    public static String appendSeparator(String path) {
        return CoreFileUtils.appendSeparator(path, File.separator);
    }

    public static String appendSeparator(String path, String separator) {
        if (path.length() > 0 && !path.endsWith("/") && !path.endsWith(File.separator)) {
            return path + separator;
        }
        return path;
    }

    public static String canonizePath(String path) {
        String formattedPath = CoreFileUtils.normalizeFileName(path);
        String doubleSeparator = File.separator + File.separator;
        int pos = formattedPath.lastIndexOf(doubleSeparator);
        while (pos != -1 && pos != 0) {
            formattedPath = formattedPath.substring(0, pos + 1) + formattedPath.substring(pos + 2);
            pos = formattedPath.lastIndexOf(doubleSeparator);
        }
        boolean checkPath = true;
        while (checkPath) {
            checkPath = false;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < formattedPath.length(); ++i) {
                if (formattedPath.charAt(i) != File.separatorChar) {
                    buf.append(formattedPath.charAt(i));
                    continue;
                }
                if (formattedPath.length() != i + 1 && formattedPath.charAt(i + 1) == '.') {
                    if (formattedPath.length() == i + 2 || formattedPath.charAt(i + 2) == File.separatorChar) {
                        ++i;
                        continue;
                    }
                    if (formattedPath.charAt(i + 2) == '.' && (formattedPath.length() == i + 3 || formattedPath.charAt(i + 3) == File.separatorChar)) {
                        String partialPath = buf.toString();
                        String parentPath = CoreFileUtils.getParent(partialPath);
                        if (parentPath == null) {
                            parentPath = partialPath;
                        }
                        if (parentPath.endsWith(File.separator)) {
                            parentPath = parentPath.substring(0, parentPath.length() - 1);
                        }
                        buf = new StringBuffer(parentPath);
                        i += 2;
                        checkPath = true;
                        continue;
                    }
                    buf.append(formattedPath.charAt(i));
                    continue;
                }
                buf.append(formattedPath.charAt(i));
            }
            formattedPath = buf.toString();
        }
        if (formattedPath.endsWith(File.separator)) {
            formattedPath = formattedPath.substring(0, formattedPath.length() - 1);
        }
        return formattedPath;
    }

    public static boolean comparePaths(String path1, String path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        String reformattedPath1 = CoreFileUtils.canonizePath(path1);
        String reformattedPath2 = CoreFileUtils.canonizePath(path2);
        if (!isFileSystemCaseSensitive) {
            return reformattedPath1.equalsIgnoreCase(reformattedPath2);
        }
        return reformattedPath1.equals(reformattedPath2);
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        return CoreFileUtils.copy(16384, in, out);
    }

    public static int copy(int bufferSize, InputStream in, OutputStream out, int length) throws IOException {
        return (int)CoreFileUtils.copy(bufferSize, in, out, (long)length);
    }

    public static long copy(int bufferSize, InputStream in, OutputStream out, long length) throws IOException {
        long totalRead = 0L;
        int read = 0;
        if (length > 0L) {
            if ((long)bufferSize > length) {
                bufferSize = (int)length;
            }
            byte[] buf = new byte[bufferSize];
            boolean finished = false;
            while (!finished && (read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
                long sizeRemaining = length - (totalRead += (long)read);
                if (sizeRemaining <= 0L) {
                    finished = true;
                    continue;
                }
                if (sizeRemaining >= (long)bufferSize) continue;
                bufferSize = (int)sizeRemaining;
                buf = new byte[bufferSize];
            }
        }
        return totalRead;
    }

    public static int copy(int bufferSize, InputStream in, OutputStream out) throws IOException {
        long totalRead = 0L;
        int read = 0;
        byte[] buf = new byte[bufferSize];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            totalRead += (long)read;
        }
        return (int)totalRead;
    }

    public static void close(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isFileSystemCaseSensitive() {
        return isFileSystemCaseSensitive;
    }

    static {
        tempFiles = new Vector();
        count = 1;
        curTempDirectory = null;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows") || osname.equals("OS/2")) {
            systemLF = "\r\n";
            isFileSystemCaseSensitive = false;
        } else if (osname.equals("OS/400")) {
            systemLF = "\n";
            isFileSystemCaseSensitive = false;
        } else {
            systemLF = "\n";
            isFileSystemCaseSensitive = true;
        }
    }
}

