/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

public class CoreURLUtils {
    public static final String ARCHIVE_URL_PROTOCOL = "archive";
    public static final String COMPRESSED_URL_PROTOCOL = "compressed";
    public static final String ISMPFILE_URL_PROTOCOL = "ismpfile";
    private static final char ESCAPE_CHAR = '%';
    private static final String POUND_REPLACE_STR = "23";
    private static final String QUESTION_REPLACE_STR = "3F";
    private static final String PERCENT_REPLACE_STR = "25";
    private static final String SPACE_REPLACE_STR = "20";
    private static final char POUND_CHAR = '#';
    private static final char QUESTION_CHAR = '?';
    private static final char PERCENT_CHAR = '%';
    private static final char SPACE_CHAR = ' ';

    public static String encode(String originalString) {
        StringBuffer encodedStringBuf = new StringBuffer();
        block6: for (int i = 0; i < originalString.length(); ++i) {
            switch (originalString.charAt(i)) {
                case '#': {
                    encodedStringBuf.append("%23");
                    continue block6;
                }
                case '%': {
                    encodedStringBuf.append("%25");
                    continue block6;
                }
                case '?': {
                    encodedStringBuf.append("%3F");
                    continue block6;
                }
                case ' ': {
                    encodedStringBuf.append("%20");
                    continue block6;
                }
                default: {
                    encodedStringBuf.append(originalString.charAt(i));
                }
            }
        }
        return encodedStringBuf.toString();
    }

    public static String decode(String originalString) {
        StringBuffer decodedStringBuf = new StringBuffer();
        for (int i = 0; i < originalString.length(); ++i) {
            if (originalString.charAt(i) == '%' && originalString.length() >= i + 3) {
                String charKey = originalString.substring(i + 1, i + 3);
                boolean replaced = false;
                if (charKey.equalsIgnoreCase(POUND_REPLACE_STR)) {
                    decodedStringBuf.append('#');
                    replaced = true;
                } else if (charKey.equalsIgnoreCase(PERCENT_REPLACE_STR)) {
                    decodedStringBuf.append('%');
                    replaced = true;
                } else if (charKey.equalsIgnoreCase(QUESTION_REPLACE_STR)) {
                    decodedStringBuf.append('?');
                    replaced = true;
                } else if (charKey.equalsIgnoreCase(SPACE_REPLACE_STR)) {
                    decodedStringBuf.append(' ');
                    replaced = true;
                } else {
                    decodedStringBuf.append(originalString.charAt(i));
                }
                if (!replaced) continue;
                i += 2;
                continue;
            }
            decodedStringBuf.append(originalString.charAt(i));
        }
        return decodedStringBuf.toString();
    }

    public static String encodeArchiveURLPath(String archiveURLPath) {
        String internalRef;
        String context;
        boolean useRef = false;
        int index = archiveURLPath.indexOf(43);
        if (index >= 0) {
            context = archiveURLPath.substring(0, index);
            internalRef = archiveURLPath.substring(index + 1);
            useRef = true;
        } else {
            context = archiveURLPath;
            internalRef = "";
        }
        String encodedPath = CoreURLUtils.encode(context);
        if (useRef) {
            encodedPath = encodedPath + "+" + CoreURLUtils.encode(internalRef);
        }
        return encodedPath;
    }

    public static String decodeArchiveURLPath(String archiveURLPath) {
        String internalRef;
        String context;
        boolean useRef = false;
        int index = archiveURLPath.indexOf(43);
        if (index >= 0) {
            context = archiveURLPath.substring(0, index);
            internalRef = archiveURLPath.substring(index + 1);
            useRef = true;
        } else {
            context = archiveURLPath;
            internalRef = "";
        }
        String decodedPath = CoreURLUtils.decode(context);
        if (useRef) {
            decodedPath = decodedPath + "+" + CoreURLUtils.decode(internalRef);
        }
        return decodedPath;
    }
}

