/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.ZipInputStreamWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CoreZipUtils {
    public static InputStream createZipInputStream(InputStream in) {
        return new ZipInputStreamWrapper(in);
    }

    public static void closeZipStream(ZipOutputStream zipOut) throws IOException {
        block2: {
            try {
                zipOut.finish();
                zipOut.close();
            }
            catch (ZipException e) {
                if (e.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                throw e;
            }
        }
    }

    public static String removeProtocols(String path) {
        String cleanPath = path;
        boolean isClean = false;
        while (!isClean) {
            if (cleanPath.startsWith("file:")) {
                cleanPath = cleanPath.substring(5);
                continue;
            }
            isClean = true;
        }
        return cleanPath;
    }

    public static String cleanZipEntry(String entry) {
        entry = entry.replace(File.separatorChar, '/');
        char[] s = new char[entry.length()];
        int nexts = 0;
        for (int i = 0; i < s.length; ++i) {
            char cur = entry.charAt(i);
            if (i > 0 || cur != '/') {
                s[nexts++] = cur;
            }
            while (i < s.length - 1 && cur == '/' && entry.charAt(i + 1) == '/') {
                ++i;
            }
        }
        return new String(s, 0, nexts);
    }

    public static boolean isZipEmpty(String fileName) {
        boolean isEmpty = true;
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(fileName);
            ZipInputStream zipIn = new ZipInputStream(fileIn);
            if (zipIn.getNextEntry() != null) {
                isEmpty = false;
            }
            zipIn.close();
        }
        catch (IOException ioErr) {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ioFileErr) {
                // empty catch block
            }
            isEmpty = true;
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUncompressedSize(String fileName) {
        long expandedSize = 0L;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                expandedSize += enumeration.nextElement().getSize();
            }
        }
        catch (IOException ioErr) {
            expandedSize = 0L;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception genErr) {}
        }
        return expandedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompress(String unpackLocation, URL zipURL) throws IOException {
        boolean isEmpty = true;
        InputStream resourceIn = zipURL.openStream();
        ZipInputStream zipIn = null;
        ZipEntry ze = null;
        try {
            zipIn = new ZipInputStream(resourceIn);
            ze = zipIn.getNextEntry();
            if (ze != null) {
                isEmpty = false;
            } else {
                try {
                    zipIn.close();
                }
                catch (IOException ioErr) {}
            }
        }
        catch (IOException ioErr) {
            try {
                resourceIn.close();
            }
            catch (IOException ioFileErr) {
                // empty catch block
            }
            isEmpty = true;
        }
        if (!isEmpty) {
            try {
                while (ze != null) {
                    String entryName = ze.getName();
                    entryName = entryName.replace('/', File.separatorChar);
                    entryName = entryName.replace('\\', File.separatorChar);
                    String fileName = CoreFileUtils.createFileName(unpackLocation, entryName);
                    File file = new File(fileName);
                    if (ze.isDirectory()) {
                        CoreFileUtils.createDirs(file);
                    } else {
                        String parentDir = CoreFileUtils.getParent(fileName);
                        if (parentDir != null) {
                            CoreFileUtils.createDirs(new File(parentDir));
                        }
                        FileOutputStream fileOut = null;
                        try {
                            fileOut = new FileOutputStream(fileName);
                            InputStream entryIn = CoreZipUtils.createZipInputStream(zipIn);
                            CoreFileUtils.copy(entryIn, fileOut);
                        }
                        finally {
                            try {
                                if (fileOut != null) {
                                    fileOut.close();
                                }
                            }
                            catch (Exception genErr) {}
                        }
                    }
                    zipIn.closeEntry();
                    ze = zipIn.getNextEntry();
                }
            }
            finally {
                try {
                    if (zipIn != null) {
                        zipIn.close();
                    }
                }
                catch (Exception genErr) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressDirectory(String zipFileName, String dirName) throws IOException {
        File zipFile = new File(zipFileName);
        File dir = new File(dirName);
        if (zipFile.exists()) {
            throw new IOException("destination file (" + zipFileName + ") exists");
        }
        if (!dir.exists()) {
            throw new IOException("compress directory (" + dirName + ") does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IOException("compress directory (" + dirName + ") is not a directory");
        }
        String parentDir = CoreFileUtils.getParent(zipFileName);
        if (parentDir != null) {
            CoreFileUtils.createDirs(new File(parentDir));
        }
        FileOutputStream fileOut = null;
        ZipOutputStream zipOut = null;
        try {
            fileOut = new FileOutputStream(zipFileName);
            zipOut = new ZipOutputStream(fileOut);
            CoreZipUtils.compressDirectoryContents(zipOut, "", dirName);
            ((FilterOutputStream)zipOut).flush();
            zipOut.finish();
            zipOut.close();
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.close();
                }
                catch (Exception genErr) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (Exception genErr) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressDirectoryContents(ZipOutputStream zipOut, String relDirName, String baseDirName) throws IOException {
        File dir = new File(CoreFileUtils.createFileName(baseDirName, relDirName));
        String[] contents = dir.list();
        for (int i = 0; contents != null && i < contents.length; ++i) {
            String relResName = relDirName.equals("") ? contents[i] : relDirName + "/" + contents[i];
            String fullResName = CoreFileUtils.createFileName(baseDirName, relResName);
            File resFile = new File(fullResName);
            if (resFile.isFile()) {
                String entryName = CoreZipUtils.cleanZipEntry(relResName);
                ZipEntry entry = new ZipEntry(entryName);
                zipOut.putNextEntry(entry);
                FileInputStream fileIn = null;
                try {
                    fileIn = new FileInputStream(fullResName);
                    CoreFileUtils.copy(fileIn, zipOut);
                    zipOut.closeEntry();
                    continue;
                }
                finally {
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException ioErr) {}
                    }
                }
            }
            CoreZipUtils.compressDirectoryContents(zipOut, relResName, baseDirName);
        }
    }
}

