/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class ZipInputStreamWrapper
extends InputStream {
    private InputStream in;

    ZipInputStreamWrapper(InputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        try {
            return this.in.read();
        }
        catch (EOFException e) {
            if (this.in.available() > 0) {
                throw e;
            }
            return -1;
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.in.read(b);
        }
        catch (EOFException e) {
            if (this.in.available() > 0) {
                throw e;
            }
            return -1;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.in.read(b, off, len);
        }
        catch (EOFException e) {
            if (this.in.available() > 0) {
                throw e;
            }
            return -1;
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

