/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import com.installshield.boot.CoreFileUtils;
import com.installshield.boot.CoreURLUtils;
import com.installshield.boot.streamhandler.FileURLConnection;
import com.installshield.boot.streamhandler.ZipURLConnection;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Hashtable;

public class ArchiveURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "archive";
    private static Hashtable openConnections = new Hashtable();

    protected URLConnection openConnection(URL u) throws IOException {
        String file = CoreURLUtils.decodeArchiveURLPath(u.getFile());
        int plus = file.lastIndexOf(43);
        String context = plus != -1 ? file.substring(0, plus) : "";
        context = CoreFileUtils.canonizePath(context);
        String fileName = plus != -1 ? file.substring(plus + 1) : file;
        Hashtable<URL, URLConnection> contextConnections = (Hashtable<URL, URLConnection>)openConnections.get(context);
        if (contextConnections == null) {
            contextConnections = new Hashtable<URL, URLConnection>();
            openConnections.put(context, contextConnections);
        }
        if (contextConnections.containsKey(u)) {
            return (URLConnection)contextConnections.get(u);
        }
        File f = new File(context);
        if (f.isFile()) {
            ZipURLConnection zipConnection = new ZipURLConnection(u, context, fileName);
            contextConnections.put(u, zipConnection);
            return zipConnection;
        }
        if (f.isDirectory()) {
            FileURLConnection fileConnection = new FileURLConnection(u, new File(context, fileName));
            contextConnections.put(u, fileConnection);
            return fileConnection;
        }
        throw new IOException("archive context " + f + " does not exist");
    }

    public static void closeArchive(String archiveName) throws IOException {
        Enumeration archiveEnum = openConnections.keys();
        while (archiveEnum.hasMoreElements()) {
            String openArchiveName = (String)archiveEnum.nextElement();
            if (!CoreFileUtils.comparePaths(archiveName, openArchiveName)) continue;
            Hashtable archiveConnections = (Hashtable)openConnections.get(openArchiveName);
            Enumeration enumeration = archiveConnections.keys();
            while (enumeration.hasMoreElements()) {
                URLConnection connection = (URLConnection)archiveConnections.get(enumeration.nextElement());
                if (!(connection instanceof ZipURLConnection)) continue;
                ZipURLConnection zipConnection = (ZipURLConnection)connection;
                zipConnection.closeFile();
            }
        }
    }

    public static void closeAllArchives() {
        Enumeration enumeration = openConnections.keys();
        while (enumeration.hasMoreElements()) {
            String archive = (String)enumeration.nextElement();
            try {
                ArchiveURLStreamHandler.closeArchive(archive);
            }
            catch (IOException iOException) {}
        }
    }
}

