/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import com.installshield.boot.streamhandler.ISInflaterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

class CompressedURLConnection
extends URLConnection {
    private URL internalURL = null;
    private InputStream in = null;
    private static String ARCHIVE_PROTOCOL = "archive:";
    private static String ISMP_FILE_PROTOCOL = "ismpfile:";

    CompressedURLConnection(URL url) throws MalformedURLException {
        super(url);
        String urlFileName = url.getFile();
        try {
            URL tempURL;
            int startIndex;
            String urlProtocol;
            if (urlFileName.startsWith(ARCHIVE_PROTOCOL)) {
                urlProtocol = "archive";
                startIndex = "archive".length() + 1;
            } else if (urlFileName.startsWith(ISMP_FILE_PROTOCOL)) {
                urlProtocol = "ismpfile";
                startIndex = "ismpfile".length() + 1;
            } else {
                urlProtocol = "file";
                startIndex = 0;
            }
            this.internalURL = tempURL = new URL(urlProtocol, "", -1, urlFileName.substring(startIndex));
        }
        catch (MalformedURLException urlErr) {
            throw new MalformedURLException("Invalid internal URL designation: " + urlFileName);
        }
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new ISInflaterInputStream(this.internalURL.openStream());
        }
        return this.in;
    }

    public void finalize() throws Throwable {
        this.internalURL = null;
        this.in = null;
        super.finalize();
    }
}

