/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

class ISInflaterInputStream
extends FilterInputStream {
    private static int DEFAULT_BUF_SIZE = 512;
    private Inflater inf;
    private byte[] buf;
    private int bufLength;
    private boolean closed = false;
    private boolean eofReached = false;

    public ISInflaterInputStream(InputStream in) {
        super(in);
        if (in == null) {
            throw new NullPointerException();
        }
        this.inf = new Inflater();
        this.buf = new byte[DEFAULT_BUF_SIZE];
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
    }

    private void setEOFReached(boolean eofReached) {
        this.eofReached = eofReached;
    }

    private boolean isEOF() {
        return this.eofReached;
    }

    public int read() throws IOException {
        this.ensureOpen();
        byte[] b = new byte[1];
        return this.read(b, 0, 1) == -1 ? -1 : b[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            int sizeInflated = -1;
            while (!this.isEOF() && (sizeInflated = this.inf.inflate(b, off, len)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    this.setEOFReached(true);
                    sizeInflated = -1;
                    continue;
                }
                if (!this.inf.needsInput() || this.fill()) continue;
                sizeInflated = -1;
            }
            return sizeInflated;
        }
        catch (DataFormatException dataErr) {
            String s = dataErr.getMessage();
            throw new ZipException(s != null ? s : "Invalid ZLIB data format");
        }
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.isEOF()) {
            return 0;
        }
        return this.in.available();
    }

    public long skip(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("Negative skip length");
        }
        this.ensureOpen();
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        byte[] b = new byte[512];
        for (total = 0; total < max; total += len) {
            len = max - total;
            if (len > b.length) {
                len = b.length;
            }
            if ((len = this.read(b, 0, len)) != -1) continue;
            this.setEOFReached(true);
            break;
        }
        return total;
    }

    public void close() throws IOException {
        super.close();
        this.inf.end();
        this.in.close();
        this.in = null;
        this.closed = true;
    }

    private boolean fill() throws IOException {
        boolean filled = false;
        this.ensureOpen();
        if (this.isEOF()) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.bufLength = this.in.read(this.buf, 0, this.buf.length);
        if (this.bufLength <= 0) {
            this.setEOFReached(true);
        } else {
            this.inf.setInput(this.buf, 0, this.bufLength);
            filled = true;
        }
        return filled;
    }
}

