/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.boot.streamhandler;

import com.installshield.boot.CoreZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipURLConnection
extends URLConnection {
    private static Hashtable openFiles = new Hashtable();
    private String fileName;
    private String entryName;
    private ZipFile zipFile = null;

    private static ZipFile getZipFile(String fileName) throws IOException {
        ZipFile file = (ZipFile)openFiles.get(fileName);
        if (file == null) {
            file = new ZipFile(fileName);
            openFiles.put(fileName, file);
        }
        return file;
    }

    public static void closeAllOpenFiles(String fileName) throws IOException {
        Enumeration e = openFiles.elements();
        while (e.hasMoreElements()) {
            ((ZipFile)e.nextElement()).close();
        }
        openFiles.clear();
    }

    public static void closeOpenFile(String fileName) throws IOException {
        ZipFile file = (ZipFile)openFiles.get(fileName);
        if (file != null) {
            file.close();
            openFiles.remove(fileName);
        }
    }

    ZipURLConnection(URL url, String fileName, String entryName) {
        super(url);
        this.fileName = fileName;
        this.entryName = CoreZipUtils.cleanZipEntry(entryName);
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        ZipEntry entry;
        if (this.zipFile == null) {
            this.zipFile = ZipURLConnection.getZipFile(this.fileName);
        }
        if ((entry = this.zipFile.getEntry(this.entryName)) == null) {
            throw new IOException("entry " + this.entryName + " does not exist in " + this.fileName);
        }
        return CoreZipUtils.createZipInputStream(this.zipFile.getInputStream(entry));
    }

    public String getContentType() {
        String name = this.entryName.toUpperCase();
        if (name.endsWith(".GIF")) {
            return "image/gif";
        }
        if (name.endsWith(".JPG") || name.endsWith(".JPEG")) {
            return "image/jpg";
        }
        return null;
    }

    protected void closeFile() throws IOException {
        if (this.zipFile != null && this.fileName != null) {
            ZipURLConnection.closeOpenFile(this.fileName);
            this.zipFile = null;
        }
    }
}

