/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.qjml;

import java.beans.PropertyEditorSupport;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateEditor
extends PropertyEditorSupport {
    public String getAsText() {
        if (this.getValue() instanceof Date) {
            return this.encodeDate((Date)this.getValue());
        }
        return "";
    }

    public void setAsText(String text) {
        if (text.length() != 24) {
            throw new IllegalArgumentException("expected date length of 24");
        }
        int offset = 0;
        try {
            Calendar calendar = Calendar.getInstance();
            int year = Integer.parseInt(text.substring(offset, offset += 4));
            int month = Integer.parseInt(text.substring(offset, offset += 2));
            int date = Integer.parseInt(text.substring(offset, offset += 2));
            int hour = Integer.parseInt(text.substring(++offset, offset += 2));
            int minute = Integer.parseInt(text.substring(offset, offset += 2));
            int second = Integer.parseInt(text.substring(offset, offset += 2));
            int milliSecond = Integer.parseInt(text.substring(++offset, offset += 3));
            String temp = text.substring(offset, offset += 5);
            int zone = this.decodeTimeZone(temp);
            TimeZone tz = calendar.getTimeZone();
            int localTZOffset = tz.getRawOffset();
            tz.setRawOffset(zone);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, date);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            calendar.set(14, milliSecond);
            calendar.getTime();
            tz.setRawOffset(localTZOffset);
            this.setValue(calendar.getTime());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("could not prcess value starting at " + offset);
        }
    }

    private String encodeDate(Date date) {
        StringBuffer buf = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        buf.append(this.formatYear(calendar.get(1)));
        buf.append(this.formatTens(calendar.get(2)));
        buf.append(this.formatTens(calendar.get(5)));
        buf.append(' ');
        buf.append(this.formatTens(calendar.get(11)));
        buf.append(this.formatTens(calendar.get(12)));
        buf.append(this.formatTens(calendar.get(13)));
        buf.append('.');
        buf.append(this.formatHundreds(calendar.get(14)));
        TimeZone tz = calendar.getTimeZone();
        buf.append(this.formatZoneOffset(tz.getRawOffset()));
        return buf.toString();
    }

    private String formatZoneOffset(int i) {
        String neg = i < 0 ? "-" : " ";
        i = Math.abs(i / 36000);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(4);
        nf.setGroupingUsed(false);
        return neg + nf.format(i);
    }

    private String formatYear(int year) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(4);
        nf.setGroupingUsed(false);
        return nf.format(year);
    }

    private String formatTens(int i) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setGroupingUsed(false);
        return nf.format(i);
    }

    private String formatHundreds(int i) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        nf.setGroupingUsed(false);
        return nf.format(i);
    }

    private int decodeTimeZone(String timeZone) {
        String timeZoneString = timeZone;
        if (timeZoneString.startsWith("+")) {
            timeZoneString = timeZoneString.substring(1);
        }
        return Integer.parseInt(timeZoneString.trim()) * 36000;
    }
}

