/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.qjml;

import com.installshield.qjml.CloneOutputStream;
import com.installshield.qjml.QJMLException;
import com.installshield.util.MD5;
import com.jxml.quick.QContext;
import com.jxml.quick.QConvert;
import com.jxml.quick.QDoc;
import com.jxml.quick.QPE;
import com.jxml.quick.Quick;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class QJML {
    private static String parserClass = null;
    private static Parser parser = null;
    private static Hashtable schemaURLs = new Hashtable();
    private static Hashtable schemaDocs = new Hashtable();
    public static final String QJML_ENCODING = "UTF8";
    private static CloneOutputStream bytesOut = new CloneOutputStream(10240);

    public static void main(String[] args) {
        block3: {
            if (args.length != 3) {
                System.err.println("use: QJML <factory class> <QJML type> <output file>");
                System.exit(-1);
            }
            try {
                Object obj = Class.forName(args[0]).newInstance();
                Class<?> type = Class.forName(args[1]);
                QJML.write(obj, type, args[2]);
            }
            catch (Throwable th) {
                System.err.println("The following error occurred: " + th);
                if (System.getProperty("is.debug") == null) break block3;
                th.printStackTrace();
            }
        }
    }

    public static void setParserClass(String className) {
        parserClass = className;
    }

    public static String getParserClass() {
        return parserClass;
    }

    public static Parser getParser() throws QJMLException {
        if (parser == null) {
            try {
                parser = parserClass != null ? ParserFactory.makeParser(parserClass) : ParserFactory.makeParser();
            }
            catch (Exception e) {
                try {
                    parser = ParserFactory.makeParser("com.ibm.xml.parsers.SAXParser");
                }
                catch (Exception e1) {
                    throw new QJMLException(3001, (Object)e);
                }
            }
        }
        return parser;
    }

    public static void setClassSchema(Class type, String url) {
        if (url != null) {
            schemaURLs.put(type, url);
        } else {
            schemaURLs.remove(type);
        }
    }

    public static String getClassSchema(Class type) {
        String schema;
        block4: {
            schema = (String)schemaURLs.get(type);
            if (schema == null) {
                String resStr = "/" + type.getName().replace('.', '/') + ".qjml";
                try {
                    URL res = type.getResource(resStr);
                    if (res != null) {
                        schema = res.toExternalForm();
                    }
                }
                catch (Exception e) {
                    if (System.getProperty("is.debug") == null) break block4;
                    e.printStackTrace();
                }
            }
        }
        return schema;
    }

    public static QDoc getSchemaDoc(Class type) throws QJMLException, IOException, SAXException {
        QDoc doc = (QDoc)schemaDocs.get(type);
        if (doc == null) {
            Parser parser = QJML.getParser();
            String schemaFile = QJML.getClassSchema(type);
            if (schemaFile == null) {
                throw new QJMLException(1002, type);
            }
            doc = Quick.parseSchema(parser, schemaFile);
            schemaDocs.put(type, doc);
        }
        return doc;
    }

    public static String express(Object object, Class type) throws IOException, QJMLException {
        try {
            QDoc schemaDoc = QJML.getSchemaDoc(type);
            QContext context = Quick.createContext(schemaDoc);
            QDoc objectDoc = Quick.createDoc(object);
            return Quick.express(objectDoc, context);
        }
        catch (QPE e) {
            if (System.getProperty("is.debug") != null) {
                System.err.println("line/col: " + e.getLineNumber() + "/" + e.getColumnNumber());
                e.printStackTrace();
            }
            throw new QJMLException(3002, e.getMessage());
        }
        catch (SAXException e) {
            if (System.getProperty("is.debug") != null) {
                e.printStackTrace();
            }
            throw new QJMLException(3000, e.getMessage());
        }
    }

    public static byte[] expressBytes(Object object, Class type) throws IOException, QJMLException {
        return QJML.express(object, type, QJML_ENCODING);
    }

    private static byte[] express(Object object, Class type, String encoding) throws IOException, QJMLException {
        try {
            QDoc schemaDoc = QJML.getSchemaDoc(type);
            QContext context = Quick.createContext(schemaDoc);
            QDoc objectDoc = Quick.createDoc(object);
            String unicodeXML = Quick.express(objectDoc, context);
            return unicodeXML.getBytes(encoding);
        }
        catch (QPE e) {
            if (System.getProperty("is.debug") != null) {
                System.err.println("line/col: " + e.getLineNumber() + "/" + e.getColumnNumber());
                e.printStackTrace();
            }
            throw new QJMLException(3002, e.getMessage());
        }
        catch (SAXException e) {
            if (System.getProperty("is.debug") != null) {
                e.printStackTrace();
            }
            throw new QJMLException(3000, e.getMessage());
        }
    }

    public static void write(Object object, Class type, PrintWriter out) throws IOException, QJMLException {
        String xml = QJML.express(object, type);
        out.write(xml);
        out.flush();
    }

    public static void write(Object object, Class type, String fileName) throws IOException, QJMLException {
        byte[] xmlBytes = QJML.expressBytes(object, type);
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(xmlBytes);
        out.close();
    }

    public static Object read(URL url, Class type) throws IOException, QJMLException {
        InputSource source = new InputSource(url.openStream());
        source.setEncoding(QJML_ENCODING);
        return QJML.read(source, type);
    }

    public static Object read(InputStream in, Class type) throws IOException, QJMLException {
        InputSource source = new InputSource(in);
        source.setEncoding(QJML_ENCODING);
        return QJML.read(source, type);
    }

    private static Object read(InputSource in, Class type) throws IOException, QJMLException {
        try {
            QDoc schemaDoc = QJML.getSchemaDoc(type);
            QContext context = Quick.createContext(schemaDoc);
            QDoc objectDoc = Quick.parse(QJML.getParser(), context, in);
            return Quick.getRoot(objectDoc);
        }
        catch (QPE e) {
            if (System.getProperty("is.debug") != null) {
                System.err.println("line/col: " + e.getLineNumber() + "/" + e.getColumnNumber());
                e.printStackTrace();
            }
            throw new QJMLException(3002, e.getMessage());
        }
        catch (SAXException e) {
            if (System.getProperty("is.debug") != null) {
                e.printStackTrace();
            }
            throw new QJMLException(3000, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object clone(Object object, Class type) throws IOException, QJMLException {
        try {
            CloneOutputStream cloneOutputStream = bytesOut;
            synchronized (cloneOutputStream) {
                bytesOut.reset();
                bytesOut.write(QJML.expressBytes(object, type));
                QDoc schemaDoc = QJML.getSchemaDoc(type);
                QContext context = Quick.createContext(schemaDoc);
                QConvert convert = new QConvert(context);
                Parser parser = QJML.parser;
                synchronized (parser) {
                    Parser parser2 = QJML.getParser();
                    parser2.setDocumentHandler(convert);
                    InputSource inputSource = new InputSource(bytesOut.createInputStream());
                    inputSource.setEncoding(QJML_ENCODING);
                    parser2.parse(inputSource);
                    QDoc objectDoc = context.doc;
                    return Quick.getRoot(objectDoc);
                }
            }
        }
        catch (SAXException e) {
            if (System.getProperty("is.debug") != null) {
                e.printStackTrace();
            }
            throw new QJMLException(3000, e.getMessage());
        }
    }

    public static String createDigest(Object object, Class type, byte[] key) throws IOException {
        MD5 md5 = new MD5();
        md5.write(QJML.expressBytes(object, type));
        md5.write(key);
        return MD5.toHex(md5.toHash());
    }

    public static String createDigest(URL url, Class type, byte[] key) throws IOException {
        InputStream in = url.openStream();
        String digest = QJML.createDigest(in, type, key);
        in.close();
        return digest;
    }

    public static String createDigest(InputStream in, Class type, byte[] key) throws IOException {
        int read;
        MD5 md5 = new MD5();
        byte[] buf = new byte[5120];
        while ((read = in.read(buf)) != -1) {
            md5.write(buf, 0, read);
        }
        md5.write(key);
        return MD5.toHex(md5.toHash());
    }
}

