/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.qjml;

import java.io.IOException;

public class QJMLException
extends IOException {
    public static final int INIT_GENERAL = 1000;
    public static final int INVALID_SCHEMA_PATH = 1001;
    public static final int NO_SCHEMA_FOR_CLASS = 1002;
    public static final int SAX_GENERAL = 3000;
    public static final int CANNOT_CREATE_PARSER = 3001;
    public static final int QPE_ERROR = 3002;
    public static final int JAVA_EXCEPTION = 2000;
    private int code = 0;
    private String msg = null;
    private Object data = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: QJMLException error_code");
            System.exit(-1);
        }
        try {
            System.out.println(QJMLException.getErrorMsg(Integer.parseInt(args[0])));
        }
        catch (Exception e) {
            System.out.println("invalid error code: " + args[0]);
        }
    }

    public static String getErrorMsg(int code) {
        switch (code) {
            case 1000: {
                return "general initialization error";
            }
            case 1001: {
                return "invalid schema path";
            }
            case 1002: {
                return "cannot find schema for class";
            }
            case 3000: {
                return "SAX exception";
            }
            case 3002: {
                return "Quick error";
            }
            case 2000: {
                return "Java exception";
            }
            case 3001: {
                return "could not create SAX parser";
            }
        }
        return "unknown error code";
    }

    public QJMLException(int code) {
        this.code = code;
    }

    public QJMLException(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public QJMLException(int code, Object data) {
        this(code, null, data);
    }

    public QJMLException(int code, String msg, Object data) {
        this(code, msg);
        this.data = data;
    }

    public QJMLException(Exception e) {
        this.code = 2000;
        this.msg = e.getMessage();
        this.data = e;
    }

    public int getErrorCode() {
        return this.code;
    }

    public String getMessage() {
        return this.msg != null ? this.msg : QJMLException.getErrorMsg(this.code);
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        return "QJMLException: (error code = " + this.code + "; message=\"" + this.getMessage() + "\"" + (this.data != null ? "; " + this.getDataDesc() + " = [" + this.data + "]" : "") + ")";
    }

    private String getDataDesc() {
        if (this.code == 2000) {
            return "exception";
        }
        return "additional data";
    }
}

