/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.qjml;

import com.installshield.beans.ISIntrospector;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.qjml.QPlaceHolder;
import com.installshield.qjml.QPropertyPlaceHolder;
import com.jxml.quick.QBiModal;
import com.jxml.quick.QContext;
import com.jxml.quick.QPE;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;

public class QProperty
implements QBiModal {
    private String name = null;
    private String type = null;
    private String textValue = null;
    private boolean array = false;
    private Object value = null;
    private int arrayLength = -1;
    private int nextIndex = 0;
    static /* synthetic */ Class class$java$lang$String;

    public QProperty() {
    }

    public QProperty(String name, Class type, Object value) {
        this(name, type, value, false);
    }

    public QProperty(String name, Class type, Object value, boolean forceType) {
        this.name = name;
        if (value instanceof QPlaceHolder) {
            this.array = false;
            QPlaceHolder ph = (QPlaceHolder)value;
            this.type = ph.getClassName();
        } else {
            this.array = type.isArray();
            if (this.array) {
                type = type.getComponentType();
                this.arrayLength = value != null ? Array.getLength(value) : -1;
            }
            this.type = forceType || this.array || !type.isPrimitive() && type != (class$java$lang$String == null ? (class$java$lang$String = QProperty.class$("java.lang.String")) : class$java$lang$String) ? (type == (class$java$lang$String == null ? (class$java$lang$String = QProperty.class$("java.lang.String")) : class$java$lang$String) ? "string" : type.getName()) : "";
            if (value != null && !(value instanceof PropertyAccessible) && !this.array) {
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                if (editor != null) {
                    editor.setValue(value);
                    this.textValue = editor.getAsText();
                } else {
                    this.textValue = value.toString();
                }
            }
        }
        this.value = value;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getType() {
        return this.type;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArrayLength(int length) {
        this.arrayLength = length;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public void setQText(String s) {
        this.textValue = s;
    }

    public String getQText() {
        return this.textValue != null ? this.textValue : "";
    }

    public Object getValue(QContext context) throws Exception {
        if (this.value == null) {
            this.value = this.createValue(this.type, context);
        }
        return this.value;
    }

    private Object createValue(String className, QContext context) throws Exception {
        try {
            return this.createValue(this.getClass(className, context), null);
        }
        catch (Throwable th) {
            QPropertyPlaceHolder ph = new QPropertyPlaceHolder();
            ph.setClassName(className);
            ph.setPlaceHolderMessage("property '" + this.getName() + "' could not be loaded: " + th);
            return ph;
        }
    }

    private Class getClass(String name, QContext context) throws ClassNotFoundException {
        if (name.equals("string")) {
            return class$java$lang$String == null ? (class$java$lang$String = QProperty.class$("java.lang.String")) : class$java$lang$String;
        }
        if (Integer.TYPE.getName().equals(name)) {
            return Integer.TYPE;
        }
        if (Boolean.TYPE.getName().equals(name)) {
            return Boolean.TYPE;
        }
        if (Byte.TYPE.getName().equals(name)) {
            return Byte.TYPE;
        }
        if (Character.TYPE.getName().equals(name)) {
            return Character.TYPE;
        }
        if (Double.TYPE.getName().equals(name)) {
            return Double.TYPE;
        }
        if (Float.TYPE.getName().equals(name)) {
            return Float.TYPE;
        }
        if (Long.TYPE.getName().equals(name)) {
            return Long.TYPE;
        }
        if (Short.TYPE.getName().equals(name)) {
            return Short.TYPE;
        }
        try {
            return context.forName(name);
        }
        catch (QPE e) {
            throw new ClassNotFoundException(name);
        }
    }

    private Object createValue(Class type, Class editorClass) throws Exception {
        Object value = null;
        if (this.array) {
            value = this.arrayLength == -1 ? null : Array.newInstance(type, this.arrayLength);
        } else if (this.getQText().length() > 0) {
            PropertyEditor editor = null;
            if (editorClass != null) {
                try {
                    editor = (PropertyEditor)editorClass.newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (editor == null && type != null) {
                editor = PropertyEditorManager.findEditor(type);
            }
            if (editor != null) {
                editor.setAsText(this.getQText());
                value = editor.getValue();
            } else {
                Constructor cnst = type.getConstructor(class$java$lang$String == null ? (class$java$lang$String = QProperty.class$("java.lang.String")) : class$java$lang$String);
                value = cnst.newInstance(this.getQText());
            }
        } else {
            value = type.newInstance();
        }
        return value;
    }

    public boolean writeToParent(Object parent, QContext context) throws QPE {
        boolean written = false;
        if (parent instanceof QPlaceHolder) {
            QPlaceHolder ph = (QPlaceHolder)parent;
            Properties properties = (Properties)ph.getPlaceHolderProperties();
            try {
                if (this.getType() != null) {
                    ((Hashtable)properties).put(this.getName(), this.getValue(context));
                } else {
                    ((Hashtable)properties).put(this.getName(), this.getQText());
                }
            }
            catch (Exception e) {
                throw new QPE(e, context);
            }
            written = true;
        } else {
            BeanInfo beanInfo = null;
            try {
                beanInfo = ISIntrospector.getBeanInfo(parent.getClass());
            }
            catch (Throwable th) {
                throw new QPE("An error occurred creating the bean info for " + parent.getClass() + ": " + th, context);
            }
            if (beanInfo != null) {
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < pds.length; ++i) {
                    Method write;
                    if (!pds[i].getName().equals(this.getName())) continue;
                    if (this.value == null) {
                        Class<?> propertyEditorClass;
                        Class<?> type;
                        if (this.type == null || this.type.trim().length() == 0) {
                            type = pds[i].getPropertyType();
                            propertyEditorClass = pds[i].getPropertyEditorClass();
                        } else {
                            try {
                                type = this.getClass(this.type, context);
                            }
                            catch (Exception e) {
                                type = pds[i].getPropertyType();
                            }
                            propertyEditorClass = null;
                        }
                        if (type.isArray()) {
                            type = type.getComponentType();
                        }
                        try {
                            this.value = this.createValue(type, propertyEditorClass);
                        }
                        catch (Exception e) {
                            throw new QPE(e, context);
                        }
                    }
                    if ((write = pds[i].getWriteMethod()) == null) break;
                    if (this.value == null) {
                        throw new QPE("could not write property " + this.getName() + " to " + parent + " because it is null", context);
                    }
                    if (this.value instanceof QPlaceHolder) {
                        throw new QPE("could not write property " + this.getName() + " to " + parent + ": " + ((QPlaceHolder)this.value).getPlaceHolderMessage(), context);
                    }
                    if (!this.isValueCompatible(this.value, pds[i].getPropertyType())) {
                        throw new QPE("could not write property " + this.getName() + " to " + parent + " because it is the wrong data type", context);
                    }
                    try {
                        write.invoke(parent, this.value);
                        written = true;
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof InvocationTargetException) {
                            Throwable target = ((InvocationTargetException)e).getTargetException();
                            if (target instanceof Exception) {
                                throw new QPE((Exception)target, context);
                            }
                            throw new QPE(target.getMessage(), context);
                        }
                        throw new QPE(e, context);
                    }
                }
            }
        }
        return written;
    }

    private boolean isValueCompatible(Object value, Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return value instanceof Integer;
            }
            if (type == Boolean.TYPE) {
                return value instanceof Boolean;
            }
            if (type == Byte.TYPE) {
                return value instanceof Byte;
            }
            if (type == Character.TYPE) {
                return value instanceof Character;
            }
            if (type == Double.TYPE) {
                return value instanceof Double;
            }
            if (type == Float.TYPE) {
                return value instanceof Float;
            }
            if (type == Long.TYPE) {
                return value instanceof Long;
            }
            if (type == Short.TYPE) {
                return value instanceof Short;
            }
            throw new Error();
        }
        return type.isInstance(value);
    }

    public void setNextIndex(int index) {
        this.nextIndex = index;
    }

    public int getNextIndex() {
        return this.nextIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

