/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.util.Enumeration;
import java.util.Vector;

public class CommandLineTokenizer
implements Enumeration {
    private Enumeration tokens;

    public CommandLineTokenizer(String s) {
        this.tokens = CommandLineTokenizer.parse(s).elements();
    }

    private static Vector parse(String s) {
        if (s == null) {
            return new Vector();
        }
        Vector tokens = new Vector();
        int i = 0;
        while (i < s.length()) {
            i = CommandLineTokenizer.skipws(s, i);
            i = CommandLineTokenizer.consumeToken(s, i, tokens);
        }
        return tokens;
    }

    private static int consumeToken(String s, int offset, Vector out) {
        if (offset < s.length()) {
            char open;
            char c = s.charAt(offset);
            if (c == '\"' || c == '\'') {
                open = c;
                ++offset;
            } else {
                open = '\u0000';
            }
            StringBuffer buf = new StringBuffer();
            boolean done = false;
            while (offset < s.length() && !done) {
                c = s.charAt(offset++);
                if (open != '\uffffffff' && c == open) {
                    done = true;
                    continue;
                }
                if (open == '\u0000' && Character.isWhitespace(c)) {
                    done = true;
                    continue;
                }
                if (c == '\\' && offset < s.length()) {
                    c = s.charAt(offset++);
                }
                buf.append(c);
            }
            if (buf.length() > 0) {
                out.addElement(buf.toString());
            }
        }
        return offset;
    }

    private static int skipws(String s, int offset) {
        while (offset < s.length() && Character.isWhitespace(s.charAt(offset))) {
            ++offset;
        }
        return offset;
    }

    public boolean hasMoreElements() {
        return this.tokens.hasMoreElements();
    }

    public Object nextElement() {
        return this.tokens.nextElement();
    }

    public static String createSpaceDelimitedString(String[] items) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            String token = CommandLineTokenizer.insertDoubleSlashes(items[i]);
            buf.append('\"');
            buf.append(token);
            buf.append('\"');
        }
        return buf.toString();
    }

    private static String insertDoubleSlashes(String string) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                buf.append("\\");
            }
            buf.append(string.charAt(i));
        }
        return buf.toString();
    }
}

