/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.qjml.PropertyAccessible;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileAttributes
implements PropertyAccessible,
Cloneable {
    private int attributes = 0;
    private Hashtable extendedAttributes = null;
    public static final int OS2 = 1;
    public static final int OWNER_READABLE = 1;
    public static final int OWNER_WRITEABLE = 2;
    public static final int OWNER_EXECUTABLE = 4;
    public static final int OWNER_FULL_ACCESS = 7;
    public static final int GROUP_READABLE = 8;
    public static final int GROUP_WRITEABLE = 16;
    public static final int GROUP_EXECUTABLE = 32;
    public static final int GROUP_FULL_ACCESS = 56;
    public static final int WORLD_READABLE = 64;
    public static final int WORLD_WRITEABLE = 128;
    public static final int WORLD_EXECUTABLE = 256;
    public static final int WORLD_FULL_ACCESS = 448;
    public static final int FULL_ACCESS = 511;
    public static final int HIDDEN = 512;
    public static final int ARCHIVE = 1024;
    public static final int SYSTEM = 2048;
    public static final int DIRECTORY = 4096;

    public void setAttributes(int attributes) {
        this.attributes = attributes;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public void setAttributeState(int attributeMask, boolean active) {
        this.attributes = active ? (this.attributes |= attributeMask) : (this.attributes &= ~attributeMask);
    }

    public boolean getAttributeState(int attributeMask) {
        return (this.attributes & attributeMask) == attributeMask;
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(this.attributes);
        int extendedAttributeCount = this.extendedAttributes == null ? 0 : this.extendedAttributes.size();
        data.writeInt(extendedAttributeCount);
        if (extendedAttributeCount > 0) {
            Enumeration e = this.extendedAttributes.keys();
            while (e.hasMoreElements()) {
                Short platformCode = (Short)e.nextElement();
                data.writeShort(platformCode.shortValue());
                byte[] value = (byte[])this.extendedAttributes.get(platformCode);
                data.writeInt(value.length);
                for (int ii = 0; ii < value.length; ++ii) {
                    data.writeByte(value[ii]);
                }
            }
        }
        data.flush();
    }

    public void read(InputStream in) throws IOException {
        DataInputStream data = new DataInputStream(in);
        this.setAttributes(data.readInt());
        int extendedAttributeCount = data.readInt();
        for (int yy = 0; yy < extendedAttributeCount; ++yy) {
            short platformCode = data.readShort();
            int byteLength = data.readInt();
            byte[] value = new byte[byteLength];
            for (int ii = 0; ii < value.length; ++ii) {
                value[ii] = data.readByte();
            }
            this.setExtended(platformCode, value);
        }
    }

    public void setExtended(short platformCode, byte[] value) {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new Hashtable();
        }
        this.extendedAttributes.put(new Short(platformCode), value);
    }

    public byte[] getExtended(short platformCode) {
        if (this.extendedAttributes != null) {
            return (byte[])this.extendedAttributes.get(new Short(platformCode));
        }
        return null;
    }

    public String toString() {
        String ownerPerm = new String((this.getAttributeState(1) ? "r" : "") + (this.getAttributeState(2) ? "w" : "") + (this.getAttributeState(4) ? "x" : ""));
        String groupPerm = new String((this.getAttributeState(8) ? "r" : "") + (this.getAttributeState(16) ? "w" : "") + (this.getAttributeState(32) ? "x" : ""));
        String worldPerm = new String((this.getAttributeState(64) ? "r" : "") + (this.getAttributeState(128) ? "w" : "") + (this.getAttributeState(256) ? "x" : ""));
        String hiddenPerm = new String(this.getAttributeState(512) ? " hidden" : "");
        String archivePerm = new String(this.getAttributeState(1024) ? " archive" : "");
        String systemPerm = new String(this.getAttributeState(2048) ? " system" : "");
        return new String("owner (" + ownerPerm + ")  group (" + groupPerm + ")  world (" + worldPerm + ")" + hiddenPerm + archivePerm + systemPerm);
    }

    public Object clone() {
        FileAttributes newAttributes = new FileAttributes();
        newAttributes.attributes = this.attributes;
        newAttributes.extendedAttributes = this.extendedAttributes;
        return newAttributes;
    }
}

