/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.util.TempFileOwner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class FileUtils
extends CoreFileUtils {
    private static Vector tempFileOwners = new Vector();
    private static LockedFilesHandler lockedFilesHandler = null;

    public static void setLockedFilesHandler(LockedFilesHandler handler) {
        if (lockedFilesHandler == null) {
            lockedFilesHandler = handler;
        } else if (System.getProperty("is.debug") != null) {
            System.out.println("locked file handler already set");
        }
    }

    public static LockedFilesHandler getLockedFilesHandler() {
        return lockedFilesHandler;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("use: FileUtils [options]");
            System.err.println("\noptions:\n");
            System.err.println("   -temp : prints the temporary directory for the current JVM");
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-temp")) {
                    System.out.println(CoreFileUtils.getTempDir());
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.exit(-1);
            }
        }
    }

    public static void addTempFileOwner(TempFileOwner owner) {
        tempFileOwners.addElement(owner);
    }

    public static void removeTempFileOwner(TempFileOwner owner) {
        tempFileOwners.removeElement(owner);
    }

    public static Enumeration tempFileOwners() {
        return tempFileOwners.elements();
    }

    public static void clearTempFileOwners() {
        tempFileOwners.removeAllElements();
    }

    public static synchronized byte[] decodeBytes(byte[] in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null");
        }
        if (in.length < 8) {
            throw new IOException("bytes cannot be decoded");
        }
        byte[] sizeBytes = new byte[6];
        sizeBytes[0] = (byte)((in[0] - 32 & 0x3F) << 2 | (in[1] - 32 & 0x3F) >> 4);
        sizeBytes[1] = (byte)((in[1] - 32 & 0x3F) << 4 | (in[2] - 32 & 0x3F) >> 2);
        sizeBytes[2] = (byte)((in[2] - 32 & 0x3F) << 6 | in[3] - 32 & 0x3F);
        sizeBytes[3] = (byte)((in[4] - 32 & 0x3F) << 2 | (in[5] - 32 & 0x3F) >> 4);
        int outSize = (0xFF & sizeBytes[0]) << 24 | (0xFF & sizeBytes[1]) << 16 | (0xFF & sizeBytes[2]) << 8 | 0xFF & sizeBytes[3];
        if (outSize < 0) {
            throw new IOException("bytes cannot be decoded");
        }
        byte[] out = new byte[outSize];
        int nextIn = 8;
        int nextOut = 0;
        while (nextOut < outSize) {
            byte[] inBlock = new byte[4];
            for (int i = 0; i < inBlock.length; ++i) {
                inBlock[i] = nextIn < in.length ? in[nextIn++] : (byte)0;
            }
            out[nextOut++] = (byte)((inBlock[0] - 32 & 0x3F) << 2 | (inBlock[1] - 32 & 0x3F) >> 4);
            if (nextOut >= outSize) continue;
            out[nextOut++] = (byte)((inBlock[1] - 32 & 0x3F) << 4 | (inBlock[2] - 32 & 0x3F) >> 2);
            if (nextOut >= outSize) continue;
            out[nextOut++] = (byte)((inBlock[2] - 32 & 0x3F) << 6 | inBlock[3] - 32 & 0x3F);
        }
        return out;
    }

    public static synchronized byte[] decodeBytes(String s) throws IOException {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return FileUtils.decodeBytes(bytes);
    }

    public static Enumeration tempFiles() {
        return CoreFileUtils.getTempFiles().elements();
    }

    public static String[] deleteTempFiles() {
        int i;
        boolean deletedOne;
        Enumeration e = FileUtils.tempFileOwners();
        while (e.hasMoreElements()) {
            ((TempFileOwner)e.nextElement()).closeTempFile();
        }
        Vector<String> directories = new Vector<String>();
        Vector<String> locked = new Vector<String>();
        Enumeration e2 = FileUtils.tempFiles();
        while (e2.hasMoreElements()) {
            String fileName = (String)e2.nextElement();
            File f = new File(fileName);
            if (f.isFile()) {
                if (f.delete()) continue;
                locked.addElement(f.getAbsolutePath());
                continue;
            }
            if (!f.isDirectory()) continue;
            directories.addElement(fileName);
        }
        do {
            deletedOne = false;
            for (i = 0; !deletedOne && i < directories.size(); ++i) {
                String dirName = (String)directories.elementAt(i);
                if (!FileUtils.deleteDirectory(dirName)) continue;
                directories.removeElementAt(i);
                deletedOne = true;
            }
        } while (deletedOne);
        for (i = 0; i < directories.size(); ++i) {
            locked.addElement((String)directories.elementAt(i));
        }
        Vector<String> failed = new Vector<String>();
        if (lockedFilesHandler != null) {
            Object[] lockedFiles = new String[locked.size()];
            locked.copyInto(lockedFiles);
            lockedFilesHandler.deleteLockedFiles((String[])lockedFiles);
        } else {
            for (int i2 = 0; i2 < locked.size(); ++i2) {
                String lockedFile = (String)locked.elementAt(i2);
                failed.addElement(lockedFile);
            }
        }
        CoreFileUtils.resetCurrentTempDir();
        Object[] ret = new String[failed.size()];
        failed.copyInto(ret);
        return ret;
    }

    public static boolean deleteDirectory(String dirName) {
        File dir = new File(dirName);
        if (dir.isDirectory()) {
            String[] list = dir.list();
            for (int i = 0; i < list.length; ++i) {
                String fileName = CoreFileUtils.createFileName(dirName, list[i]);
                File file = new File(fileName);
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileUtils.deleteDirectory(fileName);
            }
        }
        return dir.delete();
    }

    public static String removeTerminalSeparator(String path) {
        String tempPath = path;
        while (tempPath.length() > 0 && (tempPath.endsWith("/") || tempPath.endsWith(File.separator))) {
            tempPath = tempPath.substring(0, tempPath.length() - 1);
        }
        return tempPath;
    }

    public static String getPartitionName(String absolutePath, String[] partitionNames) {
        return FileUtils.getPartitionName(absolutePath, partitionNames, "");
    }

    public static String getPartitionName(String absolutePath, String[] partitionNames, String defaultPartition) {
        String mapped;
        String convertedPath;
        try {
            convertedPath = new File(absolutePath).getCanonicalPath();
        }
        catch (Exception genErr) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("FileUtils.getPartitionName(): Problem converting path to canonical form: " + absolutePath);
                genErr.printStackTrace();
            }
            convertedPath = absolutePath;
        }
        String[] partitions = (String[])partitionNames.clone();
        for (int j = 0; j < partitions.length; ++j) {
            partitions[j] = CoreFileUtils.appendSeparator(partitions[j]).replace(File.separatorChar, '/');
        }
        String path = convertedPath.replace(File.separatorChar, '/');
        Vector matches = new Vector();
        FileUtils.getPartitionMatches(path, partitions, matches);
        path = CoreFileUtils.appendSeparator(path).replace(File.separatorChar, '/');
        FileUtils.getPartitionMatches(path, partitions, matches);
        if (matches.size() != 0 || defaultPartition.equals("")) {
            mapped = convertedPath;
            int maxLength = 0;
            for (int i = 0; i < matches.size(); ++i) {
                String vol = partitionNames[(Integer)matches.elementAt(i)];
                if (vol.length() <= maxLength) continue;
                mapped = vol;
                maxLength = vol.length();
            }
        } else {
            mapped = defaultPartition;
        }
        return mapped;
    }

    private static void getPartitionMatches(String path, String[] partitions, Vector matches) {
        boolean evaluateCase = CoreFileUtils.isFileSystemCaseSensitive();
        for (int i = 0; i < partitions.length; ++i) {
            if ((!evaluateCase || !path.startsWith(partitions[i])) && (evaluateCase || !path.toUpperCase().startsWith(partitions[i].toUpperCase()))) continue;
            matches.addElement(new Integer(i));
        }
    }

    public static String formatSizeAsBytes(long bytes) {
        String UINT_MB = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "MB");
        String UINT_KB = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "KB");
        double sizeDouble = bytes;
        double MB = 1048576.0;
        double base = 0.0;
        String unitString = null;
        if ((double)bytes > MB) {
            base = sizeDouble / MB;
            unitString = UINT_MB;
        } else {
            base = sizeDouble / 1024.0;
            if (base < 1.0 && base > 0.0) {
                base = 1.0;
            }
            unitString = UINT_KB;
        }
        String pattern = "{0, number, #0.#} {1}";
        return MessageFormat.format(pattern, new Double(base), unitString);
    }

    public static String getName(String fileName) {
        return new File(CoreFileUtils.normalizeFileName(fileName)).getName();
    }

    public static boolean compareFileNames(String name1, String name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        if (CoreFileUtils.isFileSystemCaseSensitive()) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    public static boolean compareBytes(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CoreFileUtils.copy(in, out);
        out.flush();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileUnicode(File file) {
        boolean isUnicode = false;
        int maxSize = 1024;
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                int c = in.read();
                if (c != -1 && c == 255) {
                    c = in.read();
                    isUnicode = c != -1 && c == 254;
                } else {
                    for (int i = 0; i < maxSize && !isUnicode && c != -1; ++i) {
                        isUnicode = c == 0;
                        c = in.read();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    CoreFileUtils.close(in);
                }
            }
        }
        return isUnicode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFromFile(String fileName, String encoding) {
        String retStr = null;
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            if (new File(fileName).exists()) {
                in = new FileInputStream(fileName);
                out = new ByteArrayOutputStream();
                CoreFileUtils.copy(in, out);
                retStr = encoding == null || encoding.trim().length() <= 0 ? new String(out.toByteArray()) : new String(out.toByteArray(), encoding);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            CoreFileUtils.close(in);
            CoreFileUtils.close(out);
        }
        return retStr;
    }

    public static String getUniversalTempDir() {
        return CoreFileUtils.getIsjeTempDir();
    }
}

