/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Progress;

public class GenericProgress
implements Progress {
    private String title = "";
    private String statusDescription = "";
    private String statusDetail = "";
    private int percentComplete = 0;
    private boolean redisplayProgress = false;
    private String lastMessage = null;
    private boolean canCancelOperation = true;

    public GenericProgress() {
    }

    public GenericProgress(Progress p) {
        this.update(p);
    }

    public void clear() {
        this.title = "";
        this.statusDescription = "";
        this.statusDetail = "";
        this.percentComplete = 0;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setStatusDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.statusDescription = description;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDetail(String detail) {
        if (detail == null) {
            detail = "";
        }
        this.statusDetail = detail;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public void setPercentComplete(int percent) {
        this.percentComplete = percent;
    }

    public void setPercentComplete(long numerator, long denominator) {
        if (denominator != 0L) {
            this.setPercentComplete(Math.round(numerator * 100L / denominator));
        }
    }

    public void update(Progress progress) {
        this.setTitle(progress.getTitle());
        this.setStatusDescription(progress.getStatusDescription());
        this.setStatusDetail(progress.getStatusDetail());
        this.setPercentComplete(progress.getPercentComplete());
        this.setLastMessage(progress.getLastMessage());
        this.setCancelableOperation(progress.isCancelableOperation());
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void incrementProgress(int percentIncrease) {
        this.setPercentComplete(this.getPercentComplete() + percentIncrease);
    }

    public void setLastMessage(String message) {
        this.lastMessage = message;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.statusDescription != null && this.statusDescription.length() > 0) {
            buf.append(this.statusDescription);
        }
        if (this.statusDetail != null && this.statusDetail.length() > 0) {
            if (buf.length() > 0) {
                buf.append(" - ");
            }
            buf.append(this.statusDetail);
        }
        if (this.percentComplete > 0) {
            String percentMsg = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "percentCompleteAt", new String[]{"" + this.percentComplete});
            if (buf.length() > 0) {
                buf.append(" (" + percentMsg + ")");
            } else {
                buf.append(percentMsg);
            }
        }
        return buf.toString();
    }

    public void setRedisplayProgress(boolean redisplayProgress) {
        this.redisplayProgress = redisplayProgress;
    }

    public boolean getRedisplayProgress() {
        return this.redisplayProgress;
    }

    public void setCancelableOperation(boolean cancelable) {
        this.canCancelOperation = cancelable;
    }

    public boolean isCancelableOperation() {
        return this.canCancelOperation;
    }
}

