/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.boot.CoreFileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringUtils;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class LocaleUtils {
    public static final int LANGUAGE = 1;
    public static final int COUNTRY = 2;
    public static final int VARIANT = 3;
    public static final String LOCALE_SEPARATOR = ";";

    public static String encodeLocales(Locale[] locales) {
        StringBuffer buf = new StringBuffer();
        if (locales != null && locales.length > 0) {
            buf.append(LocaleUtils.encodeLocale(locales[0]));
            for (int i = 1; i < locales.length; ++i) {
                buf.append(LOCALE_SEPARATOR + LocaleUtils.encodeLocale(locales[i]));
            }
        }
        return buf.toString();
    }

    public static String encodeLocale(Locale locale) {
        String encodedLocale = null;
        if (locale != null && locale.getLanguage().length() > 0) {
            encodedLocale = locale.getLanguage();
            if (locale.getCountry().length() > 0) {
                encodedLocale = encodedLocale + "_" + locale.getCountry();
                if (locale.getVariant().length() > 0) {
                    encodedLocale = encodedLocale + "_" + locale.getVariant();
                }
            }
        }
        return encodedLocale;
    }

    public static Locale[] decodeLocales(String encoded) {
        return LocaleUtils.decodeLocales(encoded, LOCALE_SEPARATOR);
    }

    public static Locale[] decodeLocales(String encoded, String separator) {
        if (encoded == null || encoded.equals("")) {
            return new Locale[0];
        }
        StringTokenizer tokens = new StringTokenizer(encoded, separator);
        Locale[] ret = new Locale[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            ret[i++] = LocaleUtils.decodeLocale(tokens.nextToken());
        }
        return ret;
    }

    public static Locale decodeLocale(String encoded) {
        if (encoded == null || encoded.equals("")) {
            return Locale.getDefault();
        }
        StringTokenizer tokens = new StringTokenizer(encoded, "_");
        if (tokens.countTokens() >= 3) {
            return new Locale(tokens.nextToken(), tokens.nextToken(), tokens.nextToken());
        }
        if (tokens.countTokens() == 2) {
            return new Locale(tokens.nextToken(), tokens.nextToken());
        }
        if (tokens.countTokens() == 1) {
            return new Locale(tokens.nextToken(), "");
        }
        return null;
    }

    public static boolean arrayContainsLocale(Locale l, Locale[] ls) {
        for (int i = 0; i < ls.length; ++i) {
            if (!ls[i].getLanguage().equals(l.getLanguage()) || ls[i].getCountry().length() > 0 && l.getCountry().length() > 0 && !ls[i].getCountry().equals(l.getCountry())) continue;
            return true;
        }
        return false;
    }

    public static String getLocaleDisplayName(Locale locale) {
        String ret = null;
        Locale curLocale = Locale.getDefault();
        if (locale.getLanguage().equalsIgnoreCase("zh")) {
            if (curLocale.getLanguage().equalsIgnoreCase("zh")) {
                return LocaleUtils.getChineseLocaleDisplayName(locale.getCountry(), curLocale.getCountry());
            }
            return LocaleUtils.getNonChineseLocaleDisplayName(locale.getCountry());
        }
        if (locale.getLanguage().equalsIgnoreCase("pt")) {
            return LocaleUtils.getPortugueseLocaleDisplayName(locale.getCountry());
        }
        ret = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils." + locale.getLanguage());
        if (ret == null || ret.trim().length() == 0) {
            ret = locale.getDisplayName();
        }
        return ret;
    }

    private static String getChineseLocaleDisplayName(String country, String curCountry) {
        String ret = "Chinese";
        if (curCountry == null || curCountry.length() <= 0) {
            curCountry = "CN";
        }
        if (country == null || country.length() <= 0) {
            country = "CN";
        }
        curCountry = curCountry.toUpperCase();
        country = country.toUpperCase();
        ret = curCountry.indexOf("TW") >= 0 || curCountry.indexOf("HK") >= 0 ? (country.indexOf("TW") >= 0 || country.indexOf("HK") >= 0 ? "\u7e41\u9ad4\u4e2d\u6587" : "\u7c21\u9ad4\u4e2d\u6587") : (country.indexOf("TW") >= 0 || country.indexOf("HK") >= 0 ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587");
        return ret;
    }

    private static String getNonChineseLocaleDisplayName(String country) {
        String ret = "Chinese";
        if (country == null || country.length() <= 0) {
            country = "CN";
        }
        ret = (country = country.toUpperCase()).indexOf("TW") >= 0 || country.indexOf("HK") >= 0 ? LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils.traditionalChinese") : LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils.simplifiedChinese");
        return ret;
    }

    private static String getPortugueseLocaleDisplayName(String country) {
        String ret = "Portuguese";
        if (country == null || country.length() <= 0) {
            country = "PT";
        }
        ret = (country = country.toUpperCase()).indexOf("BR") >= 0 ? LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils.pt_BR") : LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils.pt");
        return ret;
    }

    public static String[] parseLocales(String localesString) {
        return StringUtils.parseDelimitedString(localesString, LOCALE_SEPARATOR);
    }

    public static String[] getLocalizedFileNames(String nonLocalizedFile, Locale[] locales) {
        String[] ret = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            ret[i] = LocaleUtils.createLocalizedFileName(nonLocalizedFile, locales[i], 3);
        }
        return ret;
    }

    public static String createLocalizedFileName(String nonLocalizedFile, Locale locale, int level) {
        String normalized = CoreFileUtils.normalizeFileName(nonLocalizedFile, '/');
        int pos = normalized.lastIndexOf(46);
        if (pos == -1 || pos < normalized.lastIndexOf(47)) {
            pos = normalized.length();
        }
        String nameLessExt = normalized.substring(0, pos);
        String ext = normalized.substring(pos);
        String localeSpec = "";
        if (locale.getLanguage().length() > 0) {
            localeSpec = localeSpec + "_" + locale.getLanguage();
            if (level > 1 && locale.getCountry().length() > 0) {
                localeSpec = localeSpec + "_" + locale.getCountry();
                if (level > 2 && locale.getVariant().length() > 0) {
                    localeSpec = localeSpec + "_" + locale.getVariant();
                }
            }
        }
        return CoreFileUtils.normalizeFileName(nameLessExt + localeSpec + ext);
    }

    public static Locale findBestMatch(Locale[] locales, Locale target) {
        String sysLanguage = target.getLanguage();
        String sysCountry = target.getCountry();
        String sysVariant = target.getVariant();
        Locale retLocale = null;
        Vector<Locale> vecMatchingLanguage = new Vector<Locale>();
        Vector<Locale> vecMatchingCountry = new Vector<Locale>();
        Vector<Locale> vecMatchingVariant = new Vector<Locale>();
        for (int i = 0; i < locales.length; ++i) {
            String language = locales[i].getLanguage();
            if (!language.equals(sysLanguage)) continue;
            vecMatchingLanguage.addElement(locales[i]);
        }
        Enumeration enumMatchLanguage = vecMatchingLanguage.elements();
        while (enumMatchLanguage.hasMoreElements()) {
            Locale locLocale = (Locale)enumMatchLanguage.nextElement();
            String country = locLocale.getCountry();
            if (!country.equals(sysCountry)) continue;
            vecMatchingCountry.addElement(locLocale);
        }
        Enumeration enumMatchCountry = vecMatchingCountry.elements();
        while (enumMatchCountry.hasMoreElements()) {
            Locale locLocale = (Locale)enumMatchCountry.nextElement();
            String variant = locLocale.getVariant();
            if (!variant.equals(sysVariant)) continue;
            vecMatchingVariant.addElement(locLocale);
        }
        if (vecMatchingVariant.size() > 0) {
            retLocale = (Locale)vecMatchingVariant.elementAt(0);
        } else if (vecMatchingCountry.size() > 0) {
            retLocale = (Locale)vecMatchingCountry.elementAt(0);
        } else if (vecMatchingLanguage.size() > 0) {
            retLocale = (Locale)vecMatchingLanguage.elementAt(0);
        }
        return retLocale;
    }
}

