/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.text.MessageFormat;

public class LocalizedFormatter {
    private static final char SINGLE_QUOTE = '\'';
    private static final char LEFT_BRACE = '{';
    private static final char RIGHT_BRACE = '}';
    private static final State TEXT_STATE = new TextState();
    private static final State SINGLE_QUOTE_STATE = new SingleQuoteState();
    private static final State QUOTED_BRACE_STATE = new QuotedBraceState();
    private static final State MESSAGE_ELEMENT_STATE = new MessageElementState();

    public static String format(String pattern, Object[] args) {
        return MessageFormat.format(LocalizedFormatter.repeatQuotes(pattern), args);
    }

    private static String repeatQuotes(String pattern) {
        int limit = pattern.length();
        StringBuffer buf = new StringBuffer(limit * 2);
        State state = TEXT_STATE;
        for (int i = 0; i < limit; ++i) {
            char c = pattern.charAt(i);
            state.action(c, buf);
            state = state.next(c);
        }
        state.endAction(buf);
        return new String(buf);
    }

    private static class MessageElementState
    extends State {
        private MessageElementState() {
        }

        State next(char c) {
            if (c == '}') {
                return TEXT_STATE;
            }
            return MESSAGE_ELEMENT_STATE;
        }
    }

    private static class QuotedBraceState
    extends State {
        private QuotedBraceState() {
        }

        State next(char c) {
            if (c == '\'') {
                return TEXT_STATE;
            }
            return QUOTED_BRACE_STATE;
        }
    }

    private static class SingleQuoteState
    extends State {
        private SingleQuoteState() {
        }

        void action(char c, StringBuffer buffer) {
            if (c != '\'' && c != '{' && c != '}') {
                buffer.append('\'');
            }
            buffer.append(c);
        }

        void endAction(StringBuffer buffer) {
            buffer.append('\'');
        }

        State next(char c) {
            if (c == '{' || c == '}') {
                return QUOTED_BRACE_STATE;
            }
            return TEXT_STATE;
        }
    }

    private static class TextState
    extends State {
        private TextState() {
        }

        State next(char c) {
            if (c == '\'') {
                return SINGLE_QUOTE_STATE;
            }
            if (c == '{') {
                return MESSAGE_ELEMENT_STATE;
            }
            return TEXT_STATE;
        }
    }

    private static abstract class State {
        private State() {
        }

        void action(char c, StringBuffer buffer) {
            buffer.append(c);
        }

        void endAction(StringBuffer buffer) {
        }

        abstract State next(char var1);
    }
}

