/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.LocalizedFormatter;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedStringResolver {
    public static String resolve(String bundle, String key, String[] args) {
        if (bundle != null && bundle.length() > 0) {
            try {
                return LocalizedStringResolver.resolve(bundle, ResourceBundle.getBundle(bundle), key, args);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "";
    }

    public static String resolve(String bundle, Locale locale, String key, String[] args) {
        if (bundle != null && bundle.length() > 0) {
            try {
                return LocalizedStringResolver.resolve(bundle, ResourceBundle.getBundle(bundle, locale), key, args);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return "";
    }

    private static String resolve(String bundle, ResourceBundle resourceBundle, String key, String[] args) {
        String value = null;
        if (key != null && key.length() > 0) {
            if (resourceBundle != null) {
                value = resourceBundle.getString(key);
                if (value != null && value.length() > 0) {
                    if (args == null) {
                        args = new String[]{};
                    }
                    value = LocalizedStringResolver.formatString(value, args);
                }
            } else {
                value = "\"" + resourceBundle + ", " + key + "\"";
            }
        }
        return value != null ? value : "";
    }

    private static String formatString(String value, String[] args) {
        String retValue;
        try {
            retValue = LocalizedFormatter.format(value, args);
        }
        catch (Throwable th) {
            StringBuffer argDesc = new StringBuffer();
            if (args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    argDesc.append("arguments=");
                    if (i > 0) {
                        argDesc.append(", ");
                    }
                    argDesc.append("\"" + args[i] + "\"");
                }
            } else {
                argDesc.append("no arguments");
            }
            retValue = th + " (message=\"" + value + "\", " + argDesc + ")";
        }
        return retValue;
    }

    public static String resolve(String bundle, String key) {
        return LocalizedStringResolver.resolve(bundle, key, new String[0]);
    }
}

