/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class LogUtils {
    public static final String TEMP_FILE_NAME = "$TEMPFILE";
    private static Log log;

    public static Log getLog() {
        if (log == null) {
            log = new Log(){

                public void logEvent(Object origin, String eventType, Object message) {
                    if (eventType.equals("err") || eventType.equals("wrn") || eventType.equals("err.internal") || eventType.equals("msg1") || eventType.equals("msg2")) {
                        System.out.println("(" + DateFormat.getDateTimeInstance().format(new Date()) + ")" + ", " + origin.getClass().getName() + ", " + eventType + ", " + message);
                    }
                    if (message instanceof Throwable) {
                        ((Throwable)message).printStackTrace(System.out);
                    }
                }
            };
        }
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyLogContents(String srcName, String targetName, boolean append) throws IOException {
        File srcFile;
        if (srcName != null && srcName.trim().length() > 0 && (srcFile = new File(srcName)).exists() && srcFile.length() != 0L) {
            FileInputStream fis = null;
            BufferedReader in = null;
            FileOutputStream fos = null;
            PrintWriter writer = null;
            try {
                fis = new FileInputStream(srcFile);
                in = new BufferedReader(new InputStreamReader(fis));
                fos = new FileOutputStream(targetName, append);
                writer = new PrintWriter(fos);
                String nextLine = null;
                while ((nextLine = in.readLine()) != null) {
                    writer.println(nextLine);
                }
                writer.flush();
            }
            finally {
                if (fis != null && in != null) {
                    try {
                        fis.close();
                        in.close();
                    }
                    catch (Exception genErr) {}
                }
                if (writer != null && fos != null) {
                    try {
                        writer.close();
                        fos.close();
                    }
                    catch (Exception genErr) {}
                }
            }
        }
    }
}

