/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class MD5
extends OutputStream {
    private byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private MD5State state;
    private MD5State finals;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: MD5 <file name>");
            System.exit(1);
        }
        try {
            System.out.println(MD5.toHex(MD5.getHashForFile(args[0])));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static int compare(byte[] digest1, byte[] digest2) {
        for (int i = 0; i < 16; ++i) {
            if ((digest1[i] & 0xFF) < (digest2[i] & 0xFF)) {
                return -1;
            }
            if ((digest1[i] & 0xFF) <= (digest2[i] & 0xFF)) continue;
            return 1;
        }
        return 0;
    }

    public static byte[] getHashForFile(String fileName) throws IOException {
        int read;
        MD5 md5 = new MD5();
        FileInputStream fileIn = new FileInputStream(fileName);
        byte[] buf = new byte[5120];
        while ((read = fileIn.read(buf)) != -1) {
            md5.write(buf, 0, read);
        }
        fileIn.close();
        return md5.toHash();
    }

    public static String toHex(byte[] hash) {
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public MD5() {
        this.clear();
    }

    public synchronized void clear() {
        this.state = new MD5State();
        this.finals = null;
    }

    private final int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private final int uadd(int a, int b) {
        long aa = (long)a & 0xFFFFFFFFL;
        long bb = (long)b & 0xFFFFFFFFL;
        return (int)((aa += bb) & 0xFFFFFFFFL);
    }

    private final int uadd(int a, int b, int c) {
        return this.uadd(this.uadd(a, b), c);
    }

    private final int uadd(int a, int b, int c, int d) {
        return this.uadd(this.uadd(a, b, c), d);
    }

    private final int FF(int a, int b, int c, int d, int x, int s, int ac) {
        a = this.uadd(a, b & c | ~b & d, x, ac);
        return this.uadd(this.rotateLeft(a, s), b);
    }

    private final int GG(int a, int b, int c, int d, int x, int s, int ac) {
        a = this.uadd(a, b & d | c & ~d, x, ac);
        return this.uadd(this.rotateLeft(a, s), b);
    }

    private final int HH(int a, int b, int c, int d, int x, int s, int ac) {
        a = this.uadd(a, b ^ c ^ d, x, ac);
        return this.uadd(this.rotateLeft(a, s), b);
    }

    private final int II(int a, int b, int c, int d, int x, int s, int ac) {
        a = this.uadd(a, c ^ (b | ~d), x, ac);
        return this.uadd(this.rotateLeft(a, s), b);
    }

    private final int[] decode(byte[] buffer, int len, int shift) {
        int[] out = new int[16];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            out[i] = buffer[j + shift] & 0xFF | (buffer[j + 1 + shift] & 0xFF) << 8 | (buffer[j + 2 + shift] & 0xFF) << 16 | (buffer[j + 3 + shift] & 0xFF) << 24;
            ++i;
        }
        return out;
    }

    private final void transform(byte[] buffer, int shift) {
        int a = this.state.state[0];
        int b = this.state.state[1];
        int c = this.state.state[2];
        int d = this.state.state[3];
        int[] x = this.decode(buffer, 64, shift);
        a = this.FF(a, b, c, d, x[0], 7, -680876936);
        d = this.FF(d, a, b, c, x[1], 12, -389564586);
        c = this.FF(c, d, a, b, x[2], 17, 606105819);
        b = this.FF(b, c, d, a, x[3], 22, -1044525330);
        a = this.FF(a, b, c, d, x[4], 7, -176418897);
        d = this.FF(d, a, b, c, x[5], 12, 1200080426);
        c = this.FF(c, d, a, b, x[6], 17, -1473231341);
        b = this.FF(b, c, d, a, x[7], 22, -45705983);
        a = this.FF(a, b, c, d, x[8], 7, 1770035416);
        d = this.FF(d, a, b, c, x[9], 12, -1958414417);
        c = this.FF(c, d, a, b, x[10], 17, -42063);
        b = this.FF(b, c, d, a, x[11], 22, -1990404162);
        a = this.FF(a, b, c, d, x[12], 7, 1804603682);
        d = this.FF(d, a, b, c, x[13], 12, -40341101);
        c = this.FF(c, d, a, b, x[14], 17, -1502002290);
        b = this.FF(b, c, d, a, x[15], 22, 1236535329);
        a = this.GG(a, b, c, d, x[1], 5, -165796510);
        d = this.GG(d, a, b, c, x[6], 9, -1069501632);
        c = this.GG(c, d, a, b, x[11], 14, 643717713);
        b = this.GG(b, c, d, a, x[0], 20, -373897302);
        a = this.GG(a, b, c, d, x[5], 5, -701558691);
        d = this.GG(d, a, b, c, x[10], 9, 38016083);
        c = this.GG(c, d, a, b, x[15], 14, -660478335);
        b = this.GG(b, c, d, a, x[4], 20, -405537848);
        a = this.GG(a, b, c, d, x[9], 5, 568446438);
        d = this.GG(d, a, b, c, x[14], 9, -1019803690);
        c = this.GG(c, d, a, b, x[3], 14, -187363961);
        b = this.GG(b, c, d, a, x[8], 20, 1163531501);
        a = this.GG(a, b, c, d, x[13], 5, -1444681467);
        d = this.GG(d, a, b, c, x[2], 9, -51403784);
        c = this.GG(c, d, a, b, x[7], 14, 1735328473);
        b = this.GG(b, c, d, a, x[12], 20, -1926607734);
        a = this.HH(a, b, c, d, x[5], 4, -378558);
        d = this.HH(d, a, b, c, x[8], 11, -2022574463);
        c = this.HH(c, d, a, b, x[11], 16, 1839030562);
        b = this.HH(b, c, d, a, x[14], 23, -35309556);
        a = this.HH(a, b, c, d, x[1], 4, -1530992060);
        d = this.HH(d, a, b, c, x[4], 11, 1272893353);
        c = this.HH(c, d, a, b, x[7], 16, -155497632);
        b = this.HH(b, c, d, a, x[10], 23, -1094730640);
        a = this.HH(a, b, c, d, x[13], 4, 681279174);
        d = this.HH(d, a, b, c, x[0], 11, -358537222);
        c = this.HH(c, d, a, b, x[3], 16, -722521979);
        b = this.HH(b, c, d, a, x[6], 23, 76029189);
        a = this.HH(a, b, c, d, x[9], 4, -640364487);
        d = this.HH(d, a, b, c, x[12], 11, -421815835);
        c = this.HH(c, d, a, b, x[15], 16, 530742520);
        b = this.HH(b, c, d, a, x[2], 23, -995338651);
        a = this.II(a, b, c, d, x[0], 6, -198630844);
        d = this.II(d, a, b, c, x[7], 10, 1126891415);
        c = this.II(c, d, a, b, x[14], 15, -1416354905);
        b = this.II(b, c, d, a, x[5], 21, -57434055);
        a = this.II(a, b, c, d, x[12], 6, 1700485571);
        d = this.II(d, a, b, c, x[3], 10, -1894986606);
        c = this.II(c, d, a, b, x[10], 15, -1051523);
        b = this.II(b, c, d, a, x[1], 21, -2054922799);
        a = this.II(a, b, c, d, x[8], 6, 1873313359);
        d = this.II(d, a, b, c, x[15], 10, -30611744);
        c = this.II(c, d, a, b, x[6], 15, -1560198380);
        b = this.II(b, c, d, a, x[13], 21, 1309151649);
        a = this.II(a, b, c, d, x[4], 6, -145523070);
        d = this.II(d, a, b, c, x[11], 10, -1120210379);
        c = this.II(c, d, a, b, x[2], 15, 718787259);
        b = this.II(b, c, d, a, x[9], 21, -343485551);
        this.state.state[0] = this.state.state[0] + a;
        this.state.state[1] = this.state.state[1] + b;
        this.state.state[2] = this.state.state[2] + c;
        this.state.state[3] = this.state.state[3] + d;
    }

    public void write(byte[] bytes, int offset, int length) {
        this.write(this.state, bytes, offset, length);
    }

    private void write(MD5State state, byte[] bytes, int offset, int length) {
        int i;
        this.finals = null;
        if (length - offset > bytes.length) {
            length = bytes.length - offset;
        }
        int index = state.count[0] >>> 3 & 0x3F;
        state.count[0] = state.count[0] + (length << 3);
        if (state.count[0] < length << 3) {
            state.count[1] = state.count[1] + 1;
        }
        state.count[1] = state.count[1] + (length >>> 29);
        int partlen = 64 - index;
        if (length >= partlen) {
            for (i = 0; i < partlen; ++i) {
                state.buffer[i + index] = bytes[i + offset];
            }
            this.transform(state.buffer, 0);
            i = partlen;
            while (i + 63 < length) {
                this.transform(bytes, i);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        if (i < length) {
            int start = i;
            while (i < length) {
                state.buffer[index + i - start] = bytes[i + offset];
                ++i;
            }
        }
    }

    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte b) {
        this.write(new byte[]{b}, 0, 1);
    }

    public void write(int i) {
        this.write((byte)i);
    }

    private byte[] encode(int[] input, int len) {
        byte[] out = new byte[len];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            out[j] = (byte)(input[i] & 0xFF);
            out[j + 1] = (byte)(input[i] >>> 8 & 0xFF);
            out[j + 2] = (byte)(input[i] >>> 16 & 0xFF);
            out[j + 3] = (byte)(input[i] >>> 24 & 0xFF);
            ++i;
        }
        return out;
    }

    public synchronized byte[] toHash() {
        if (this.finals == null) {
            MD5State fin = (MD5State)this.state.clone();
            byte[] bits = this.encode(fin.count, 8);
            int index = fin.count[0] >>> 3 & 0x3F;
            int padlen = index < 56 ? 56 - index : 120 - index;
            this.write(fin, this.padding, 0, padlen);
            this.write(fin, bits, 0, 8);
            this.finals = fin;
        }
        return this.encode(this.finals.state, 16);
    }

    public int hashCode() {
        return MD5.toHex(this.toHash()).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MD5 && obj.hashCode() == this.hashCode();
    }

    class MD5State
    implements Cloneable {
        int[] state;
        int[] count;
        byte[] buffer = new byte[64];

        public MD5State() {
            this.count = new int[2];
            this.state = new int[4];
            this.state[0] = 1732584193;
            this.state[1] = -271733879;
            this.state[2] = -1732584194;
            this.state[3] = 271733878;
            this.count[0] = 0;
            this.count[1] = 0;
        }

        public Object clone() {
            try {
                MD5State clone = (MD5State)super.clone();
                System.arraycopy(this.buffer, 0, clone.buffer, 0, this.buffer.length);
                System.arraycopy(this.count, 0, clone.count, 0, this.count.length);
                System.arraycopy(this.state, 0, clone.state, 0, this.state.length);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

