/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.ProcessOutputHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryProcessOutputHandler
implements ProcessOutputHandler {
    private ByteArrayOutputStream stdoutStream;
    private ByteArrayOutputStream stderrStream;
    private int SLEEP_TIME = 5;

    public MemoryProcessOutputHandler(ByteArrayOutputStream stdoutStream, ByteArrayOutputStream stderrStream) {
        this.stdoutStream = stdoutStream;
        this.stderrStream = stderrStream;
    }

    public void processOutputData(InputStream inputStream) {
        if (this.stdoutStream != null) {
            this.stdoutStream.reset();
        }
        this.readProcessStream(inputStream, this.stdoutStream);
    }

    public void processErrorData(InputStream inputStream) {
        if (this.stderrStream != null) {
            this.stderrStream.reset();
        }
        this.readProcessStream(inputStream, this.stderrStream);
    }

    private void readProcessStream(InputStream inputStream, OutputStream outputStream) {
        byte[] buffer = new byte[1024];
        int size = 0;
        try {
            while ((size = inputStream.read(buffer, 0, buffer.length)) != -1) {
                if (outputStream != null) {
                    outputStream.write(buffer, 0, size);
                }
                try {
                    Thread.sleep(this.SLEEP_TIME);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (outputStream == null) continue;
                outputStream.flush();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

