/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.PlatformFactory;
import com.installshield.util.PlatformUtils;
import java.util.Hashtable;
import java.util.Properties;

public class Platform
implements PropertyAccessible {
    private static PlatformFactory factory = null;
    public static final Platform currentPlatform = new Platform();
    private String displayName = "All Platforms";
    private String name = ".*";
    private String version = ".*";
    private String arch = ".*";
    private String parentDisplayName = "";
    private Properties extendedInfo = new Properties();

    public static void main(String[] args) {
        System.out.println("os.name: " + System.getProperty("os.name"));
        System.out.println("os.version: " + System.getProperty("os.version"));
        System.out.println("os.arch: " + System.getProperty("os.arch"));
    }

    public static void setPlatformFactory(PlatformFactory factory) {
        Platform.factory = factory;
    }

    public static PlatformFactory getPlatformFactory() {
        return factory;
    }

    public Platform() {
    }

    public Platform(String name, String version, String arch, String displayName) {
        this.setDisplayName(displayName);
        this.setName(name);
        this.setVersion(version);
        this.setArch(arch);
    }

    public Platform(String name, String version, String arch, String displayName, String parentDisplayName) {
        this(name, version, arch, displayName);
        this.setParentDisplayName(parentDisplayName);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setName(String name) {
        this.name = name != null ? name : ".*";
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String version) {
        this.version = version != null ? version : ".*";
    }

    public String getVersion() {
        return this.version;
    }

    public void setArch(String arch) {
        this.arch = arch != null ? arch : ".*";
    }

    public String getArch() {
        return this.arch;
    }

    public void setParentDisplayName(String parent) {
        this.parentDisplayName = parent != null ? parent : "";
    }

    public String getParentDisplayName() {
        return this.parentDisplayName;
    }

    public String getExtendedInfo() {
        return PlatformUtils.encodeExtendedPlatformInfo(this.extendedInfo);
    }

    public void setExtendedInfo(String extendedInfo) {
        this.extendedInfo = PlatformUtils.decodeExtendedPlatformInfo(extendedInfo);
    }

    public Properties getExtendedInfoAsProperties() {
        return this.extendedInfo;
    }

    public void setExtendedInfoAsProperties(Properties extendedInfo) {
        this.extendedInfo = extendedInfo;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("displayName=" + this.displayName + ";");
        buf.append("name=" + this.name + ";");
        buf.append("version=" + this.version + ";");
        buf.append("arch=" + this.arch + ";");
        buf.append("parent=" + this.parentDisplayName);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Platform)) {
            return false;
        }
        return this.name.equals(((Platform)obj).getName()) && this.version.equals(((Platform)obj).getVersion()) && this.arch.equals(((Platform)obj).getArch()) && this.parentDisplayName.equals(((Platform)obj).getParentDisplayName()) && ((Hashtable)this.extendedInfo).equals(((Platform)obj).getExtendedInfoAsProperties());
    }

    static {
        currentPlatform.setName(System.getProperty("os.name"));
        currentPlatform.setVersion(System.getProperty("os.version"));
        currentPlatform.setArch(System.getProperty("os.arch"));
    }
}

