/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.Platform;
import com.installshield.util.StringUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PlatformUtils {
    private static final String PLATFORM_ENTRY_DELIM = "@@";
    private static final String EXTENDED_INFO_DELIM = "!!";
    private static final String NAME_VALUE_PAIR_DELIM = ";";
    private static final String NAME_VALUE_DELIM = "=";

    public static Platform[] decodePlatforms(String platformString) {
        if (platformString == null) {
            return new Platform[0];
        }
        String[] platformEntries = StringUtils.parseDelimitedString(platformString, PLATFORM_ENTRY_DELIM);
        Platform[] platforms = new Platform[platformEntries.length];
        for (int i = 0; i < platformEntries.length; ++i) {
            String curEntry = platformEntries[i];
            Platform curPlatform = new Platform();
            int extInfoIndex = curEntry.indexOf(EXTENDED_INFO_DELIM);
            if (extInfoIndex != -1) {
                String basicPlatformInfo = curEntry.substring(0, extInfoIndex);
                String extPlatformInfo = curEntry.substring(++extInfoIndex);
                PlatformUtils.decodeBasicPlatformInfo(basicPlatformInfo, curPlatform);
                curPlatform.setExtendedInfo(extPlatformInfo);
            } else {
                PlatformUtils.decodeBasicPlatformInfo(curEntry, curPlatform);
            }
            platforms[i] = curPlatform;
        }
        return platforms;
    }

    private static void decodeBasicPlatformInfo(String basicInfoString, Platform curPlatform) {
        String[] nameValPairs = StringUtils.parseDelimitedString(basicInfoString, NAME_VALUE_PAIR_DELIM);
        block7: for (int j = 0; nameValPairs.length == 5 && j < nameValPairs.length; ++j) {
            int delimIndex = nameValPairs[j].indexOf(NAME_VALUE_DELIM);
            String value = nameValPairs[j].substring(++delimIndex);
            switch (j) {
                case 0: {
                    curPlatform.setDisplayName(value);
                    continue block7;
                }
                case 1: {
                    curPlatform.setName(value);
                    continue block7;
                }
                case 2: {
                    curPlatform.setVersion(value);
                    continue block7;
                }
                case 3: {
                    curPlatform.setArch(value);
                    continue block7;
                }
                case 4: {
                    curPlatform.setParentDisplayName(value);
                }
            }
        }
    }

    public static String encodePlatforms(Platform[] platforms) {
        String platformString = "";
        for (int i = 0; i < platforms.length; ++i) {
            platformString = platformString + PLATFORM_ENTRY_DELIM;
            platformString = platformString + platforms[i];
            platformString = platformString + EXTENDED_INFO_DELIM;
            platformString = platformString + platforms[i].getExtendedInfo();
        }
        return platformString;
    }

    public static Properties decodeExtendedPlatformInfo(String extendedInfo) {
        Properties ret = new Properties();
        if (extendedInfo != null) {
            String[] nameValuePairs = StringUtils.parseDelimitedString(extendedInfo, NAME_VALUE_PAIR_DELIM);
            for (int i = 0; i < nameValuePairs.length; ++i) {
                String curPair = nameValuePairs[i];
                int index = curPair.indexOf(NAME_VALUE_DELIM);
                if (index == -1) continue;
                String varName = curPair.substring(0, index);
                String varValue = curPair.substring(++index);
                ret.setProperty(varName, varValue);
            }
        }
        return ret;
    }

    public static String encodeExtendedPlatformInfo(Properties extendedInfo) {
        String ret = "";
        int numElems = 0;
        if (extendedInfo != null) {
            Enumeration keys = ((Hashtable)extendedInfo).keys();
            while (keys.hasMoreElements()) {
                String varName = (String)keys.nextElement();
                String varValue = extendedInfo.getProperty(varName);
                ret = ret + varName + NAME_VALUE_DELIM + varValue;
                if (++numElems == ((Hashtable)extendedInfo).size()) continue;
                ret = ret + NAME_VALUE_PAIR_DELIM;
            }
        }
        return ret;
    }
}

